import ez_setup
ez_setup.use_setuptools()
from setuptools import setup, find_packages
import subprocess
import sys
from xml.etree.ElementTree import ElementTree


# Find version of package from darcs changelog
if subprocess.call(['darcs', 'whatsnew']) == 0:
    print >> sys.stderr, 'Please check in the code first'
    sys.exit()

changelog = ElementTree().parse(subprocess.Popen(
                ["darcs", "changes", "--xml-output"],
                stdout=subprocess.PIPE).stdout)
patch = changelog.find("patch")
patchname = patch.find('name').text
version = patchname[4:] if patchname.startswith('TAG') else patch.get('date')

setup(
    name = "ftd2xx",
    version = version,
    packages = find_packages(),

    # metadata for upload to PyPI
    author = "Satya Mishra",
    author_email = "qufgmx@gmail.com",
    description = "Python interface to ftd2xx.dll from FTDI using ctypes based on d2xx by Pablo Bleyer",
    license = "PSF",
    keywords = "ftd2xx d2xx",
    url = "",   # project home page, if any
    zip_safe=False,
    test_suite="ftd2xx.tests.t_ftd2xx",
    # could also include long_description, download_url, classifiers, etc.
)
