from setuptools import setup, find_packages
import os

version = '1.1.0'

tests_require = ['ftw.testbrowser',
                 'ftw.builder',
                 'ftw.testing',
                 'plone.app.testing',
                 'ftw.downloadtoken[journal]'
                 ]
journal_require = ['ftw.journal',
                   ]
setup(name='ftw.downloadtoken',
      version=version,
      description='Grants temporary access to a specific downloadable '
                  'content.',
      long_description=open("README.rst").read() + "\n" +
                       open(os.path.join("docs", "HISTORY.txt")).read(),

      # Get more strings from
      # http://www.python.org/pypi?%3Aaction=list_classifiers
      classifiers=[
        'Framework :: Plone',
        'Framework :: Plone :: 4.1',
        'Framework :: Plone :: 4.2',
        'Framework :: Plone :: 4.3',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules',
        ],

      keywords='',
      author='4teamwork AG',
      author_email='mailto:info@4teamwork.ch',
      url='https://github.com/4teamwork/ftw.downloadtoken',
      license='GPL2',

      packages=find_packages(exclude=['ez_setup']),
      namespace_packages=['ftw'],
      include_package_data=True,
      zip_safe=False,
      tests_require=tests_require,
      extras_require=dict(tests=tests_require, journal=journal_require),

      install_requires=[
          'setuptools',
          'ftw.sendmail',
          'plone.api',
      ],
      entry_points="""
      # -*- Entry points: -*-
      [z3c.autoinclude.plugin]
      target = plone
      """,
      )
