from plone.app.testing import FunctionalTesting
from plone.app.testing import IntegrationTesting
from plone.app.testing import PLONE_FIXTURE
from plone.app.testing import PloneSandboxLayer
from plone.app.testing import applyProfile
from zope.configuration import xmlconfig


class SolrLayer(PloneSandboxLayer):

    defaultBases = (PLONE_FIXTURE, )

    def setUpZope(self, app, configurationContext):
        import z3c.autoinclude
        xmlconfig.file('meta.zcml', z3c.autoinclude,
                       context=configurationContext)
        xmlconfig.string(
            '<configure xmlns="http://namespaces.zope.org/zope">'
            '  <includePlugins package="plone" />'
            '</configure>',
            context=configurationContext)

        import ftw.solr
        self.loadZCML(name="overrides.zcml", package=ftw.solr)

    def setUpPloneSite(self, portal):
        applyProfile(portal, 'ftw.solr:default')


SOLR_FIXTURE = SolrLayer()
SOLR_INTEGRATION_TESTING = IntegrationTesting(
    bases=(SOLR_FIXTURE, ), name="ftw.solr:integration")
SOLR_FUNCTIONAL_TESTING = FunctionalTesting(
    bases=(SOLR_FIXTURE, ), name="ftw.solr:functional")
