
class AsciiEscape(object):
    _on = ''
    _off = ''
    def __init__(self, name, on, off=0):
        self.name = name
        self._on = '\033[{0}m'.format(on)
        self._off = '\033[{0}m'.format(off) 
    
    @property
    def on(self):
        return self._on

    @property
    def off(self):
        return self._off

    def __call__(self, input='', end=False):
        if end:
            return self.on + input + self.off
        else:
            return self.on + input

    def __str__(self):
        return self.on

    def __repr__(self):
        return '<AsciiEscape {0}>'.format(self.name)

    def sample(self):
        return self(self.name, True)



END = AsciiEscape('END', 0)

BOLD = AsciiEscape('BOLD', 1, 22)
ITALIC = AsciiEscape('ITALIC', 3, 23)
UNDERLINE = AsciiEscape('UNDERLINE', 4, 24)
INVERSE = AsciiEscape('INVERSE', 7, 27)
STRIKETHROUGH = AsciiEscape('STRIKETHROUGH', 9, 29)

BLACK = AsciiEscape('BLACK', 30)
RED = AsciiEscape('RED', 31)
GREEN = AsciiEscape('GREEN', 32)
YELLOW = AsciiEscape('YELLOW', 33)
BLUE = AsciiEscape('BLUE', 34)
MAGENTA = AsciiEscape('MAGENTA', 35)
CYAN = AsciiEscape('CYAN', 36)
WHITE = AsciiEscape('WHITE', 37)
DEFAULT = AsciiEscape('DEFAULT', 39)

GRAY = AsciiEscape('GRAY', '1;30')
LITEWHITE = AsciiEscape('LITEWHITE', '1;37')
LITERED = AsciiEscape('LITERED', '1;31')



BBLACK = AsciiEscape('BBLACK', 40)
BRED = AsciiEscape('BRED', 41)
BGREEN = AsciiEscape('BGREEN', 42)
BYELLOW = AsciiEscape('BYELLOW', 43)
BBLUE = AsciiEscape('BBLUE', 44)
BMAGENTA = AsciiEscape('BMAGENTA', 45)
BCYAN = AsciiEscape('BCYAN', 46)
BWHITE = AsciiEscape('BWHITE', 47)
BDEFAULT = AsciiEscape('BDEFAULT', 49)



# -----------------------------------------------------------------------------

if __name__ == '__main__':

    print UNDERLINE.sample()
    print BWHITE(BLACK.sample(), True)
    print BBLUE(GREEN.sample(), True)

    print 'My name is ' + BOLD(UNDERLINE('Mark', True), True) + ' and I ' + BMAGENTA(GREEN('LOVE'), True) + ' python!'

    print 'Change ' + UNDERLINE(GREEN('colors') + CYAN(' mid-stream')) + END()

    print GRAY('THIS IS GRAY TEXT', True)
    print LITEWHITE('THIS IS LITE-WHITE', True)
    print RED('THIS IS RED', True)
    print LITERED('THIS IS LITE-RED', True)
    print 

    colors = (BWHITE, BGREEN, BCYAN, BMAGENTA, BYELLOW)
    from random import randint
    for x in range(20):
        val = 80 
        output = '' 
        while val > 0:
            repeat = randint(1,5)
            if ( val - repeat ) < 0:
                repeat = val
            output += colors[randint(0,4)](' '*repeat)
            output += END()
            val -= repeat
        print output


'''ack
rak
nak
pak
pck
far
par
pha
pha
pha
fur

'''
