import shutil

# ------------------------------------------------------------------------------

class FileUpdater(object):
    """ docstring for FileUpdater
    """
    def __init__(self, file_info):
        self.file_info = file_info

    def update(self, regex):
        f = open(self.file_info.path, 'r')    
        lines = f.readlines()
        f.close()
        replacement_count = 0 
        for i in range(len(lines)):
            if i in self.file_info.matches:
                match = self.file_info.matches[i]
                if match.do_replace:
                    lines[i] = regex.replace(match.line_str)
                    replacement_count += 1
        if replacement_count > 0:
            #XXX : NEED ERROR CAPTURE HERE
            self._backup_old_file()
            self._write_new_file(lines)

        return replacement_count
    
    def _write_new_file(self, lines):
        with open(self.file_info.path, 'w') as f:
            f.write(''.join(lines))

    def _backup_old_file(self):
        shutil.copy2(self.file_info.path, self.file_info.path + '.bak')

