import fetch
import replace
import utils
import rules
from ascii import *


_delta = None



# -----------------------------------------------------------------------------

class Command(object):
    
    def __init__(self, query):
        self._query = query
        self._options = {}

    def add_option(self, option, command, loop=False):
        self._options[option] = (command, loop)
    
    def __call__(self, *args, **kwargs):
        loop=True
        while loop:
            answer = raw_input(self._query)
            command, loop = self._get_options(answer)
            if command:
                command(*args, **kwargs)
            else:
                print "'{0}' is not a recognized options.".format(answer) 

    def _get_options(self, answer):
         for opt, cmd in self._options.items():
            if answer.upper() in opt:
                return cmd
         return None, True

           
# -----------------------------------------------------------------------------

def set_delta(delta):
    global _delta
    _delta = delta

# -----------------------------------------------------------------------------

def set_do_replace(rmi):
    rmi.do_replace=True

def do_not_replace(rmi):
    rmi.do_replace=False

def replace_all(options, matches, regex, files):
    for fi in matches:
        for rmi in fi.matches.values():
            set_do_replace(rmi)

    do_replacements(matches, regex)

def replace_iterate(options, matches, regex, files):

    cmd = Command('apply change? (y/n) ')
    cmd.add_option(('Y'), set_do_replace) 
    cmd.add_option(('N'), do_not_replace) 

    for fi in matches:
        for rmi in fi.matches.values():
            print_matching_file(fi)
            print_matching_line(rmi)
            print_replacement_line(rmi, regex)
            
            cmd(rmi)

    do_replacements(matches, regex)

def do_replacements(matches, regex):
    file_count = 0
    rep_count = 0
    for fi in matches:
        updater = replace.FileUpdater(fi)
        cnt = updater.update(regex)
        if cnt > 0:
            file_count += 1
            rep_count += cnt

    print '*'*50
    print '{0} replacements made in {1} files.'.format(rep_count, file_count)


# -----------------------------------------------------------------------------

def print_matching_file(fi):
    print ''
    print '{0} {1}({2}){3}'.format(
        UNDERLINE(GREEN(fi.file_name, True), True),
        BLUE(), 
        fi.dir_path, 
        END())
 
def print_matching_line(rmi):
    print ' {0:0>4d}: {1}'.format(
        rmi.line_no, 
        BOLD(rmi.line_str.rstrip(), True))
            
def print_replacement_line(rmi, regex):
    new_line = regex.replace(rmi.line_str.rstrip())
    print '     - {0}'.format(YELLOW(new_line, True))

def print_row(title, info, padding=15, char=' '):
    print title.ljust(padding, char) + '{0}'.format(info)

def show_header(options, matches, regex, files=''):

    print '-'*50
    char = '.'
    padding = 18 

    print_row('expression', regex, padding, char)
    print_row('matching files', len(files), padding, char)
    print_row('execution time', _delta, padding, char)
    print_row('file matches', len(matches), padding, char)

    match_total = reduce(lambda x, y: x + y, [p.count() for p in matches], 0) 
    print_row('line matches', match_total, padding, char)

    print '-'*50


def show_details(options, matches, regex):
    for det in matches:
        print_matching_file(det)
        keys = det.matches.keys()
        keys.sort()
        #for m in det.matches.values():
        for k in keys:
            m = det.matches[k]
            print_matching_line(m)
            if options.sub:
                print_replacement_line(m, regex)
    print ''
    raw_input('continue....')
    print ''

def show(options, matches, regex, files=''):
    show_header(options, matches, regex, files)
    show_details(options, matches, regex)
    show_header(options, matches, regex, files)

def show_review(options, matches, regex, files=''):
    show_details(options, matches, regex)
    show_header(options, matches, regex, files)

def exit(*args, **kwargs):
    pass

# -----------------------------------------------------------------------------

def find_und_replace(options):

    watch = utils.StopWatch()
    watch.start()

    regex = fetch.Regex(options.expression, options)

    files = fetch.FileList(options.root)
    files.add_dir_rule(rules.ExcludeDirectoryRule(options.exclude_dirs))
    files.add_file_rule(rules.AcceptableFileTypes(options.accept_file_types))
    files.harvest()

    matches = fetch.MatchList(regex)
    matches.harvest(files)

    watch.stop()

    set_delta(str(watch))
    
    print ''
    show_header(options, matches, regex, files)

    if len(matches) == 0:
        command = Command("Exit (x)  ")
        command.add_option(('X','Q','',None), exit)
    if options.sub is None:
        command = Command("Show (v) or exit (x)?  ")
        command.add_option(('V',), show_review, loop=True)
        command.add_option(('X','Q','',None), exit)
    else:
        command = Command("Show (v), replace all (r), iterate (i) or exit (x)?  ")
        command.add_option(('V',), show_review, loop=True)
        command.add_option(('R',), replace_all)
        command.add_option(('I',), replace_iterate)
        command.add_option(('X','Q','',None), exit)

    command(options, matches, regex, files)

    print ''


# -----------------------------------------------------------------------------

if __name__ == '__main__': 

    import os
    import shutil

    class Options: pass
    options = Options()
    options.sub="XXXXXXXXX"

    options.root='/Users/mark/tmp/fur'
    options.expression='mark'
    options.exclude_dirs=[]
    options.accept_files=['.py','.txt']

    shutil.rmtree(options.root)
    os.mkdir(options.root)

    for i in range(1,10):
        with open(os.path.join(options.root, 'temp_' + str(i) + '.py'), 'w') as f:
            f.write('My name is mark.\n\nWhat is your name?\nMy name is mark.\n')

    find_und_replace(options)


