'''Wrap up calls to git.
'''
import os
from os.path import split, join, exists
from subprocess import Popen, PIPE, STDOUT

class Git(object):
    
    def __init__(self, file_path):
        self.file_path = file_path
        self.on_version_path = False
        self.git_root = ''
        self._gitable(self.file_path)

    def _gitable(self, file_path):
        '''Does a git repository exist anywhere on
        the given file's path?
        '''
        tail = 'is not None' 
        while tail:
            file_path, tail = split(file_path)
            if exists(join(file_path, '.git')):
                self.git_root = file_path
                self.on_version_path = True
                return

    def add(self):
        if self.on_version_path:
            os.chdir(split(self.file_path)[0])
            cmd = ['git', 'add', self.file_path]
            proc = Popen(cmd, stdout=PIPE)
            proc.stdout.read()     



    


# -----------------------------------------------------------------------------

if __name__ == '__main__':
    
    input = '/Users/mark/dev/python/utils/git_box.py'
    gitized = Git(input)
    print gitized.git_root

