'''Miscellaneous support classes and functions.
'''
from datetime import datetime 


# -----------------------------------------------------------------------------

class StopWatch(object):
    '''Timer for search excution.

    Currently assumes the start, stop and seconds methods are called
    in that order. I.e. no checking for miss-use.
    
    Initializes to the current time.
    '''
    def __init__(self):
        self.start_time = datetime.today()
        self.end_time = self.start_time 
        self.delta = self._delta() 

    def _delta(self):
        '''Record the delta.'''
        return self.end_time - self.start_time
        
    def start(self, manual=None):
        '''Record the start time.'''
        if manual:
            self.start_time = manual 
        else:
            self.start_time = datetime.today()

    def stop(self, manual=None):
        '''Record the end time.'''
        if manual:
            self.end_time = manual 
        else:
            self.end_time = datetime.today()
        self.delta = self._delta()

    @property
    def seconds(self):
        return self.delta.seconds + (self.delta.microseconds / 1000000.00)     

    def __str__(self):
        return '{0} seconds'.format(round(self.seconds, 2)) 

    def __repr__(self):
        return '<StopWatch {0}>'.format(self)
