from os.path import sep, split


# -----------------------------------------------------------------------------

class AcceptableFileTypes(object):
    
    def __init__(self, file_list):
        self.file_list = file_list

    def __call__(self, file_info):
        return file_info.ext in self.file_list


# -----------------------------------------------------------------------------

class ExcludeDirectoryRule(object):
    
    def __init__(self, dir_list):
        self.dir_list = dir_list

    def __call__(self, path):
        parts = split(sep)
        return any(p in self.dir_list for p in parts)

