# -*- coding: utf-8 -*-
"""
Tests for the various utility functions and classes in ``future.utils``
"""

from __future__ import absolute_import, unicode_literals, print_function
from future.builtins import *
from future.utils import old_div, isint, istext, isbytes, native, PY2, PY3

from numbers import Integral
from future.tests.base import unittest

TEST_UNICODE_STR = u'ℝεα∂@ßʟ℮ ☂ℯṧт υηḯ¢☺ḓ℮'


class TestUtils(unittest.TestCase):
    def setUp(self):
        self.s = TEST_UNICODE_STR
        self.s2 = str(self.s)
        self.b = b'ABCDEFG'
        self.b2 = bytes(self.b)

    def test_old_div(self):
        """
        Tests whether old_div(a, b) is always equal to Python 2's a / b.
        """
        self.assertEqual(old_div(1, 2), 0)
        self.assertEqual(old_div(2, 2), 1)
        self.assertTrue(isint(old_div(2, 2)))

        self.assertEqual(old_div(3, 2), 1)
        self.assertTrue(isint(old_div(3, 2)))

        self.assertEqual(old_div(3., 2), 1.5)
        self.assertTrue(not isint(old_div(3., 2)))

        self.assertEqual(old_div(-1, 2.), -0.5)
        self.assertTrue(not isint(old_div(-1, 2.)))

        with self.assertRaises(ZeroDivisionError):
            old_div(0, 0)
        with self.assertRaises(ZeroDivisionError):
            old_div(1, 0)

    def test_native(self):   
        a = int(10**20)     # long int
        b = native(a)
        self.assertEqual(a, b)
        if PY2:
            self.assertEqual(type(b), long)
        else:
            self.assertEqual(type(b), int)
    
        c = bytes(b'ABC')
        d = native(c)
        self.assertEqual(c, d)
        if PY2:
            self.assertEqual(type(d), type(b'Py2 byte-string'))
        else:
            self.assertEqual(type(d), bytes)
    
        s = str(u'ABC')
        t = native(s)
        self.assertEqual(s, t)
        if PY2:
            self.assertEqual(type(t), unicode)
        else:
            self.assertEqual(type(t), str)
        type(s)

    def test_istext(self):
        self.assertTrue(istext(self.s))
        self.assertTrue(istext(self.s2))
        self.assertFalse(istext(self.b))
        self.assertFalse(istext(self.b2))

    def test_isbytes(self):
        self.assertTrue(isbytes(self.b))
        self.assertTrue(isbytes(self.b2))
        self.assertFalse(isbytes(self.s))
        self.assertFalse(isbytes(self.s2))


if __name__ == '__main__':
    unittest.main()
