#------------------------------------------------------------------------------
# Copyright (c) 2010, Kurt W. Smith
# 
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
# 
#     * Redistributions of source code must retain the above copyright notice,
#       this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the Fwrap project nor the names of its contributors
#       may be used to endorse or promote products derived from this software
#       without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#------------------------------------------------------------------------------

from fwrap import code

from nose.tools import ok_, eq_, set_trace

import sys
from pprint import pprint

# 1) Any non-comment line can be broken anywhere -- in the middle of words,
#    etc.
# 2) Comments are stripped out of the source and are to be ignored in reflowing
#    text.

def test_breakup():
    line = ("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa "
            "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")

    for chunk in (1, 2, 3, 5, 10, 20, 50, len(line)):
        yield breakup_gen, line, chunk

def breakup_gen(line, chunk):
    ret = code.reflow_line(line, 0, chunk)
    eq_(simple_break(line, chunk), ret)
    for part in ret[1:-1]:
        eq_(len(part), chunk+2)
    if len(ret) == 1:
        eq_(len(ret[0]), len(line))
    else:
        eq_(len(ret[0]), chunk+1)
        ok_(len(ret[-1]) <= chunk+1)
    orig = ''.join(ret)
    orig = orig.replace('&', '')
    eq_(orig, line)

def simple_break(text, chunk):
    i = 0
    test_ret = []
    while True:
        test_ret.append('&'+text[i*chunk:(i+1)*chunk]+'&')
        if (i+1)*chunk >= len(text):
            break
        i += 1

    test_ret[0] = test_ret[0][1:]
    test_ret[-1] = test_ret[-1][:-1]
    # set_trace()
    return test_ret

def test_nobreak():
    line = ("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa")
    ret = code.reflow_line(line, 0, 100)
    eq_(ret, [line])

def test_indent():
    line = "12345678901234567890"
    ret = code.reflow_line(line, 1, 100)
    eq_(ret, [code.INDENT+line])
    ret = code.reflow_line(line, 1, 10)
    eq_(ret, [code.INDENT+line[:8]+'&',
              code.INDENT+'&'+line[8:16]+'&',
              code.INDENT+'&'+line[16:]])
def test_reflow():
    reflow_src = ("subroutine many_args(a0, a1, a2, a3, a4, a5, a6, a7, a8, "
                  "a9, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30"
                  ", a31, a32, a33, a34, a35, a36, a37, a38, a39, a40, a41, "
                  "a42, a43, a44, a45, a46, a47, a48, a49)\n"
                  "    implicit none\n"
                  "    integer, intent(in) :: a0, a1, a2, a3, a4, a5, a6, "
                  "a7, a8, a9, a20, a21, a22, a23, a24, a25, a26, a27, a28, "
                  "a29, a30, a31, a32, a33, a34, a35, a36, a37, a38, a39, "
                  "a40, a41, a42, a43, a44, a45, a46, a47, a48, a49\n"
                  "end subroutine many_args")

    buf = code.CodeBuffer()
    buf.putline(code.reflow_fort(reflow_src))
    for line in buf.getvalue().splitlines():
        ok_(len(line) <= 79, "len('%s') > 79" % line)



