import os
import re
import sys
import inspect
import pkg_resources

from distutils.sysconfig import get_python_lib
from utils import logger


def list(req_file):
	with open(req_file, 'r') as file:
		requirements = [req for req in pkg_resources.parse_requirements(file.read())]

	for requirement in requirements:
		print requirement


def link(req_file, lib_dir):
	with open(req_file, 'r') as file:
		requirements = [req for req in pkg_resources.parse_requirements(file.read())]

	links = []
	package_path = get_python_lib()
	for requirement in requirements:
		try:
			dist = pkg_resources.get_provider(requirement)
		except pkg_resources.DistributionNotFound:
			logger.warn(' * Please install [%s]' % requirement)
			continue
		except pkg_resources.VersionConflict:
			logger.warn(' * Version don\'t match [%s] - create virtualenv or match the version' % requirement)
			continue

		if dist.has_metadata('top_level.txt'):
			links.extend(dist.get_metadata_lines('top_level.txt'))

		if dist.has_metadata('dependency_links.txt'):
			links.extend(dist.get_metadata_lines('dependency_links.txt'))

	# Now we create the links
	if links:
		libs = lib_dir
		if not os.path.exists(libs):
			os.makedirs(libs)

		with open(os.path.join(libs, '__init__.py'), 'wb') as f:
			f.write((
				"# Auto generated by gaeenv\n"
				"import sys\n"
				"import os\n"
				"sys.path.insert(0, os.path.dirname(__file__))\n"))

		for link in links:
			link = link.strip()
			symlink = os.path.join(package_path, link)
			if not os.path.exists(symlink) and os.path.exists(symlink + '.py'):
				symlink += '.py'
				dest = os.path.join(libs, link + '.py')
			else:
				dest = os.path.join(libs, link)

			if os.path.exists(symlink) and not os.path.exists(dest):
				os.symlink(symlink, dest)

			logger.info(' * Found and linked: %s' % link)
