import os
import re
import sys
import inspect
import pkg_resources

from distutils.sysconfig import get_python_lib
from utils import logger


def list(req_file):
	with open(req_file, 'r') as file:
		requirements = [req for req in pkg_resources.parse_requirements(file.read())]

	for requirement in requirements:
		print requirement


def link(req_file, lib_dir):
        # read requirements file
        with open(req_file, 'r') as file:
                requirements = [req for req in pkg_resources.parse_requirements(file.read())]

        # ensure all requirements are installed
        has_missing_requirement = False
        packages = []
        for requirement in requirements:
                try:
                        packages.append(pkg_resources.get_provider(requirement))
                except pkg_resources.DistributionNotFound:
                        has_missing_requirement = True
                        logger.error(' * Please install [%s]' % requirement)
                except pkg_resources.VersionConflict:
                        has_missing_requirement = True
                        logger.error(' * Version don\'t match [%s] - create virtualenv or match the version' % requirement)

        # if all requirements are found then create links to them all in the given libs dir
        if not has_missing_requirement:
                # create libs dir
                if not os.path.exists(lib_dir):
                        os.makedirs(lib_dir)

                # create new package file in the given libs dir
                with open(os.path.join(lib_dir, '__init__.py'), 'wb') as f:
                        f.write((
                                "# Auto generated by gaeenv\n"
                                "import sys\n"
                                "import os\n"
                                "sys.path.insert(0, os.path.dirname(__file__))\n"))

                for pkg in packages:
                        pkg_path = os.path.join(pkg.location, pkg.key)
                        sym_path = os.path.join(lib_dir, pkg.key)
                        # check if we are dealing with a file or directory package
                        is_file = (not os.path.exists(pkg_path) and os.path.exists(pkg_path + '.py'))

                        # add extension if we are dealing with a file
                        if is_file:
                                pkg_path = pkg_path + '.py'
                                sym_path = sym_path + '.py'

                        if os.path.islink(sym_path):
                                os.unlink(sym_path)

                        if os.path.exists(sym_path):
                                logger.error(' * Unable to link [%s] because a file already exists at [%s]' % (pkg, sym_path))
                        else:
                                logger.info(' * Linking [%s] in [%s]' % (pkg_path, sym_path))
                                os.symlink(pkg_path, sym_path)
