#!/usr/bin/env python
#coding: utf-8

import sys

from ConfigParser import ConfigParser
from argparse     import ArgumentParser

from utils.divergence import Divergence

desc = "GAEinit support initialize of GAE prject"

parser = ArgumentParser(description=desc, prog="gaeinit")

# set ini file
parser.add_argument("-s", "--set", action="store", dest="inifile", help="Use this command before using the gaeinit, register the ini file.")

# initialize option
parser.add_argument("-c", "--compile", action="store_true", help="Compile ini file and launch GAE project.")

# server option
parser.add_argument("-r", "--run-sever", action="store_true", dest="run", help="Run development server on application name. To use this option, you must set up a symbolic link of dev_appserver.py")
parser.add_argument("-os", "--run-server-with-option", action="store", dest="option", help="Run development server with option. To use this option, you must set up a symbolic link of dev_appserver.py")

# make new gae project file
parser.add_argument("-n", "--new-file", action="store", dest="filepath", help="Create new file of GAE project. please set file path that contain file name on argument.")

# make config.ini template file
parser.add_argument("-ct", "--config-temp", action="store_true", dest="configtemp", help="Create template of config.ini file.")

args = parser.parse_args()
if len(sys.argv) == 1:
	parser.parse_args(["./gaeinit.py", "-h"])

Divergence(args).launch()

