#!/usr/bin/env python
#coding: utf-8

# template strings of app.yaml
APP_YAML_TEMP = """application: %(appname)s
version: %(version)s
runtime: python
api_version: 1

handlers:
- url: .*
  script: %(mainscript)s"""

# template strings of index.yaml 
INDEX_YAML_TEMP = """indexes:

# AUTOGENERATED

# This index.yaml is automatically updated whenever the dev_appserver
# detects that a new type of query is run.  If you want to manage the
# index.yaml file manually, remove the above marker line (the line
# saying "# AUTOGENERATED").  If you want to manage some indexes
# manually, move them above the marker line.  The index.yaml file is
# automatically uploaded to the admin console when you next deploy
# your application using appcfg.py."""

# template strings of main script
MAIN_SCRIPT_TEMP = """#!/usr/bin/env python
#coding: utf-8

(user_modules)
from google.appengine.ext 	 import webapp, db
from google.appengine.ext.webapp import util
from webapp			 import webHandler 

class Main(webHandler):
	def get(self):
		self.write("<h1>Hello Google App Engine!</h1>")

app = webapp.WSGIApplication(
	[
		("/", Main)
	], debug=True)

if __name__ == "__main__":
	util.run_wsgi_app(app)"""

# template strings of webhandler.py
WEBHANDLER_TEMP="""#!/usr/bin/env python
#coding: utf-8

from google.appengine.ext import webapp

class webHandler(webapp.RequestHandler):
	def write(self, var):
		if isinstance(var, str):
			self.response.out.write(var)
		elif isinstance(var, tuple):
			for string in var:
				self.response.out.write(string)
		elif isinstance(var, list):
			for string in var:
				self.response.out.write(string)

		elif isinstance(var, dict):
			self.response.out.write(repr(var))
"""

# template strings of nomal script.
NOMAL_SCRIPT_TEMP = """#!/usr/bin/env python
#coding: utf-8

(user_modules)
try:
	from webhandler import webHandler
except ImportError:
	from google.appengine.ext.webapp import RequestHandler as webHandler

class Handler(webHandler):
	def get(self):
		pass

"""

# template strings of config.ini file.
CONFIG_TEMP = """[application settings]
appname = ; application name
version = ; number of version
mainscript = ; filename of main script

[file settings]
encoding = ; file encoding
directories = ; directories that you want to create

[module import]
modules = ; modules that you want to import."""

# template strings of index.html file.
INDEX_HTML = """<html>
	<head>
		<title></title>
		<meta http-equiv="Content-Type" content="text/html;charset=UTF-8" />
		<link rel="stylesheet" href="" />
		<script type="text/javascript"></script>
	</head>
	<body>
	
	
	</body>
</html>"""

# template strings of style.css file.
STYLE_CSS = """@charset "%s";\n"""
