#!/usr/bin/env python
#coding: utf-8

from defines import *
from ConfigParser import ConfigParser

import os
import re
import time
import codecs
import webbrowser as browser
import cPickle as pickle

class BaseError(Exception): pass
class ConfigFileNotExist(BaseError): pass

class Divergence:
	def __init__(self, args):
		self.args = args

		if self.args.inifile:
			# create Configuration instance and register config option.
			conf = self.getConfigIns()
			fo = open(".gaeinit.gis", "w")
			pickle.dump(conf, fo)


	def launch(self):
		
		if self.args.compile:
			
			self.conf = loadConfig()

			#move directory
			if os.path.isdir(self.conf.appname) == False:
				os.mkdir (self.conf.appname)
		
			os.chdir(self.conf.appname)
			
			# make init files
			appyaml = self.makefile("app.yaml", self.conf.encoding, APP_YAML_TEMP % self.getdict())
			indexyaml = self.makefile("index.yaml", self.conf.encoding, INDEX_YAML_TEMP)
			mainscript = self.makefile(self.conf.mainscript, self.conf.encoding, self.addUserModules(MAIN_SCRIPT_TEMP))
			webapp  = self.makefile("webapp.py", self.conf.encoding, WEBHANDLER_TEMP)
#			compiled = self.makefile(".%s.gis", "utf-8", 

			# make init directories
			if self.conf.directories != None:
				for dir in self.conf.directories:
					os.mkdir(dir)
					pwd = os.getcwd()
					if dir in ["html", "htm"]:
						os.chdir(dir)
						indexhtml = self.makefile("index.html", self.conf.encoding, INDEX_HTML)
						os.chdir(pwd)
					elif dir in ["css", "style", "stylesheet"]:
						os.chdir(dir)
						stylecss = self.makefile("style.css", self.conf.encoding, STYLE_CSS % self.conf.encoding)
						os.chdir(pwd)
					
		elif self.args.run:
			self.conf = loadConfig()
			os.system("dev_appserver.py %s" % self.conf.appname)
			

		elif self.args.option:
			self.conf = loadConfig()
			os.syatem("dev_appserver.py %s %s" % (self.args.option, self.conf.appname) )

		elif self.args.filepath:
			filepath = self.makepath(self.args.filepath)
			self.makefile(filepath, "utf-8", self.addUserModules(NOMAL_SCRIPT_TEMP))

		elif self.args.configtemp:
			self.makefile("template-config.ini", "utf-8", CONFIG_TEMP)
		
		elif self.args.deploy:
			self.conf = loadConfig()
			if os.getcwd().split("/")[-1] == self.conf.appname:
				os.system("appcfg.py update .")
			else:
				os.system("appcfg.py update %s" % self.conf.appname)

	def getConfigIns(self):
		# check exist
		isexist = os.access(self.args.inifile, os.F_OK)
		if isexist:
			parser = ConfigParser()
			parser.read(self.args.inifile)
			app = parser._sections["application settings"]
			file = parser._sections["file settings"]
			modules = parser._sections["modules import"] if parser.has_section("modules import") else None

			conf = Configuration()
			conf.appname = app["appname"]
			conf.mainscript = app["mainscript"]
			conf.version = app["version"]
			conf.encoding = file["encoding"]
			conf.directories = self.getListFromPat(file["directories"]) if parser.has_option("file settings", "directories") else None
			conf.modules = self.getListFromPat(modules["modules"]) if parser.has_option("modules import", "modules") else None
			return conf

		else:
			raise IOError("%s file is not exist." % self.args.inifile)


	def makepath(self, basepath):
		return os.path.realpath(basepath)

	def makefile(self, filename, encoding, contents):
		try:
			codecs.open(filename, "w", encoding).write(contents)
		except IOError:
			raise IOError("%s is directory. Please set filepath that contain FILE NAME." % filename)

	def getdict(self):
		result = {}
		for key in dir(self.conf):
			if key.startswith("_"):
				pass
			else:
				result[key] = getattr(self.conf, key)
		return result

	def getListFromPat(self, string):
		pat = re.compile("[^, ]+")
		return [item.group() for item in pat.finditer(string)]

	def addUserModules(self, template):
		modules = self.conf.modules
		if modules == None:
			template = template.replace("(user_modules)", "\n")
			return template
		else:
			moduleString = ""
			for module in modules:
				moduleString += "import %s\n" % module
			template = template.replace("(user_modules)", moduleString)
			return template

class Configuration(object):
	appname = None
	mainscript = None
	version = None
	encoding = None
	directories = None
	modules = None


def loadConfig():
	access = os.access(".gaeinit.gis", os.F_OK)
	if access:
		fo = open(".gaeinit.gis", "r")
		try:
			return pickle.load(fo)
		except EOFError:
			raise IOError("Content of the file incorrect")
	
	else:
		return False
