import sys
import glob
from assembler import (assemble, ascii_binary_to_real_binary,
                       ascii_binary_to_vhdl_code, ascii_binary_to_c_code,
                       ascii_binary_to_fakemem_code)


def main():

    if len(sys.argv) == 1:
        print "USAGE: galapagos-as [-d] source.gas [source2.gas ...]"
        print "use --ascii to get output ascii strings of 0s and 1s" \
            "instead of real binary"
        print "use --vhdl to generate fake VHDL ram for testing purposes"
        print "use --c to generate C code for uploading the program"
        return

    debug = '-d' in sys.argv

    paths = filter(lambda x: x[0] != '-',
                   [item for sublist in map(glob.glob, sys.argv[1:])
                    for item in sublist])

    for path in paths:
        with open(path, 'r') as f:
            assembly = [line for line in f]
        assembled = assemble(assembly)

        if not assembled:
            return

        address = 1
        ascii_binary = []
        for line in assembled:
            ascii_binary.append(line.toBinary())
            if debug:
                print 'Address: %s' % address
                print 'text: ' + str(line)
                print line.toBinary(debug=debug)
                print
            address += 1

        ascii_binary = ''.join(ascii_binary)

        ascii_mode = '--ascii' in sys.argv
        vhdl_mode = '--vhdl' in sys.argv
        c_mode = '--c' in sys.argv
        fakemem_mode = '--fakemem' in sys.argv

        if vhdl_mode:
            ascii_binary_to_vhdl_code(ascii_binary)

        if c_mode:
            ascii_binary_to_c_code(ascii_binary)

        if fakemem_mode:
            ascii_binary_to_fakemem_code(ascii_binary)

        with open(path + '.out', 'w') as f:
            f.write(
                ascii_binary
                if ascii_mode else
                ascii_binary_to_real_binary(ascii_binary)
            )


if __name__ == '__main__':
    main()
