#!/usr/bin/env python

from distutils.core import setup
import gcsms

setup(
  name = 'gcsms',
  version = gcsms.__version__,
  packages = ['gcsms'],
  scripts = ['scripts/gcsms'],
  data_files = [
    ('share/doc/gcsms', ['sample.config', 'README.md', 'LICENSE'])
  ],

  author = 'Mansour Behabadi',
  author_email = 'mansour@oxplot.com',
  maintainer = 'Mansour Behabadi',
  maintainer_email = 'mansour@oxplot.com',
  description = 'Send SMS for free using Google Calendar',
  # README.rst is generated by `pandoc -f markdown -t rst README.md`
  long_description = open('README.rst', 'r').read(),
  license = 'GPLv3',
  url = 'https://github.com/oxplot/gcsms',

  classifiers = [
    'Development Status :: 5 - Production/Stable',
    'Environment :: Console',
    'Intended Audience :: Developers',
    'Intended Audience :: System Administrators',
    'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
    'Natural Language :: English',
    'Programming Language :: Python :: 2.7',
    'Programming Language :: Python :: 3.3',
    'Topic :: Communications',
    'Topic :: Utilities'
  ]
)
