var handlebars = require("./handlebars/base"),

// Each of these augment the Handlebars object. No need to setup here.
// (This is done to easily share code between commonjs and browse envs)
  utils = require("./handlebars/utils"),
  compiler = require("./handlebars/compiler"),
  runtime = require("./handlebars/runtime");

var create = function() {
  var hb = handlebars.create();

  utils.attach(hb);
  compiler.attach(hb);
  runtime.attach(hb);

  return hb;
};

var Handlebars = create();
Handlebars.create = create;

module.exports = Handlebars; // instantiate an instance

// BEGIN(BROWSER)

// END(BROWSER)

// USAGE:
// var handlebars = require('handlebars');

// var singleton = handlebars.Handlebars,
//  local = handlebars.create();
