/**
 * Copyright 2013-2014 Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @providesModule filterAttributes
 * @typechecks static-only
 */

/*jslint evil: true */

'use strict';

/**
 * Like filter(), but for a DOM nodes attributes. Returns an array of
 * the filter DOMAttribute objects. Does some perf related this like
 * caching attributes.length.
 *
 * @param {DOMElement} node Node whose attributes you want to filter
 * @return {array} array of DOM attribute objects.
 */
function filterAttributes(node, func, context) {
  var attributes = node.attributes;
  var numAttributes = attributes.length;
  var accumulator = [];
  for (var i = 0; i < numAttributes; i++) {
    var attr = attributes.item(i);
    if (func.call(context, attr)) {
      accumulator.push(attr);
    }
  }
  return accumulator;
}

module.exports = filterAttributes;
