#!/usr/bin/env python

#
# Generated  by generateDS.py.
#

import sys
import getopt
from string import lower as str_lower
from xml.dom import minidom
from xml.dom import Node

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class people(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('person', 'person', 1),
        ]
    subclass = None
    superclass = None
    def __init__(self, person=None):
        if person is None:
            self.person = []
        else:
            self.person = person
    def factory(*args_, **kwargs_):
        if people.subclass:
            return people.subclass(*args_, **kwargs_)
        else:
            return people(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_person(self): return self.person
    def set_person(self, person): self.person = person
    def add_person(self, value): self.person.append(value)
    def insert_person(self, index, value): self.person[index] = value
    def export(self, outfile, level, namespace_='', name_='people', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='people')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='people'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='people'):
        for person_ in self.person:
            person_.export(outfile, level, namespace_, name_='person')
    def hasContent_(self):
        if (
            self.person
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='people'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('person=[\n')
        level += 1
        for person in self.person:
            showIndent(outfile, level)
            outfile.write('model_.person(\n')
            person.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'person':
            obj_ = person.factory()
            obj_.build(child_)
            self.person.append(obj_)
    def walk_and_update(self):
        members = people._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if people.superclass != None:
          people.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: people  depth: %d' % (counter, depth, )
        members = people._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
    def set_up(self):
        global types, counter
        import types as types_module
        types = types_module
        counter = 0
# end class people


class person(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('id', 'xs:integer', 0),
        MemberSpec_('value', 'xs:string', 0),
        MemberSpec_('ratio_attr', 'xs:string', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('ratio', ['percent', 'xs:integer'], 0),
        MemberSpec_('imagesize', ['scale', 'xs:integer'], 0),
        MemberSpec_('interest', 'xs:string', 1),
        MemberSpec_('category', 'xs:integer', 0),
        MemberSpec_('hot_agent', 'hot.agent', 0),
        MemberSpec_('promoter', 'booster', 1),
        MemberSpec_('hot', 'BasicEmptyType', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, id=None, value=None, ratio_attr=None, name=None, ratio=None, imagesize=None, interest=None, category=None, hot_agent=None, promoter=None, hot=None):
        self.id = _cast(int, id)
        self.value = _cast(None, value)
        self.ratio_attr = _cast(None, ratio_attr)
        self.name = name
        self.ratio = ratio
        self.imagesize = imagesize
        if interest is None:
            self.interest = []
        else:
            self.interest = interest
        self.category = category
        self.hot_agent = hot_agent
        if promoter is None:
            self.promoter = []
        else:
            self.promoter = promoter
        self.hot = hot
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if person.subclass:
            return person.subclass(*args_, **kwargs_)
        else:
            return person(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_ratio(self): return self.ratio
    def set_ratio(self, ratio): self.ratio = ratio
    def validate_ratio(self, value):
        # validate type ratio
        pass
    def get_imagesize(self): return self.imagesize
    def set_imagesize(self, imagesize): self.imagesize = imagesize
    def validate_imagesize(self, value):
        # validate type imagesize
        pass
    def get_interest(self): return self.interest
    def set_interest(self, interest): self.interest = interest
    def add_interest(self, value): self.interest.append(value)
    def insert_interest(self, index, value): self.interest[index] = value
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_hot_agent(self): return self.hot_agent
    def set_hot_agent(self, hot_agent): self.hot_agent = hot_agent
    def get_promoter(self): return self.promoter
    def set_promoter(self, promoter): self.promoter = promoter
    def add_promoter(self, value): self.promoter.append(value)
    def insert_promoter(self, index, value): self.promoter[index] = value
    def get_hot(self): return self.hot
    def set_hot(self, hot): self.hot = hot
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_ratio_attr(self): return self.ratio_attr
    def set_ratio_attr(self, ratio_attr): self.ratio_attr = ratio_attr
    def getAnyAttributes_(self): return self.anyAttributes_
    def setAnyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def export(self, outfile, level, namespace_='', name_='person', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='person')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='person'):
        if self.id is not None:
            outfile.write(' id="%s"' % self.format_integer(self.id, input_name='id'))
        if self.value is not None:
            outfile.write(' value=%s' % (self.format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
        if self.ratio_attr is not None:
            outfile.write(' ratio_attr=%s' % (self.format_string(quote_attrib(self.ratio_attr).encode(ExternalEncoding), input_name='ratio_attr'), ))
        for name, value in self.anyAttributes_.items():
            outfile.write(' %s=%s' % (name, quote_attrib(value), ))
    def exportChildren(self, outfile, level, namespace_='', name_='person'):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        if self.ratio is not None:
            showIndent(outfile, level)
            outfile.write('<%sratio>%s</%sratio>\n' % (namespace_, self.format_string(quote_xml(self.ratio).encode(ExternalEncoding), input_name='ratio'), namespace_))
        if self.imagesize is not None:
            showIndent(outfile, level)
            outfile.write('<%simagesize>%s</%simagesize>\n' % (namespace_, self.format_integer(self.imagesize, input_name='imagesize'), namespace_))
        for interest_ in self.interest:
            showIndent(outfile, level)
            outfile.write('<%sinterest>%s</%sinterest>\n' % (namespace_, self.format_string(quote_xml(interest_).encode(ExternalEncoding), input_name='interest'), namespace_))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('<%scategory>%s</%scategory>\n' % (namespace_, self.format_integer(self.category, input_name='category'), namespace_))
        if self.hot_agent:
            self.hot_agent.export(outfile, level, namespace_, name_='hot.agent', )
        for promoter_ in self.promoter:
            promoter_.export(outfile, level, namespace_, name_='promoter')
        if self.hot:
            self.hot.export(outfile, level, namespace_, name_='hot', )
    def hasContent_(self):
        if (
            self.name is not None or
            self.ratio is not None or
            self.imagesize is not None or
            self.interest or
            self.category is not None or
            self.hot_agent is not None or
            self.promoter or
            self.hot is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='person'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value = %s,\n' % (self.value,))
        if self.ratio_attr is not None:
            showIndent(outfile, level)
            outfile.write('ratio_attr = %s,\n' % (self.ratio_attr,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s = "%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('ratio=%d,\n' % self.ratio)
        showIndent(outfile, level)
        outfile.write('imagesize=%d,\n' % self.imagesize)
        showIndent(outfile, level)
        outfile.write('interest=[\n')
        level += 1
        for interest in self.interest:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(interest).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('category=%d,\n' % self.category)
        if self.hot_agent:
            showIndent(outfile, level)
            outfile.write('hot_agent=model_.hot_agent(\n')
            self.hot_agent.exportLiteral(outfile, level, name_='hot_agent')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('promoter=[\n')
        level += 1
        for promoter in self.promoter:
            showIndent(outfile, level)
            outfile.write('model_.promoter(\n')
            promoter.exportLiteral(outfile, level, name_='promoter')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.hot:
            showIndent(outfile, level)
            outfile.write('hot=model_.BasicEmptyType(\n')
            self.hot.exportLiteral(outfile, level, name_='hot')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('id'):
            try:
                self.id = int(attrs.get('id').value)
            except ValueError, exp:
                raise ValueError('Bad integer attribute (id): %s' % exp)
        if attrs.get('value'):
            self.value = attrs.get('value').value
        if attrs.get('ratio_attr'):
            self.ratio_attr = attrs.get('ratio_attr').value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name != "id" and name != "value" and name != "ratio_attr":
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'name':
            name_ = ''
            for text__content_ in child_.childNodes:
                name_ += text__content_.nodeValue
            self.name = name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'ratio':
            ratio_ = ''
            for text__content_ in child_.childNodes:
                ratio_ += text__content_.nodeValue
            self.ratio = ratio_
            self.validate_ratio(self.ratio)    # validate type ratio
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'imagesize':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (imagesize): %s' % exp)
                self.imagesize = ival_
            self.validate_imagesize(self.imagesize)    # validate type imagesize
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'interest':
            interest_ = ''
            for text__content_ in child_.childNodes:
                interest_ += text__content_.nodeValue
            self.interest.append(interest_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'category':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (category): %s' % exp)
                self.category = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'hot.agent':
            obj_ = hot_agent.factory()
            obj_.build(child_)
            self.set_hot_agent(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'promoter':
            obj_ = booster.factory()
            obj_.build(child_)
            self.promoter.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'hot':
            obj_ = BasicEmptyType.factory()
            obj_.build(child_)
            self.set_hot(obj_)
    def walk_and_update(self):
        members = person._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if person.superclass != None:
          person.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: person  depth: %d' % (counter, depth, )
        members = person._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class person


class scale(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('valueOf_', ['scale', 'xs:integer'], 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if scale.subclass:
            return scale.subclass(*args_, **kwargs_)
        else:
            return scale(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='scale', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='scale')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='scale'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='scale'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='scale'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = "%s",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
    def walk_and_update(self):
        members = scale._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if scale.superclass != None:
          scale.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: scale  depth: %d' % (counter, depth, )
        members = scale._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class scale


class BasicEmptyType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('valueOf_', [], 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if BasicEmptyType.subclass:
            return BasicEmptyType.subclass(*args_, **kwargs_)
        else:
            return BasicEmptyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='BasicEmptyType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='BasicEmptyType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='BasicEmptyType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='BasicEmptyType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BasicEmptyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = "%s",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
    def walk_and_update(self):
        members = BasicEmptyType._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if BasicEmptyType.superclass != None:
          BasicEmptyType.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: BasicEmptyType  depth: %d' % (counter, depth, )
        members = BasicEmptyType._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class BasicEmptyType


class hot_agent(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('priority', 'xs:float', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, firstname=None, lastname=None, priority=None):
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if hot_agent.subclass:
            return hot_agent.subclass(*args_, **kwargs_)
        else:
            return hot_agent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def getAnyAttributes_(self): return self.anyAttributes_
    def setAnyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def export(self, outfile, level, namespace_='', name_='hot.agent', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='hot.agent')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='hot.agent'):
        for name, value in self.anyAttributes_.items():
            outfile.write(' %s=%s' % (name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='hot.agent'):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirstname>%s</%sfirstname>\n' % (namespace_, self.format_string(quote_xml(self.firstname).encode(ExternalEncoding), input_name='firstname'), namespace_))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('<%slastname>%s</%slastname>\n' % (namespace_, self.format_string(quote_xml(self.lastname).encode(ExternalEncoding), input_name='lastname'), namespace_))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('<%spriority>%s</%spriority>\n' % (namespace_, self.format_float(self.priority, input_name='priority'), namespace_))
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='hot.agent'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s = "%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('firstname=%s,\n' % quote_python(self.firstname).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('lastname=%s,\n' % quote_python(self.lastname).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('priority=%f,\n' % self.priority)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            self.anyAttributes_[name] = value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'firstname':
            firstname_ = ''
            for text__content_ in child_.childNodes:
                firstname_ += text__content_.nodeValue
            self.firstname = firstname_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'lastname':
            lastname_ = ''
            for text__content_ in child_.childNodes:
                lastname_ += text__content_.nodeValue
            self.lastname = lastname_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'priority':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    fval_ = float(sval_)
                except ValueError, exp:
                    raise ValueError('requires float or double (priority): %s' %exp)
                self.priority = fval_
    def walk_and_update(self):
        members = hot_agent._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if hot_agent.superclass != None:
          hot_agent.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: hot_agent  depth: %d' % (counter, depth, )
        members = hot_agent._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class hot_agent


class booster(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('client', 'client', 1),
        ]
    subclass = None
    superclass = None
    def __init__(self, firstname=None, lastname=None, client=None):
        self.firstname = firstname
        self.lastname = lastname
        if client is None:
            self.client = []
        else:
            self.client = client
    def factory(*args_, **kwargs_):
        if booster.subclass:
            return booster.subclass(*args_, **kwargs_)
        else:
            return booster(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_client(self): return self.client
    def set_client(self, client): self.client = client
    def add_client(self, value): self.client.append(value)
    def insert_client(self, index, value): self.client[index] = value
    def export(self, outfile, level, namespace_='', name_='booster', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='booster')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='booster'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='booster'):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirstname>%s</%sfirstname>\n' % (namespace_, self.format_string(quote_xml(self.firstname).encode(ExternalEncoding), input_name='firstname'), namespace_))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('<%slastname>%s</%slastname>\n' % (namespace_, self.format_string(quote_xml(self.lastname).encode(ExternalEncoding), input_name='lastname'), namespace_))
        for client_ in self.client:
            client_.export(outfile, level, namespace_, name_='client')
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.client
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='booster'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('firstname=%s,\n' % quote_python(self.firstname).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('lastname=%s,\n' % quote_python(self.lastname).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('client=[\n')
        level += 1
        for client in self.client:
            showIndent(outfile, level)
            outfile.write('model_.client(\n')
            client.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'firstname':
            firstname_ = ''
            for text__content_ in child_.childNodes:
                firstname_ += text__content_.nodeValue
            self.firstname = firstname_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'lastname':
            lastname_ = ''
            for text__content_ in child_.childNodes:
                lastname_ += text__content_.nodeValue
            self.lastname = lastname_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'client':
            obj_ = client.factory()
            obj_.build(child_)
            self.client.append(obj_)
    def walk_and_update(self):
        members = booster._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if booster.superclass != None:
          booster.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: booster  depth: %d' % (counter, depth, )
        members = booster._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class booster


class client(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('fullname', 'xs:string', 0),
        MemberSpec_('refid', 'xs:integer', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, fullname=None, refid=None):
        self.fullname = fullname
        self.refid = refid
    def factory(*args_, **kwargs_):
        if client.subclass:
            return client.subclass(*args_, **kwargs_)
        else:
            return client(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fullname(self): return self.fullname
    def set_fullname(self, fullname): self.fullname = fullname
    def get_refid(self): return self.refid
    def set_refid(self, refid): self.refid = refid
    def export(self, outfile, level, namespace_='', name_='client', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='client')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='client'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='client'):
        if self.fullname is not None:
            showIndent(outfile, level)
            outfile.write('<%sfullname>%s</%sfullname>\n' % (namespace_, self.format_string(quote_xml(self.fullname).encode(ExternalEncoding), input_name='fullname'), namespace_))
        if self.refid is not None:
            showIndent(outfile, level)
            outfile.write('<%srefid>%s</%srefid>\n' % (namespace_, self.format_integer(self.refid, input_name='refid'), namespace_))
    def hasContent_(self):
        if (
            self.fullname is not None or
            self.refid is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='client'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('fullname=%s,\n' % quote_python(self.fullname).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('refid=%d,\n' % self.refid)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'fullname':
            fullname_ = ''
            for text__content_ in child_.childNodes:
                fullname_ += text__content_.nodeValue
            self.fullname = fullname_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'refid':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (refid): %s' % exp)
                self.refid = ival_
    def walk_and_update(self):
        members = client._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if client.superclass != None:
          client.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: client  depth: %d' % (counter, depth, )
        members = client._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class client


class Richtlinie(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('valueOf_', ['Richtlinie', 'xs:string'], 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=''):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if Richtlinie.subclass:
            return Richtlinie.subclass(*args_, **kwargs_)
        else:
            return Richtlinie(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='Richtlinie', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='Richtlinie')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='Richtlinie'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Richtlinie'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value)
        else:
            outfile.write(quote_xml('%s' % self.valueOf_))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Richtlinie'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = "%s",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
    def walk_and_update(self):
        members = Richtlinie._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if Richtlinie.superclass != None:
          Richtlinie.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: Richtlinie  depth: %d' % (counter, depth, )
        members = Richtlinie._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class Richtlinie


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = people.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="people", 
        namespacedef_='')
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.documentElement
    rootObj = people.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="people",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = people.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('from out2sup import *\n\n')
    sys.stdout.write('rootObj = people(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_="people")
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

