#!/usr/bin/env python

#
# Generated  by generateDS.py.
#

import sys
import getopt
from string import lower as str_lower
from xml.dom import minidom
from xml.dom import Node

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class IdentifierType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('schemeDataURI', 'xsd:anyURI', 0),
        MemberSpec_('schemeID', 'xsd:normalizedString', 0),
        MemberSpec_('schemeAgencyName', 'xsd:string', 0),
        MemberSpec_('schemeAgencyID', 'xsd:normalizedString', 0),
        MemberSpec_('schemeName', 'xsd:string', 0),
        MemberSpec_('schemeVersionID', 'xsd:normalizedString', 0),
        MemberSpec_('schemeURI', 'xsd:anyURI', 0),
        MemberSpec_('valueOf_', 'xsd:normalizedString', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, schemeDataURI=None, schemeID=None, schemeAgencyName=None, schemeAgencyID=None, schemeName=None, schemeVersionID=None, schemeURI=None, valueOf_=''):
        self.schemeDataURI = _cast(None, schemeDataURI)
        self.schemeID = _cast(None, schemeID)
        self.schemeAgencyName = _cast(None, schemeAgencyName)
        self.schemeAgencyID = _cast(None, schemeAgencyID)
        self.schemeName = _cast(None, schemeName)
        self.schemeVersionID = _cast(None, schemeVersionID)
        self.schemeURI = _cast(None, schemeURI)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if IdentifierType.subclass:
            return IdentifierType.subclass(*args_, **kwargs_)
        else:
            return IdentifierType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_schemeDataURI(self): return self.schemeDataURI
    def set_schemeDataURI(self, schemeDataURI): self.schemeDataURI = schemeDataURI
    def get_schemeID(self): return self.schemeID
    def set_schemeID(self, schemeID): self.schemeID = schemeID
    def get_schemeAgencyName(self): return self.schemeAgencyName
    def set_schemeAgencyName(self, schemeAgencyName): self.schemeAgencyName = schemeAgencyName
    def get_schemeAgencyID(self): return self.schemeAgencyID
    def set_schemeAgencyID(self, schemeAgencyID): self.schemeAgencyID = schemeAgencyID
    def get_schemeName(self): return self.schemeName
    def set_schemeName(self, schemeName): self.schemeName = schemeName
    def get_schemeVersionID(self): return self.schemeVersionID
    def set_schemeVersionID(self, schemeVersionID): self.schemeVersionID = schemeVersionID
    def get_schemeURI(self): return self.schemeURI
    def set_schemeURI(self, schemeURI): self.schemeURI = schemeURI
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='IdentifierType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='IdentifierType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='IdentifierType'):
        if self.schemeDataURI is not None:
            outfile.write(' schemeDataURI=%s' % (self.format_string(quote_attrib(self.schemeDataURI).encode(ExternalEncoding), input_name='schemeDataURI'), ))
        if self.schemeID is not None:
            outfile.write(' schemeID=%s' % (self.format_string(quote_attrib(self.schemeID).encode(ExternalEncoding), input_name='schemeID'), ))
        if self.schemeAgencyName is not None:
            outfile.write(' schemeAgencyName=%s' % (self.format_string(quote_attrib(self.schemeAgencyName).encode(ExternalEncoding), input_name='schemeAgencyName'), ))
        if self.schemeAgencyID is not None:
            outfile.write(' schemeAgencyID=%s' % (self.format_string(quote_attrib(self.schemeAgencyID).encode(ExternalEncoding), input_name='schemeAgencyID'), ))
        if self.schemeName is not None:
            outfile.write(' schemeName=%s' % (self.format_string(quote_attrib(self.schemeName).encode(ExternalEncoding), input_name='schemeName'), ))
        if self.schemeVersionID is not None:
            outfile.write(' schemeVersionID=%s' % (self.format_string(quote_attrib(self.schemeVersionID).encode(ExternalEncoding), input_name='schemeVersionID'), ))
        if self.schemeURI is not None:
            outfile.write(' schemeURI=%s' % (self.format_string(quote_attrib(self.schemeURI).encode(ExternalEncoding), input_name='schemeURI'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IdentifierType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IdentifierType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.schemeDataURI is not None:
            showIndent(outfile, level)
            outfile.write('schemeDataURI = "%s",\n' % (self.schemeDataURI,))
        if self.schemeID is not None:
            showIndent(outfile, level)
            outfile.write('schemeID = "%s",\n' % (self.schemeID,))
        if self.schemeAgencyName is not None:
            showIndent(outfile, level)
            outfile.write('schemeAgencyName = "%s",\n' % (self.schemeAgencyName,))
        if self.schemeAgencyID is not None:
            showIndent(outfile, level)
            outfile.write('schemeAgencyID = "%s",\n' % (self.schemeAgencyID,))
        if self.schemeName is not None:
            showIndent(outfile, level)
            outfile.write('schemeName = "%s",\n' % (self.schemeName,))
        if self.schemeVersionID is not None:
            showIndent(outfile, level)
            outfile.write('schemeVersionID = "%s",\n' % (self.schemeVersionID,))
        if self.schemeURI is not None:
            showIndent(outfile, level)
            outfile.write('schemeURI = "%s",\n' % (self.schemeURI,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('schemeDataURI'):
            self.schemeDataURI = attrs.get('schemeDataURI').value
        if attrs.get('schemeID'):
            self.schemeID = attrs.get('schemeID').value
        if attrs.get('schemeAgencyName'):
            self.schemeAgencyName = attrs.get('schemeAgencyName').value
        if attrs.get('schemeAgencyID'):
            self.schemeAgencyID = attrs.get('schemeAgencyID').value
        if attrs.get('schemeName'):
            self.schemeName = attrs.get('schemeName').value
        if attrs.get('schemeVersionID'):
            self.schemeVersionID = attrs.get('schemeVersionID').value
        if attrs.get('schemeURI'):
            self.schemeURI = attrs.get('schemeURI').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class IdentifierType


class BillOfResourcesIDType(IdentifierType):
    member_data_items_ = [
        MemberSpec_('valueOf_', 'IdentifierType', 0),
        ]
    subclass = None
    superclass = IdentifierType
    def __init__(self, schemeDataURI=None, schemeID=None, schemeAgencyName=None, schemeAgencyID=None, schemeName=None, schemeVersionID=None, schemeURI=None, valueOf_=''):
        IdentifierType.__init__(self, schemeDataURI, schemeID, schemeAgencyName, schemeAgencyID, schemeName, schemeVersionID, schemeURI, valueOf_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if BillOfResourcesIDType.subclass:
            return BillOfResourcesIDType.subclass(*args_, **kwargs_)
        else:
            return BillOfResourcesIDType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='BillOfResourcesIDType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='BillOfResourcesIDType')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="BillOfResourcesIDType"')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='BillOfResourcesIDType'):
        IdentifierType.exportAttributes(self, outfile, level, namespace_, name_='BillOfResourcesIDType')
    def exportChildren(self, outfile, level, namespace_='', name_='BillOfResourcesIDType'):
        IdentifierType.exportChildren(self, outfile, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BillOfResourcesIDType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        IdentifierType.exportLiteralAttributes(self, outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        IdentifierType.exportLiteralChildren(self, outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        IdentifierType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        IdentifierType.buildChildren(self, child_, nodeName_)
# end class BillOfResourcesIDType


class BillOfMaterialIDType(IdentifierType):
    member_data_items_ = [
        MemberSpec_('valueOf_', 'IdentifierType', 0),
        ]
    subclass = None
    superclass = IdentifierType
    def __init__(self, schemeDataURI=None, schemeID=None, schemeAgencyName=None, schemeAgencyID=None, schemeName=None, schemeVersionID=None, schemeURI=None, valueOf_=''):
        IdentifierType.__init__(self, schemeDataURI, schemeID, schemeAgencyName, schemeAgencyID, schemeName, schemeVersionID, schemeURI, valueOf_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if BillOfMaterialIDType.subclass:
            return BillOfMaterialIDType.subclass(*args_, **kwargs_)
        else:
            return BillOfMaterialIDType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='BillOfMaterialIDType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='BillOfMaterialIDType')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="BillOfMaterialIDType"')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='BillOfMaterialIDType'):
        IdentifierType.exportAttributes(self, outfile, level, namespace_, name_='BillOfMaterialIDType')
    def exportChildren(self, outfile, level, namespace_='', name_='BillOfMaterialIDType'):
        IdentifierType.exportChildren(self, outfile, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BillOfMaterialIDType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        IdentifierType.exportLiteralAttributes(self, outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        IdentifierType.exportLiteralChildren(self, outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        IdentifierType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        IdentifierType.buildChildren(self, child_, nodeName_)
# end class BillOfMaterialIDType


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = IdentifierType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_="IdentifierType", 
##         namespacedef_='')
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.documentElement
    rootObj = IdentifierType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_="IdentifierType",
##         namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = IdentifierType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('#from simplecontent_restriction2_sup import *\n\n')
##     sys.stdout.write('import simplecontent_restriction2_sup as model_\n\n')
##     sys.stdout.write('rootObj = model_.IdentifierType(\n')
##     rootObj.exportLiteral(sys.stdout, 0, name_="IdentifierType")
##     sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

