#!/usr/bin/env python

#
# Generated  by generateDS.py.
#

import sys
import getopt
from string import lower as str_lower
from xml.dom import minidom
from xml.dom import Node

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class SpecialDate(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('SpecialProperty', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:date', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, SpecialProperty=None, valueOf_=None):
        self.SpecialProperty = _cast(None, SpecialProperty)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if SpecialDate.subclass:
            return SpecialDate.subclass(*args_, **kwargs_)
        else:
            return SpecialDate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_SpecialProperty(self): return self.SpecialProperty
    def set_SpecialProperty(self, SpecialProperty): self.SpecialProperty = SpecialProperty
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='SpecialDate', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='SpecialDate')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='SpecialDate'):
        if self.SpecialProperty is not None:
            outfile.write(' SpecialProperty=%s' % (self.format_string(quote_attrib(self.SpecialProperty).encode(ExternalEncoding), input_name='SpecialProperty'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpecialDate'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='SpecialDate'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.SpecialProperty is not None:
            showIndent(outfile, level)
            outfile.write('SpecialProperty = "%s",\n' % (self.SpecialProperty,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('SpecialProperty'):
            self.SpecialProperty = attrs.get('SpecialProperty').value
    def buildChildren(self, child_, nodeName_):
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class SpecialDate


class ExtremeDate(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('ExtremeProperty', 'xs:string', 0),
        MemberSpec_('valueOf_', ['RelationType', 'RelationType2', 'RelationType3', 'xs:string'], 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, ExtremeProperty=None, valueOf_=None):
        self.ExtremeProperty = _cast(None, ExtremeProperty)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ExtremeDate.subclass:
            return ExtremeDate.subclass(*args_, **kwargs_)
        else:
            return ExtremeDate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ExtremeProperty(self): return self.ExtremeProperty
    def set_ExtremeProperty(self, ExtremeProperty): self.ExtremeProperty = ExtremeProperty
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='ExtremeDate', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='ExtremeDate')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='ExtremeDate'):
        if self.ExtremeProperty is not None:
            outfile.write(' ExtremeProperty=%s' % (self.format_string(quote_attrib(self.ExtremeProperty).encode(ExternalEncoding), input_name='ExtremeProperty'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ExtremeDate'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ExtremeDate'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.ExtremeProperty is not None:
            showIndent(outfile, level)
            outfile.write('ExtremeProperty = "%s",\n' % (self.ExtremeProperty,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('ExtremeProperty'):
            self.ExtremeProperty = attrs.get('ExtremeProperty').value
    def buildChildren(self, child_, nodeName_):
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class ExtremeDate


class singleExtremeDate(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('ExtremeProperty', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:string', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, ExtremeProperty=None, valueOf_=None):
        self.ExtremeProperty = _cast(None, ExtremeProperty)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if singleExtremeDate.subclass:
            return singleExtremeDate.subclass(*args_, **kwargs_)
        else:
            return singleExtremeDate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ExtremeProperty(self): return self.ExtremeProperty
    def set_ExtremeProperty(self, ExtremeProperty): self.ExtremeProperty = ExtremeProperty
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='singleExtremeDate', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='singleExtremeDate')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='singleExtremeDate'):
        if self.ExtremeProperty is not None:
            outfile.write(' ExtremeProperty=%s' % (self.format_string(quote_attrib(self.ExtremeProperty).encode(ExternalEncoding), input_name='ExtremeProperty'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='singleExtremeDate'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='singleExtremeDate'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.ExtremeProperty is not None:
            showIndent(outfile, level)
            outfile.write('ExtremeProperty = "%s",\n' % (self.ExtremeProperty,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('ExtremeProperty'):
            self.ExtremeProperty = attrs.get('ExtremeProperty').value
    def buildChildren(self, child_, nodeName_):
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class singleExtremeDate


class containerType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('simplefactoid', 'simpleFactoidType', 1),
        MemberSpec_('mixedfactoid', 'mixedFactoidType', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, simplefactoid=None, mixedfactoid=None):
        if simplefactoid is None:
            self.simplefactoid = []
        else:
            self.simplefactoid = simplefactoid
        self.mixedfactoid = mixedfactoid
    def factory(*args_, **kwargs_):
        if containerType.subclass:
            return containerType.subclass(*args_, **kwargs_)
        else:
            return containerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_simplefactoid(self): return self.simplefactoid
    def set_simplefactoid(self, simplefactoid): self.simplefactoid = simplefactoid
    def add_simplefactoid(self, value): self.simplefactoid.append(value)
    def insert_simplefactoid(self, index, value): self.simplefactoid[index] = value
    def get_mixedfactoid(self): return self.mixedfactoid
    def set_mixedfactoid(self, mixedfactoid): self.mixedfactoid = mixedfactoid
    def export(self, outfile, level, namespace_='', name_='containerType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='containerType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='containerType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='containerType'):
        for simplefactoid_ in self.simplefactoid:
            simplefactoid_.export(outfile, level, namespace_, name_='simplefactoid')
        if self.mixedfactoid:
            self.mixedfactoid.export(outfile, level, namespace_, name_='mixedfactoid', )
    def hasContent_(self):
        if (
            self.simplefactoid or
            self.mixedfactoid is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='containerType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('simplefactoid=[\n')
        level += 1
        for simplefactoid_ in self.simplefactoid:
            showIndent(outfile, level)
            outfile.write('model_.simpleFactoidType(\n')
            simplefactoid_.exportLiteral(outfile, level, name_='simpleFactoidType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.mixedfactoid is not None:
            showIndent(outfile, level)
            outfile.write('mixedfactoid=model_.mixedFactoidType(\n')
            self.mixedfactoid.exportLiteral(outfile, level, name_='mixedfactoid')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'simplefactoid':
            obj_ = simpleFactoidType.factory()
            obj_.build(child_)
            self.simplefactoid.append(obj_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'mixedfactoid':
            obj_ = mixedFactoidType.factory()
            obj_.build(child_)
            self.set_mixedfactoid(obj_)
# end class containerType


class simpleFactoidType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('relation', ['RelationType', 'RelationType2', 'RelationType3', 'xs:string'], 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, relation=None):
        self.relation = relation
    def factory(*args_, **kwargs_):
        if simpleFactoidType.subclass:
            return simpleFactoidType.subclass(*args_, **kwargs_)
        else:
            return simpleFactoidType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_relation(self): return self.relation
    def set_relation(self, relation): self.relation = relation
    def validate_relation(self, value):
        # validate type relation
        pass
    def export(self, outfile, level, namespace_='', name_='simpleFactoidType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='simpleFactoidType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='simpleFactoidType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='simpleFactoidType'):
        if self.relation is not None:
            showIndent(outfile, level)
            outfile.write('<%srelation>%s</%srelation>\n' % (namespace_, self.format_string(quote_xml(self.relation).encode(ExternalEncoding), input_name='relation'), namespace_))
    def hasContent_(self):
        if (
            self.relation is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='simpleFactoidType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.relation is not None:
            showIndent(outfile, level)
            outfile.write('relation=%s,\n' % quote_python(self.relation).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'relation':
            relation_ = ''
            for text__content_ in child_.childNodes:
                relation_ += text__content_.nodeValue
            self.relation = relation_
            self.validate_relation(self.relation)    # validate type relation
# end class simpleFactoidType


class mixedFactoidType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('relation', ['RelationType', 'RelationType2', 'RelationType3', 'xs:string'], 0),
        MemberSpec_('valueOf_', [], 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, relation=None, valueOf_=None, mixedclass_=None, content_=None):
        self.relation = relation
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if mixedFactoidType.subclass:
            return mixedFactoidType.subclass(*args_, **kwargs_)
        else:
            return mixedFactoidType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_relation(self): return self.relation
    def set_relation(self, relation): self.relation = relation
    def validate_relation(self, value):
        # validate type relation
        pass
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='mixedFactoidType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='mixedFactoidType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='mixedFactoidType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='mixedFactoidType'):
        for item_ in self.content_:
            item_.export(outfile, level, item_.name, namespace_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.relation is not None or
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='mixedFactoidType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('content_ = [\n')
        for item_ in self.content_:
            item_.exportLiteral(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'relation':
            value_ = []
            for text_ in child_.childNodes:
                value_.append(text_.nodeValue)
            valuestr_ = ''.join(value_)
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'relation', valuestr_)
            self.content_.append(obj_)
        elif child_.nodeType == Node.TEXT_NODE:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.nodeValue)
            self.content_.append(obj_)
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class mixedFactoidType


class BaseType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('BaseProperty1', 'xs:string', 0),
        MemberSpec_('BaseProperty2', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:string', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, BaseProperty1=None, BaseProperty2=None, valueOf_=None):
        self.BaseProperty1 = _cast(None, BaseProperty1)
        self.BaseProperty2 = _cast(None, BaseProperty2)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if BaseType.subclass:
            return BaseType.subclass(*args_, **kwargs_)
        else:
            return BaseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_BaseProperty1(self): return self.BaseProperty1
    def set_BaseProperty1(self, BaseProperty1): self.BaseProperty1 = BaseProperty1
    def get_BaseProperty2(self): return self.BaseProperty2
    def set_BaseProperty2(self, BaseProperty2): self.BaseProperty2 = BaseProperty2
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='BaseType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='BaseType')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='BaseType'):
        if self.BaseProperty1 is not None:
            outfile.write(' BaseProperty1=%s' % (self.format_string(quote_attrib(self.BaseProperty1).encode(ExternalEncoding), input_name='BaseProperty1'), ))
        if self.BaseProperty2 is not None:
            outfile.write(' BaseProperty2=%s' % (self.format_string(quote_attrib(self.BaseProperty2).encode(ExternalEncoding), input_name='BaseProperty2'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='BaseType'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='BaseType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.BaseProperty1 is not None:
            showIndent(outfile, level)
            outfile.write('BaseProperty1 = "%s",\n' % (self.BaseProperty1,))
        if self.BaseProperty2 is not None:
            showIndent(outfile, level)
            outfile.write('BaseProperty2 = "%s",\n' % (self.BaseProperty2,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('BaseProperty1'):
            self.BaseProperty1 = attrs.get('BaseProperty1').value
        if attrs.get('BaseProperty2'):
            self.BaseProperty2 = attrs.get('BaseProperty2').value
    def buildChildren(self, child_, nodeName_):
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class BaseType


class DerivedType(BaseType):
    member_data_items_ = [
        MemberSpec_('DerivedProperty1', 'xs:string', 0),
        MemberSpec_('DerivedProperty2', 'xs:string', 0),
        MemberSpec_('valueOf_', 'BaseType', 0),
        ]
    subclass = None
    superclass = BaseType
    def __init__(self, BaseProperty1=None, BaseProperty2=None, DerivedProperty1=None, DerivedProperty2=None, valueOf_=None):
        BaseType.__init__(self, BaseProperty1, BaseProperty2, valueOf_)
        self.DerivedProperty1 = _cast(None, DerivedProperty1)
        self.DerivedProperty2 = _cast(None, DerivedProperty2)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DerivedType.subclass:
            return DerivedType.subclass(*args_, **kwargs_)
        else:
            return DerivedType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DerivedProperty1(self): return self.DerivedProperty1
    def set_DerivedProperty1(self, DerivedProperty1): self.DerivedProperty1 = DerivedProperty1
    def get_DerivedProperty2(self): return self.DerivedProperty2
    def set_DerivedProperty2(self, DerivedProperty2): self.DerivedProperty2 = DerivedProperty2
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='DerivedType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='DerivedType')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="DerivedType"')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='DerivedType'):
        BaseType.exportAttributes(self, outfile, level, namespace_, name_='DerivedType')
        if self.DerivedProperty1 is not None:
            outfile.write(' DerivedProperty1=%s' % (self.format_string(quote_attrib(self.DerivedProperty1).encode(ExternalEncoding), input_name='DerivedProperty1'), ))
        if self.DerivedProperty2 is not None:
            outfile.write(' DerivedProperty2=%s' % (self.format_string(quote_attrib(self.DerivedProperty2).encode(ExternalEncoding), input_name='DerivedProperty2'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='DerivedType'):
        BaseType.exportChildren(self, outfile, level, namespace_, name_)
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DerivedType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.DerivedProperty1 is not None:
            showIndent(outfile, level)
            outfile.write('DerivedProperty1 = "%s",\n' % (self.DerivedProperty1,))
        if self.DerivedProperty2 is not None:
            showIndent(outfile, level)
            outfile.write('DerivedProperty2 = "%s",\n' % (self.DerivedProperty2,))
        BaseType.exportLiteralAttributes(self, outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        BaseType.exportLiteralChildren(self, outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('DerivedProperty1'):
            self.DerivedProperty1 = attrs.get('DerivedProperty1').value
        if attrs.get('DerivedProperty2'):
            self.DerivedProperty2 = attrs.get('DerivedProperty2').value
        BaseType.buildAttributes(self, attrs)
    def buildChildren(self, child_, nodeName_):
        BaseType.buildChildren(self, child_, nodeName_)
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class DerivedType


class MyInteger(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('MyAttr', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:integer', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, MyAttr=None, valueOf_=None):
        self.MyAttr = _cast(None, MyAttr)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MyInteger.subclass:
            return MyInteger.subclass(*args_, **kwargs_)
        else:
            return MyInteger(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MyAttr(self): return self.MyAttr
    def set_MyAttr(self, MyAttr): self.MyAttr = MyAttr
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='MyInteger', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='MyInteger')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='MyInteger'):
        if self.MyAttr is not None:
            outfile.write(' MyAttr=%s' % (self.format_string(quote_attrib(self.MyAttr).encode(ExternalEncoding), input_name='MyAttr'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MyInteger'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MyInteger'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.MyAttr is not None:
            showIndent(outfile, level)
            outfile.write('MyAttr = "%s",\n' % (self.MyAttr,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('MyAttr'):
            self.MyAttr = attrs.get('MyAttr').value
    def buildChildren(self, child_, nodeName_):
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class MyInteger


class MyBoolean(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('MyAttr', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:boolean', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, MyAttr=None, valueOf_=None):
        self.MyAttr = _cast(None, MyAttr)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MyBoolean.subclass:
            return MyBoolean.subclass(*args_, **kwargs_)
        else:
            return MyBoolean(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MyAttr(self): return self.MyAttr
    def set_MyAttr(self, MyAttr): self.MyAttr = MyAttr
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='MyBoolean', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='MyBoolean')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='MyBoolean'):
        if self.MyAttr is not None:
            outfile.write(' MyAttr=%s' % (self.format_string(quote_attrib(self.MyAttr).encode(ExternalEncoding), input_name='MyAttr'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MyBoolean'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MyBoolean'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.MyAttr is not None:
            showIndent(outfile, level)
            outfile.write('MyAttr = "%s",\n' % (self.MyAttr,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('MyAttr'):
            self.MyAttr = attrs.get('MyAttr').value
    def buildChildren(self, child_, nodeName_):
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class MyBoolean


class MyFloat(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('MyAttr', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, MyAttr=None, valueOf_=None):
        self.MyAttr = _cast(None, MyAttr)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MyFloat.subclass:
            return MyFloat.subclass(*args_, **kwargs_)
        else:
            return MyFloat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MyAttr(self): return self.MyAttr
    def set_MyAttr(self, MyAttr): self.MyAttr = MyAttr
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='MyFloat', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='MyFloat')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='MyFloat'):
        if self.MyAttr is not None:
            outfile.write(' MyAttr=%s' % (self.format_string(quote_attrib(self.MyAttr).encode(ExternalEncoding), input_name='MyAttr'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MyFloat'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MyFloat'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.MyAttr is not None:
            showIndent(outfile, level)
            outfile.write('MyAttr = "%s",\n' % (self.MyAttr,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('MyAttr'):
            self.MyAttr = attrs.get('MyAttr').value
    def buildChildren(self, child_, nodeName_):
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class MyFloat


class MyDouble(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('MyAttr', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:double', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, MyAttr=None, valueOf_=None):
        self.MyAttr = _cast(None, MyAttr)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MyDouble.subclass:
            return MyDouble.subclass(*args_, **kwargs_)
        else:
            return MyDouble(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MyAttr(self): return self.MyAttr
    def set_MyAttr(self, MyAttr): self.MyAttr = MyAttr
    def getValueOf_(self): return self.valueOf_
    def setValueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='MyDouble', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='MyDouble')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='MyDouble'):
        if self.MyAttr is not None:
            outfile.write(' MyAttr=%s' % (self.format_string(quote_attrib(self.MyAttr).encode(ExternalEncoding), input_name='MyAttr'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MyDouble'):
        if self.valueOf_.find('![CDATA') > -1:
            value=quote_xml('%s' % self.valueOf_)
            value=value.replace('![CDATA','<![CDATA')
            value=value.replace(']]',']]>')
            outfile.write(value.encode(ExternalEncoding))
        else:
            outfile.write(quote_xml('%s' % self.valueOf_.encode(ExternalEncoding)))
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MyDouble'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.MyAttr is not None:
            showIndent(outfile, level)
            outfile.write('MyAttr = "%s",\n' % (self.MyAttr,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        self.valueOf_ = ''
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('MyAttr'):
            self.MyAttr = attrs.get('MyAttr').value
    def buildChildren(self, child_, nodeName_):
        self.valueOf_ = ''
        if child_.nodeType == Node.TEXT_NODE:
            self.valueOf_ += child_.nodeValue
        elif child_.nodeType == Node.CDATA_SECTION_NODE:
            self.valueOf_ += '![CDATA['+child_.nodeValue+']]'
# end class MyDouble


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = containerType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_="container", 
##         namespacedef_='')
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.documentElement
    rootObj = containerType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_="container",
##         namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = containerType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('#from extensions2_sup import *\n\n')
##     sys.stdout.write('import extensions2_sup as model_\n\n')
##     sys.stdout.write('rootObj = model_.container(\n')
##     rootObj.exportLiteral(sys.stdout, 0, name_="container")
##     sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

