#!/usr/bin/env python

#
# Generated  by generateDS.py.
#

import sys
import getopt
from string import lower as str_lower
import re as re_

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    text = node.text if node.text is not None else ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class people(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('comments', 'comments', 1),
        MemberSpec_('person', 'person', 1),
        MemberSpec_('programmer', 'programmer', 1),
        MemberSpec_('python_programmer', 'python-programmer', 1),
        MemberSpec_('java_programmer', 'java-programmer', 1),
        ]
    subclass = None
    superclass = None
    def __init__(self, comments=None, person=None, programmer=None, python_programmer=None, java_programmer=None):
        if comments is None:
            self.comments = []
        else:
            self.comments = comments
        if person is None:
            self.person = []
        else:
            self.person = person
        if programmer is None:
            self.programmer = []
        else:
            self.programmer = programmer
        if python_programmer is None:
            self.python_programmer = []
        else:
            self.python_programmer = python_programmer
        if java_programmer is None:
            self.java_programmer = []
        else:
            self.java_programmer = java_programmer
    def factory(*args_, **kwargs_):
        if people.subclass:
            return people.subclass(*args_, **kwargs_)
        else:
            return people(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_comments(self): return self.comments
    def set_comments(self, comments): self.comments = comments
    def add_comments(self, value): self.comments.append(value)
    def insert_comments(self, index, value): self.comments[index] = value
    def get_person(self): return self.person
    def set_person(self, person): self.person = person
    def add_person(self, value): self.person.append(value)
    def insert_person(self, index, value): self.person[index] = value
    def get_programmer(self): return self.programmer
    def set_programmer(self, programmer): self.programmer = programmer
    def add_programmer(self, value): self.programmer.append(value)
    def insert_programmer(self, index, value): self.programmer[index] = value
    def get_python_programmer(self): return self.python_programmer
    def set_python_programmer(self, python_programmer): self.python_programmer = python_programmer
    def add_python_programmer(self, value): self.python_programmer.append(value)
    def insert_python_programmer(self, index, value): self.python_programmer[index] = value
    def get_java_programmer(self): return self.java_programmer
    def set_java_programmer(self, java_programmer): self.java_programmer = java_programmer
    def add_java_programmer(self, value): self.java_programmer.append(value)
    def insert_java_programmer(self, index, value): self.java_programmer[index] = value
    def export(self, outfile, level, namespace_='', name_='people', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='people')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='people'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='people'):
        for comments_ in self.comments:
            comments_.export(outfile, level, namespace_, name_='comments')
        for person_ in self.person:
            person_.export(outfile, level, namespace_, name_='person')
        for programmer_ in self.programmer:
            programmer_.export(outfile, level, namespace_, name_='programmer')
        for python_programmer_ in self.python_programmer:
            python_programmer_.export(outfile, level, namespace_, name_='python-programmer')
        for java_programmer_ in self.java_programmer:
            java_programmer_.export(outfile, level, namespace_, name_='java-programmer')
    def hasContent_(self):
        if (
            self.comments or
            self.person or
            self.programmer or
            self.python_programmer or
            self.java_programmer
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='people'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('comments=[\n')
        level += 1
        for comments_ in self.comments:
            showIndent(outfile, level)
            outfile.write('model_.comments(\n')
            comments_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('person=[\n')
        level += 1
        for person_ in self.person:
            showIndent(outfile, level)
            outfile.write('model_.person(\n')
            person_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('programmer=[\n')
        level += 1
        for programmer_ in self.programmer:
            showIndent(outfile, level)
            outfile.write('model_.programmer(\n')
            programmer_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('python_programmer=[\n')
        level += 1
        for python_programmer_ in self.python_programmer:
            showIndent(outfile, level)
            outfile.write('model_.python_programmer(\n')
            python_programmer_.exportLiteral(outfile, level, name_='python-programmer')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('java_programmer=[\n')
        level += 1
        for java_programmer_ in self.java_programmer:
            showIndent(outfile, level)
            outfile.write('model_.java_programmer(\n')
            java_programmer_.exportLiteral(outfile, level, name_='java-programmer')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'comments': 
            obj_ = comments.factory()
            obj_.build(child_)
            self.comments.append(obj_)
        elif nodeName_ == 'person': 
            obj_ = person.factory()
            obj_.build(child_)
            self.person.append(obj_)
        elif nodeName_ == 'programmer': 
            obj_ = programmer.factory()
            obj_.build(child_)
            self.programmer.append(obj_)
        elif nodeName_ == 'python-programmer': 
            obj_ = python_programmer.factory()
            obj_.build(child_)
            self.python_programmer.append(obj_)
        elif nodeName_ == 'java-programmer': 
            obj_ = java_programmer.factory()
            obj_.build(child_)
            self.java_programmer.append(obj_)
    def walk_and_update(self):
        members = people._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if people.superclass != None:
          people.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: people  depth: %d' % (counter, depth, )
        members = people._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
    def set_up(self):
        global types, counter
        import types as types_module
        types = types_module
        counter = 0
# end class people


class comments(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('emp', 'xs:string', 1),
        MemberSpec_('valueOf_', [], 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, emp=None, valueOf_=None, mixedclass_=None, content_=None):
        if emp is None:
            self.emp = []
        else:
            self.emp = emp
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if comments.subclass:
            return comments.subclass(*args_, **kwargs_)
        else:
            return comments(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_emp(self): return self.emp
    def set_emp(self, emp): self.emp = emp
    def add_emp(self, value): self.emp.append(value)
    def insert_emp(self, index, value): self.emp[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='comments', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='comments')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='comments'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='comments'):
        for item_ in self.content_:
            item_.export(outfile, level, item_.name, namespace_)
    def hasContent_(self):
        if (
            self.emp or
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='comments'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('content_ = [\n')
        for item_ in self.content_:
            item_.exportLiteral(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'emp' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'emp', valuestr_)
            self.content_.append(obj_)
        if child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
    def walk_and_update(self):
        members = comments._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if comments.superclass != None:
          comments.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: comments  depth: %d' % (counter, depth, )
        members = comments._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class comments


class person(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('vegetable', 'xs:string', 0),
        MemberSpec_('fruit', 'xs:string', 0),
        MemberSpec_('ratio', 'xs:float', 0),
        MemberSpec_('id', 'xs:integer', 0),
        MemberSpec_('value', 'xs:string', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('interest', 'xs:string', 1),
        MemberSpec_('category', 'xs:integer', 0),
        MemberSpec_('agent', 'agent', 1),
        MemberSpec_('promoter', 'booster', 1),
        MemberSpec_('description', 'xs:string', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, agent=None, promoter=None, description=None):
        self.vegetable = _cast(None, vegetable)
        self.fruit = _cast(None, fruit)
        self.ratio = _cast(float, ratio)
        self.id = _cast(int, id)
        self.value = _cast(None, value)
        self.name = name
        if interest is None:
            self.interest = []
        else:
            self.interest = interest
        self.category = category
        if agent is None:
            self.agent = []
        else:
            self.agent = agent
        if promoter is None:
            self.promoter = []
        else:
            self.promoter = promoter
        self.description = description
    def factory(*args_, **kwargs_):
        if person.subclass:
            return person.subclass(*args_, **kwargs_)
        else:
            return person(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_interest(self): return self.interest
    def set_interest(self, interest): self.interest = interest
    def add_interest(self, value): self.interest.append(value)
    def insert_interest(self, index, value): self.interest[index] = value
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_agent(self): return self.agent
    def set_agent(self, agent): self.agent = agent
    def add_agent(self, value): self.agent.append(value)
    def insert_agent(self, index, value): self.agent[index] = value
    def get_promoter(self): return self.promoter
    def set_promoter(self, promoter): self.promoter = promoter
    def add_promoter(self, value): self.promoter.append(value)
    def insert_promoter(self, index, value): self.promoter[index] = value
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_vegetable(self): return self.vegetable
    def set_vegetable(self, vegetable): self.vegetable = vegetable
    def get_fruit(self): return self.fruit
    def set_fruit(self, fruit): self.fruit = fruit
    def get_ratio(self): return self.ratio
    def set_ratio(self, ratio): self.ratio = ratio
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def export(self, outfile, level, namespace_='', name_='person', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='person')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='person'):
        if self.vegetable is not None:
            outfile.write(' vegetable=%s' % (self.format_string(quote_attrib(self.vegetable).encode(ExternalEncoding), input_name='vegetable'), ))
        if self.fruit is not None:
            outfile.write(' fruit=%s' % (self.format_string(quote_attrib(self.fruit).encode(ExternalEncoding), input_name='fruit'), ))
        if self.ratio is not None:
            outfile.write(' ratio="%s"' % self.format_float(self.ratio, input_name='ratio'))
        if self.id is not None:
            outfile.write(' id="%s"' % self.format_integer(self.id, input_name='id'))
        if self.value is not None:
            outfile.write(' value=%s' % (self.format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='person'):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('<%sname>%s</%sname>\n' % (namespace_, self.format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_))
        for interest_ in self.interest:
            showIndent(outfile, level)
            outfile.write('<%sinterest>%s</%sinterest>\n' % (namespace_, self.format_string(quote_xml(interest_).encode(ExternalEncoding), input_name='interest'), namespace_))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('<%scategory>%s</%scategory>\n' % (namespace_, self.format_integer(self.category, input_name='category'), namespace_))
        for agent_ in self.agent:
            agent_.export(outfile, level, namespace_, name_='agent')
        for promoter_ in self.promoter:
            promoter_.export(outfile, level, namespace_, name_='promoter')
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
    def hasContent_(self):
        if (
            self.name is not None or
            self.interest or
            self.category is not None or
            self.agent or
            self.promoter or
            self.description is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='person'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.vegetable is not None:
            showIndent(outfile, level)
            outfile.write('vegetable = "%s",\n' % (self.vegetable,))
        if self.fruit is not None:
            showIndent(outfile, level)
            outfile.write('fruit = "%s",\n' % (self.fruit,))
        if self.ratio is not None:
            showIndent(outfile, level)
            outfile.write('ratio = %f,\n' % (self.ratio,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %d,\n' % (self.id,))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value = "%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('interest=[\n')
        level += 1
        for interest_ in self.interest:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(interest_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%d,\n' % self.category)
        showIndent(outfile, level)
        outfile.write('agent=[\n')
        level += 1
        for agent_ in self.agent:
            showIndent(outfile, level)
            outfile.write('model_.agent(\n')
            agent_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('promoter=[\n')
        level += 1
        for promoter_ in self.promoter:
            showIndent(outfile, level)
            outfile.write('model_.booster(\n')
            promoter_.exportLiteral(outfile, level, name_='booster')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        value = attrs.get('vegetable')
        if value is not None:
            self.vegetable = value
        value = attrs.get('fruit')
        if value is not None:
            self.fruit = value
        value = attrs.get('ratio')
        if value is not None:
            try:
                self.ratio = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (ratio): %s' % exp)
        value = attrs.get('id')
        if value is not None:
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = attrs.get('value')
        if value is not None:
            self.value = value
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'name':
            name_ = child_.text
            self.name = name_
        elif nodeName_ == 'interest':
            interest_ = child_.text
            self.interest.append(interest_)
        elif nodeName_ == 'category':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            self.category = ival_
        elif nodeName_ == 'agent': 
            obj_ = agent.factory()
            obj_.build(child_)
            self.agent.append(obj_)
        elif nodeName_ == 'promoter': 
            obj_ = booster.factory()
            obj_.build(child_)
            self.promoter.append(obj_)
        elif nodeName_ == 'description':
            description_ = child_.text
            self.description = description_
    def walk_and_update(self):
        members = person._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if person.superclass != None:
          person.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: person  depth: %d' % (counter, depth, )
        members = person._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class person


class programmer(person):
    member_data_items_ = [
        MemberSpec_('language', 'xs:string', 0),
        MemberSpec_('area', 'xs:string', 0),
        MemberSpec_('attrnegint', 'xs:negativeInteger', 0),
        MemberSpec_('attrposint', 'xs:positiveInteger', 0),
        MemberSpec_('attrnonnegint', 'xs:nonNegativeInteger', 0),
        MemberSpec_('attrnonposint', 'xs:nonPositiveInteger', 0),
        MemberSpec_('email', 'xs:string', 0),
        MemberSpec_('elposint', 'xs:positiveInteger', 0),
        MemberSpec_('elnonposint', 'xs:nonPositiveInteger', 0),
        MemberSpec_('elnegint', 'xs:negativeInteger', 0),
        MemberSpec_('elnonnegint', 'xs:nonNegativeInteger', 0),
        MemberSpec_('eldate', 'xs:date', 0),
        MemberSpec_('eltoken', 'xs:token', 0),
        MemberSpec_('elshort', 'xs:short', 0),
        MemberSpec_('ellong', 'xs:long', 0),
        MemberSpec_('elparam', 'param', 0),
        MemberSpec_('elarraytypes', ['ArrayTypes', 'xs:NMTOKEN'], 0),
        ]
    subclass = None
    superclass = person
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, agent=None, promoter=None, description=None, language=None, area=None, attrnegint=None, attrposint=None, attrnonnegint=None, attrnonposint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None):
        super(programmer, self).__init__(vegetable, fruit, ratio, id, value, name, interest, category, agent, promoter, description, )
        self.language = _cast(None, language)
        self.area = _cast(None, area)
        self.attrnegint = _cast(int, attrnegint)
        self.attrposint = _cast(int, attrposint)
        self.attrnonnegint = _cast(int, attrnonnegint)
        self.attrnonposint = _cast(int, attrnonposint)
        self.email = email
        self.elposint = elposint
        self.elnonposint = elnonposint
        self.elnegint = elnegint
        self.elnonnegint = elnonnegint
        self.eldate = eldate
        self.eltoken = eltoken
        self.elshort = elshort
        self.ellong = ellong
        self.elparam = elparam
        self.elarraytypes = elarraytypes
    def factory(*args_, **kwargs_):
        if programmer.subclass:
            return programmer.subclass(*args_, **kwargs_)
        else:
            return programmer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_elposint(self): return self.elposint
    def set_elposint(self, elposint): self.elposint = elposint
    def get_elnonposint(self): return self.elnonposint
    def set_elnonposint(self, elnonposint): self.elnonposint = elnonposint
    def get_elnegint(self): return self.elnegint
    def set_elnegint(self, elnegint): self.elnegint = elnegint
    def get_elnonnegint(self): return self.elnonnegint
    def set_elnonnegint(self, elnonnegint): self.elnonnegint = elnonnegint
    def get_eldate(self): return self.eldate
    def set_eldate(self, eldate): self.eldate = eldate
    def get_eltoken(self): return self.eltoken
    def set_eltoken(self, eltoken): self.eltoken = eltoken
    def get_elshort(self): return self.elshort
    def set_elshort(self, elshort): self.elshort = elshort
    def get_ellong(self): return self.ellong
    def set_ellong(self, ellong): self.ellong = ellong
    def get_elparam(self): return self.elparam
    def set_elparam(self, elparam): self.elparam = elparam
    def get_elarraytypes(self): return self.elarraytypes
    def set_elarraytypes(self, elarraytypes): self.elarraytypes = elarraytypes
    def validate_elarraytypes(self, value):
        # validate type elarraytypes
        pass
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_area(self): return self.area
    def set_area(self, area): self.area = area
    def get_attrnegint(self): return self.attrnegint
    def set_attrnegint(self, attrnegint): self.attrnegint = attrnegint
    def get_attrposint(self): return self.attrposint
    def set_attrposint(self, attrposint): self.attrposint = attrposint
    def get_attrnonnegint(self): return self.attrnonnegint
    def set_attrnonnegint(self, attrnonnegint): self.attrnonnegint = attrnonnegint
    def get_attrnonposint(self): return self.attrnonposint
    def set_attrnonposint(self, attrnonposint): self.attrnonposint = attrnonposint
    def export(self, outfile, level, namespace_='', name_='programmer', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='programmer')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="programmer"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='programmer'):
        super(programmer, self).exportAttributes(outfile, level, namespace_, name_='programmer')
        if self.language is not None:
            outfile.write(' language=%s' % (self.format_string(quote_attrib(self.language).encode(ExternalEncoding), input_name='language'), ))
        if self.area is not None:
            outfile.write(' area=%s' % (self.format_string(quote_attrib(self.area).encode(ExternalEncoding), input_name='area'), ))
        if self.attrnegint is not None:
            outfile.write(' attrnegint="%s"' % self.format_integer(self.attrnegint, input_name='attrnegint'))
        if self.attrposint is not None:
            outfile.write(' attrposint="%s"' % self.format_integer(self.attrposint, input_name='attrposint'))
        if self.attrnonnegint is not None:
            outfile.write(' attrnonnegint="%s"' % self.format_integer(self.attrnonnegint, input_name='attrnonnegint'))
        if self.attrnonposint is not None:
            outfile.write(' attrnonposint="%s"' % self.format_integer(self.attrnonposint, input_name='attrnonposint'))
    def exportChildren(self, outfile, level, namespace_='', name_='programmer'):
        super(programmer, self).exportChildren(outfile, level, namespace_, name_)
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('<%semail>%s</%semail>\n' % (namespace_, self.format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_))
        if self.elposint is not None:
            showIndent(outfile, level)
            outfile.write('<%selposint>%s</%selposint>\n' % (namespace_, self.format_integer(self.elposint, input_name='elposint'), namespace_))
        if self.elnonposint is not None:
            showIndent(outfile, level)
            outfile.write('<%selnonposint>%s</%selnonposint>\n' % (namespace_, self.format_integer(self.elnonposint, input_name='elnonposint'), namespace_))
        if self.elnegint is not None:
            showIndent(outfile, level)
            outfile.write('<%selnegint>%s</%selnegint>\n' % (namespace_, self.format_integer(self.elnegint, input_name='elnegint'), namespace_))
        if self.elnonnegint is not None:
            showIndent(outfile, level)
            outfile.write('<%selnonnegint>%s</%selnonnegint>\n' % (namespace_, self.format_integer(self.elnonnegint, input_name='elnonnegint'), namespace_))
        if self.eldate is not None:
            showIndent(outfile, level)
            outfile.write('<%seldate>%s</%seldate>\n' % (namespace_, self.format_string(quote_xml(self.eldate).encode(ExternalEncoding), input_name='eldate'), namespace_))
        if self.eltoken is not None:
            showIndent(outfile, level)
            outfile.write('<%seltoken>%s</%seltoken>\n' % (namespace_, self.format_string(quote_xml(self.eltoken).encode(ExternalEncoding), input_name='eltoken'), namespace_))
        if self.elshort is not None:
            showIndent(outfile, level)
            outfile.write('<%selshort>%s</%selshort>\n' % (namespace_, self.format_integer(self.elshort, input_name='elshort'), namespace_))
        if self.ellong is not None:
            showIndent(outfile, level)
            outfile.write('<%sellong>%s</%sellong>\n' % (namespace_, self.format_integer(self.ellong, input_name='ellong'), namespace_))
        if self.elparam:
            self.elparam.export(outfile, level, namespace_, name_='elparam', )
        if self.elarraytypes is not None:
            showIndent(outfile, level)
            outfile.write('<%selarraytypes>%s</%selarraytypes>\n' % (namespace_, self.format_string(quote_xml(self.elarraytypes).encode(ExternalEncoding), input_name='elarraytypes'), namespace_))
    def hasContent_(self):
        if (
            self.email is not None or
            self.elposint is not None or
            self.elnonposint is not None or
            self.elnegint is not None or
            self.elnonnegint is not None or
            self.eldate is not None or
            self.eltoken is not None or
            self.elshort is not None or
            self.ellong is not None or
            self.elparam is not None or
            self.elarraytypes is not None or
            super(programmer, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='programmer'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.language is not None:
            showIndent(outfile, level)
            outfile.write('language = "%s",\n' % (self.language,))
        if self.area is not None:
            showIndent(outfile, level)
            outfile.write('area = "%s",\n' % (self.area,))
        if self.attrnegint is not None:
            showIndent(outfile, level)
            outfile.write('attrnegint = %d,\n' % (self.attrnegint,))
        if self.attrposint is not None:
            showIndent(outfile, level)
            outfile.write('attrposint = %d,\n' % (self.attrposint,))
        if self.attrnonnegint is not None:
            showIndent(outfile, level)
            outfile.write('attrnonnegint = %d,\n' % (self.attrnonnegint,))
        if self.attrnonposint is not None:
            showIndent(outfile, level)
            outfile.write('attrnonposint = %d,\n' % (self.attrnonposint,))
        super(programmer, self).exportLiteralAttributes(outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(programmer, self).exportLiteralChildren(outfile, level, name_)
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.elposint is not None:
            showIndent(outfile, level)
            outfile.write('elposint=%d,\n' % self.elposint)
        if self.elnonposint is not None:
            showIndent(outfile, level)
            outfile.write('elnonposint=%d,\n' % self.elnonposint)
        if self.elnegint is not None:
            showIndent(outfile, level)
            outfile.write('elnegint=%d,\n' % self.elnegint)
        if self.elnonnegint is not None:
            showIndent(outfile, level)
            outfile.write('elnonnegint=%d,\n' % self.elnonnegint)
        if self.eldate is not None:
            showIndent(outfile, level)
            outfile.write('eldate=%s,\n' % quote_python(self.eldate).encode(ExternalEncoding))
        if self.eltoken is not None:
            showIndent(outfile, level)
            outfile.write('eltoken=%s,\n' % quote_python(self.eltoken).encode(ExternalEncoding))
        if self.elshort is not None:
            showIndent(outfile, level)
            outfile.write('elshort=%d,\n' % self.elshort)
        if self.ellong is not None:
            showIndent(outfile, level)
            outfile.write('ellong=%d,\n' % self.ellong)
        if self.elparam is not None:
            showIndent(outfile, level)
            outfile.write('elparam=model_.param(\n')
            self.elparam.exportLiteral(outfile, level, name_='elparam')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.elarraytypes is not None:
            showIndent(outfile, level)
            outfile.write('elarraytypes=%s,\n' % quote_python(self.elarraytypes).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        value = attrs.get('language')
        if value is not None:
            self.language = value
        value = attrs.get('area')
        if value is not None:
            self.area = value
        value = attrs.get('attrnegint')
        if value is not None:
            try:
                self.attrnegint = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnegint >= 0:
                raise_parse_error(node, 'Invalid NegativeInteger')
        value = attrs.get('attrposint')
        if value is not None:
            try:
                self.attrposint = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrposint <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = attrs.get('attrnonnegint')
        if value is not None:
            try:
                self.attrnonnegint = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnonnegint < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = attrs.get('attrnonposint')
        if value is not None:
            try:
                self.attrnonposint = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnonposint > 0:
                raise_parse_error(node, 'Invalid NonPositiveInteger')
        super(programmer, self).buildAttributes(node, attrs)
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'email':
            email_ = child_.text
            self.email = email_
        elif nodeName_ == 'elposint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            self.elposint = ival_
        elif nodeName_ == 'elnonposint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ > 0:
                raise_parse_error(child_, 'requires nonPositiveInteger')
            self.elnonposint = ival_
        elif nodeName_ == 'elnegint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ >= 0:
                raise_parse_error(child_, 'requires negativeInteger')
            self.elnegint = ival_
        elif nodeName_ == 'elnonnegint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            self.elnonnegint = ival_
        elif nodeName_ == 'eldate':
            eldate_ = child_.text
            self.eldate = eldate_
        elif nodeName_ == 'eltoken':
            eltoken_ = child_.text
            self.eltoken = ' '.join(eltoken_.split())
            self.eltoken = eltoken_
        elif nodeName_ == 'elshort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            self.elshort = ival_
        elif nodeName_ == 'ellong':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            self.ellong = ival_
        elif nodeName_ == 'elparam': 
            obj_ = param.factory()
            obj_.build(child_)
            self.set_elparam(obj_)
        elif nodeName_ == 'elarraytypes':
            elarraytypes_ = child_.text
            self.elarraytypes = elarraytypes_
            self.validate_elarraytypes(self.elarraytypes)    # validate type elarraytypes
        super(programmer, self).buildChildren(child_, nodeName_)
    def walk_and_update(self):
        members = programmer._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if programmer.superclass != None:
          programmer.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: programmer  depth: %d' % (counter, depth, )
        members = programmer._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class programmer


class param(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('semantic', 'xs:token', 0),
        MemberSpec_('name', 'xs:NCName', 0),
        MemberSpec_('flow', 'FlowType', 0),
        MemberSpec_('sid', 'xs:NCName', 0),
        MemberSpec_('type', 'xs:NMTOKEN', 0),
        MemberSpec_('id', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:string', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, semantic=None, name=None, flow=None, sid=None, type_=None, id=None, valueOf_=None):
        self.semantic = _cast(None, semantic)
        self.name = _cast(None, name)
        self.flow = _cast(None, flow)
        self.sid = _cast(None, sid)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if param.subclass:
            return param.subclass(*args_, **kwargs_)
        else:
            return param(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_semantic(self): return self.semantic
    def set_semantic(self, semantic): self.semantic = semantic
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_flow(self): return self.flow
    def set_flow(self, flow): self.flow = flow
    def get_sid(self): return self.sid
    def set_sid(self, sid): self.sid = sid
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='param', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='param')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='param'):
        if self.semantic is not None:
            outfile.write(' semantic=%s' % (self.format_string(quote_attrib(self.semantic).encode(ExternalEncoding), input_name='semantic'), ))
        if self.name is not None:
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.flow is not None:
            outfile.write(' flow=%s' % (quote_attrib(self.flow), ))
        if self.sid is not None:
            outfile.write(' sid=%s' % (quote_attrib(self.sid), ))
        outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.id is not None:
            outfile.write(' id=%s' % (self.format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='param'):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='param'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.semantic is not None:
            showIndent(outfile, level)
            outfile.write('semantic = "%s",\n' % (self.semantic,))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.flow is not None:
            showIndent(outfile, level)
            outfile.write('flow = %s,\n' % (self.flow,))
        if self.sid is not None:
            showIndent(outfile, level)
            outfile.write('sid = "%s",\n' % (self.sid,))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        value = attrs.get('semantic')
        if value is not None:
            self.semantic = value
            self.semantic = ' '.join(self.semantic.split())
        value = attrs.get('name')
        if value is not None:
            self.name = value
        value = attrs.get('flow')
        if value is not None:
            self.flow = value
        value = attrs.get('sid')
        if value is not None:
            self.sid = value
        value = attrs.get('type')
        if value is not None:
            self.type_ = value
        value = attrs.get('id')
        if value is not None:
            self.id = value
    def buildChildren(self, child_, nodeName_):
        pass
    def walk_and_update(self):
        members = param._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if param.superclass != None:
          param.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: param  depth: %d' % (counter, depth, )
        members = param._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class param


class python_programmer(programmer):
    member_data_items_ = [
        MemberSpec_('nick-name', 'xs:string', 0),
        MemberSpec_('favorite_editor', 'xs:string', 0),
        ]
    subclass = None
    superclass = programmer
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, agent=None, promoter=None, description=None, language=None, area=None, attrnegint=None, attrposint=None, attrnonnegint=None, attrnonposint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None, nick_name=None, favorite_editor=None):
        super(python_programmer, self).__init__(vegetable, fruit, ratio, id, value, name, interest, category, agent, promoter, description, language, area, attrnegint, attrposint, attrnonnegint, attrnonposint, email, elposint, elnonposint, elnegint, elnonnegint, eldate, eltoken, elshort, ellong, elparam, elarraytypes, )
        self.nick_name = _cast(None, nick_name)
        self.favorite_editor = favorite_editor
    def factory(*args_, **kwargs_):
        if python_programmer.subclass:
            return python_programmer.subclass(*args_, **kwargs_)
        else:
            return python_programmer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_favorite_editor(self): return self.favorite_editor
    def set_favorite_editor(self, favorite_editor): self.favorite_editor = favorite_editor
    def get_nick_name(self): return self.nick_name
    def set_nick_name(self, nick_name): self.nick_name = nick_name
    def export(self, outfile, level, namespace_='', name_='python-programmer', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='python-programmer')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="python-programmer"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='python-programmer'):
        super(python_programmer, self).exportAttributes(outfile, level, namespace_, name_='python-programmer')
        if self.nick_name is not None:
            outfile.write(' nick-name=%s' % (self.format_string(quote_attrib(self.nick_name).encode(ExternalEncoding), input_name='nick-name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='python-programmer'):
        super(python_programmer, self).exportChildren(outfile, level, namespace_, name_)
        if self.favorite_editor is not None:
            showIndent(outfile, level)
            outfile.write('<%sfavorite-editor>%s</%sfavorite-editor>\n' % (namespace_, self.format_string(quote_xml(self.favorite_editor).encode(ExternalEncoding), input_name='favorite-editor'), namespace_))
    def hasContent_(self):
        if (
            self.favorite_editor is not None or
            super(python_programmer, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='python-programmer'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.nick_name is not None:
            showIndent(outfile, level)
            outfile.write('nick_name = "%s",\n' % (self.nick_name,))
        super(python_programmer, self).exportLiteralAttributes(outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(python_programmer, self).exportLiteralChildren(outfile, level, name_)
        if self.favorite_editor is not None:
            showIndent(outfile, level)
            outfile.write('favorite_editor=%s,\n' % quote_python(self.favorite_editor).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        value = attrs.get('nick-name')
        if value is not None:
            self.nick_name = value
        super(python_programmer, self).buildAttributes(node, attrs)
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'favorite-editor':
            favorite_editor_ = child_.text
            self.favorite_editor = favorite_editor_
        super(python_programmer, self).buildChildren(child_, nodeName_)
    def walk_and_update(self):
        members = python_programmer._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if python_programmer.superclass != None:
          python_programmer.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: python_programmer  depth: %d' % (counter, depth, )
        members = python_programmer._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class python_programmer


class java_programmer(programmer):
    member_data_items_ = [
        MemberSpec_('status', 'xs:string', 0),
        MemberSpec_('nick-name', 'xs:string', 0),
        MemberSpec_('favorite_editor', 'xs:string', 0),
        ]
    subclass = None
    superclass = programmer
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, agent=None, promoter=None, description=None, language=None, area=None, attrnegint=None, attrposint=None, attrnonnegint=None, attrnonposint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None, status=None, nick_name=None, favorite_editor=None):
        super(java_programmer, self).__init__(vegetable, fruit, ratio, id, value, name, interest, category, agent, promoter, description, language, area, attrnegint, attrposint, attrnonnegint, attrnonposint, email, elposint, elnonposint, elnegint, elnonnegint, eldate, eltoken, elshort, ellong, elparam, elarraytypes, )
        self.status = _cast(None, status)
        self.nick_name = _cast(None, nick_name)
        self.favorite_editor = favorite_editor
    def factory(*args_, **kwargs_):
        if java_programmer.subclass:
            return java_programmer.subclass(*args_, **kwargs_)
        else:
            return java_programmer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_favorite_editor(self): return self.favorite_editor
    def set_favorite_editor(self, favorite_editor): self.favorite_editor = favorite_editor
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_nick_name(self): return self.nick_name
    def set_nick_name(self, nick_name): self.nick_name = nick_name
    def export(self, outfile, level, namespace_='', name_='java-programmer', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='java-programmer')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(' xsi:type="java-programmer"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='java-programmer'):
        super(java_programmer, self).exportAttributes(outfile, level, namespace_, name_='java-programmer')
        if self.status is not None:
            outfile.write(' status=%s' % (self.format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.nick_name is not None:
            outfile.write(' nick-name=%s' % (self.format_string(quote_attrib(self.nick_name).encode(ExternalEncoding), input_name='nick-name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='java-programmer'):
        super(java_programmer, self).exportChildren(outfile, level, namespace_, name_)
        if self.favorite_editor is not None:
            showIndent(outfile, level)
            outfile.write('<%sfavorite-editor>%s</%sfavorite-editor>\n' % (namespace_, self.format_string(quote_xml(self.favorite_editor).encode(ExternalEncoding), input_name='favorite-editor'), namespace_))
    def hasContent_(self):
        if (
            self.favorite_editor is not None or
            super(java_programmer, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='java-programmer'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status = "%s",\n' % (self.status,))
        if self.nick_name is not None:
            showIndent(outfile, level)
            outfile.write('nick_name = "%s",\n' % (self.nick_name,))
        super(java_programmer, self).exportLiteralAttributes(outfile, level, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(java_programmer, self).exportLiteralChildren(outfile, level, name_)
        if self.favorite_editor is not None:
            showIndent(outfile, level)
            outfile.write('favorite_editor=%s,\n' % quote_python(self.favorite_editor).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        value = attrs.get('status')
        if value is not None:
            self.status = value
        value = attrs.get('nick-name')
        if value is not None:
            self.nick_name = value
        super(java_programmer, self).buildAttributes(node, attrs)
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'favorite-editor':
            favorite_editor_ = child_.text
            self.favorite_editor = favorite_editor_
        super(java_programmer, self).buildChildren(child_, nodeName_)
    def walk_and_update(self):
        members = java_programmer._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if java_programmer.superclass != None:
          java_programmer.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: java_programmer  depth: %d' % (counter, depth, )
        members = java_programmer._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class java_programmer


class agent(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('priority', 'xs:float', 0),
        MemberSpec_('info', 'info', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, firstname=None, lastname=None, priority=None, info=None):
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.info = info
    def factory(*args_, **kwargs_):
        if agent.subclass:
            return agent.subclass(*args_, **kwargs_)
        else:
            return agent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    def export(self, outfile, level, namespace_='', name_='agent', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='agent')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='agent'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='agent'):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirstname>%s</%sfirstname>\n' % (namespace_, self.format_string(quote_xml(self.firstname).encode(ExternalEncoding), input_name='firstname'), namespace_))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('<%slastname>%s</%slastname>\n' % (namespace_, self.format_string(quote_xml(self.lastname).encode(ExternalEncoding), input_name='lastname'), namespace_))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('<%spriority>%s</%spriority>\n' % (namespace_, self.format_float(self.priority, input_name='priority'), namespace_))
        if self.info:
            self.info.export(outfile, level, namespace_, name_='info', )
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.info is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='agent'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('firstname=%s,\n' % quote_python(self.firstname).encode(ExternalEncoding))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('lastname=%s,\n' % quote_python(self.lastname).encode(ExternalEncoding))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%f,\n' % self.priority)
        if self.info is not None:
            showIndent(outfile, level)
            outfile.write('info=model_.info(\n')
            self.info.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            self.priority = fval_
        elif nodeName_ == 'info': 
            obj_ = info.factory()
            obj_.build(child_)
            self.set_info(obj_)
    def walk_and_update(self):
        members = agent._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if agent.superclass != None:
          agent.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: agent  depth: %d' % (counter, depth, )
        members = agent._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class agent


class special_agent(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('priority', 'xs:float', 0),
        MemberSpec_('info', 'info', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, firstname=None, lastname=None, priority=None, info=None):
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.info = info
    def factory(*args_, **kwargs_):
        if special_agent.subclass:
            return special_agent.subclass(*args_, **kwargs_)
        else:
            return special_agent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    def export(self, outfile, level, namespace_='', name_='special-agent', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='special-agent')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='special-agent'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='special-agent'):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirstname>%s</%sfirstname>\n' % (namespace_, self.format_string(quote_xml(self.firstname).encode(ExternalEncoding), input_name='firstname'), namespace_))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('<%slastname>%s</%slastname>\n' % (namespace_, self.format_string(quote_xml(self.lastname).encode(ExternalEncoding), input_name='lastname'), namespace_))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('<%spriority>%s</%spriority>\n' % (namespace_, self.format_float(self.priority, input_name='priority'), namespace_))
        if self.info:
            self.info.export(outfile, level, namespace_, name_='info', )
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.info is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='special-agent'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('firstname=%s,\n' % quote_python(self.firstname).encode(ExternalEncoding))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('lastname=%s,\n' % quote_python(self.lastname).encode(ExternalEncoding))
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority=%f,\n' % self.priority)
        if self.info is not None:
            showIndent(outfile, level)
            outfile.write('info=model_.info(\n')
            self.info.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            self.priority = fval_
        elif nodeName_ == 'info': 
            obj_ = info.factory()
            obj_.build(child_)
            self.set_info(obj_)
    def walk_and_update(self):
        members = special_agent._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if special_agent.superclass != None:
          special_agent.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: special_agent  depth: %d' % (counter, depth, )
        members = special_agent._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class special_agent


class booster(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('other_name', 'xs:float', 0),
        MemberSpec_('classxx', 'xs:float', 0),
        MemberSpec_('other_value', 'xs:float', 1),
        MemberSpec_('type_', 'xs:float', 1),
        MemberSpec_('client_handler', 'client-handler', 1),
        ]
    subclass = None
    superclass = None
    def __init__(self, firstname=None, lastname=None, other_name=None, classxx=None, other_value=None, type_=None, client_handler=None):
        self.firstname = firstname
        self.lastname = lastname
        self.other_name = other_name
        self.classxx = classxx
        if other_value is None:
            self.other_value = []
        else:
            self.other_value = other_value
        if type_ is None:
            self.type_ = []
        else:
            self.type_ = type_
        if client_handler is None:
            self.client_handler = []
        else:
            self.client_handler = client_handler
    def factory(*args_, **kwargs_):
        if booster.subclass:
            return booster.subclass(*args_, **kwargs_)
        else:
            return booster(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_other_name(self): return self.other_name
    def set_other_name(self, other_name): self.other_name = other_name
    def get_class(self): return self.classxx
    def set_class(self, classxx): self.classxx = classxx
    def get_other_value(self): return self.other_value
    def set_other_value(self, other_value): self.other_value = other_value
    def add_other_value(self, value): self.other_value.append(value)
    def insert_other_value(self, index, value): self.other_value[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def add_type(self, value): self.type_.append(value)
    def insert_type(self, index, value): self.type_[index] = value
    def get_client_handler(self): return self.client_handler
    def set_client_handler(self, client_handler): self.client_handler = client_handler
    def add_client_handler(self, value): self.client_handler.append(value)
    def insert_client_handler(self, index, value): self.client_handler[index] = value
    def export(self, outfile, level, namespace_='', name_='booster', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='booster')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='booster'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='booster'):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirstname>%s</%sfirstname>\n' % (namespace_, self.format_string(quote_xml(self.firstname).encode(ExternalEncoding), input_name='firstname'), namespace_))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('<%slastname>%s</%slastname>\n' % (namespace_, self.format_string(quote_xml(self.lastname).encode(ExternalEncoding), input_name='lastname'), namespace_))
        if self.other_name is not None:
            showIndent(outfile, level)
            outfile.write('<%sother-name>%s</%sother-name>\n' % (namespace_, self.format_float(self.other_name, input_name='other-name'), namespace_))
        if self.classxx is not None:
            showIndent(outfile, level)
            outfile.write('<%sclass>%s</%sclass>\n' % (namespace_, self.format_float(self.classxx, input_name='class'), namespace_))
        for other_value_ in self.other_value:
            showIndent(outfile, level)
            outfile.write('<%sother-value>%s</%sother-value>\n' % (namespace_, self.format_float(other_value_, input_name='other-value'), namespace_))
        for type_ in self.type_:
            showIndent(outfile, level)
            outfile.write('<%stype>%s</%stype>\n' % (namespace_, self.format_float(type_, input_name='type'), namespace_))
        for client_handler_ in self.client_handler:
            client_handler_.export(outfile, level, namespace_, name_='client-handler')
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.other_name is not None or
            self.classxx is not None or
            self.other_value or
            self.type_ or
            self.client_handler
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='booster'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.firstname is not None:
            showIndent(outfile, level)
            outfile.write('firstname=%s,\n' % quote_python(self.firstname).encode(ExternalEncoding))
        if self.lastname is not None:
            showIndent(outfile, level)
            outfile.write('lastname=%s,\n' % quote_python(self.lastname).encode(ExternalEncoding))
        if self.other_name is not None:
            showIndent(outfile, level)
            outfile.write('other_name=%f,\n' % self.other_name)
        if self.classxx is not None:
            showIndent(outfile, level)
            outfile.write('classxx=%f,\n' % self.classxx)
        showIndent(outfile, level)
        outfile.write('other_value=[\n')
        level += 1
        for other_value_ in self.other_value:
            showIndent(outfile, level)
            outfile.write('%f,\n' % other_value_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('type_=[\n')
        level += 1
        for type_ in self.type_:
            showIndent(outfile, level)
            outfile.write('%f,\n' % type_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('client_handler=[\n')
        level += 1
        for client_handler_ in self.client_handler:
            showIndent(outfile, level)
            outfile.write('model_.client_handler(\n')
            client_handler_.exportLiteral(outfile, level, name_='client-handler')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            self.lastname = lastname_
        elif nodeName_ == 'other-name':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            self.other_name = fval_
        elif nodeName_ == 'class':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            self.classxx = fval_
        elif nodeName_ == 'other-value':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            self.other_value.append(fval_)
        elif nodeName_ == 'type':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            self.type_.append(fval_)
        elif nodeName_ == 'client-handler': 
            obj_ = client_handler.factory()
            obj_.build(child_)
            self.client_handler.append(obj_)
    def walk_and_update(self):
        members = booster._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if booster.superclass != None:
          booster.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: booster  depth: %d' % (counter, depth, )
        members = booster._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class booster


class client_handler(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('fullname', 'xs:string', 0),
        MemberSpec_('refid', 'xs:integer', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, fullname=None, refid=None):
        self.fullname = fullname
        self.refid = refid
    def factory(*args_, **kwargs_):
        if client_handler.subclass:
            return client_handler.subclass(*args_, **kwargs_)
        else:
            return client_handler(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fullname(self): return self.fullname
    def set_fullname(self, fullname): self.fullname = fullname
    def get_refid(self): return self.refid
    def set_refid(self, refid): self.refid = refid
    def export(self, outfile, level, namespace_='', name_='client-handler', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='client-handler')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='client-handler'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='client-handler'):
        if self.fullname is not None:
            showIndent(outfile, level)
            outfile.write('<%sfullname>%s</%sfullname>\n' % (namespace_, self.format_string(quote_xml(self.fullname).encode(ExternalEncoding), input_name='fullname'), namespace_))
        if self.refid is not None:
            showIndent(outfile, level)
            outfile.write('<%srefid>%s</%srefid>\n' % (namespace_, self.format_integer(self.refid, input_name='refid'), namespace_))
    def hasContent_(self):
        if (
            self.fullname is not None or
            self.refid is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='client-handler'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.fullname is not None:
            showIndent(outfile, level)
            outfile.write('fullname=%s,\n' % quote_python(self.fullname).encode(ExternalEncoding))
        if self.refid is not None:
            showIndent(outfile, level)
            outfile.write('refid=%d,\n' % self.refid)
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if nodeName_ == 'fullname':
            fullname_ = child_.text
            self.fullname = fullname_
        elif nodeName_ == 'refid':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            self.refid = ival_
    def walk_and_update(self):
        members = client_handler._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if client_handler.superclass != None:
          client_handler.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: client_handler  depth: %d' % (counter, depth, )
        members = client_handler._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class client_handler


class info(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('rating', 'xs:float', 0),
        MemberSpec_('type', 'xs:integer', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('valueOf_', [], 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, rating=None, type_=None, name=None, valueOf_=None):
        self.rating = _cast(float, rating)
        self.type_ = _cast(int, type_)
        self.name = _cast(None, name)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if info.subclass:
            return info.subclass(*args_, **kwargs_)
        else:
            return info(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rating(self): return self.rating
    def set_rating(self, rating): self.rating = rating
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def export(self, outfile, level, namespace_='', name_='info', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='info')
        if self.hasContent_():
            outfile.write('>')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='info'):
        if self.rating is not None:
            outfile.write(' rating="%s"' % self.format_float(self.rating, input_name='rating'))
        if self.type_ is not None:
            outfile.write(' type="%s"' % self.format_integer(self.type_, input_name='type'))
        if self.name is not None:
            outfile.write(' name=%s' % (self.format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='info'):
        pass
    def hasContent_(self):
        if (
            self.valueOf_
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='info'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.rating is not None:
            showIndent(outfile, level)
            outfile.write('rating = %f,\n' % (self.rating,))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_ = %d,\n' % (self.type_,))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def build(self, node):
        self.buildAttributes(node, node.attrib)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, nodeName_)
    def buildAttributes(self, node, attrs):
        value = attrs.get('rating')
        if value is not None:
            try:
                self.rating = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (rating): %s' % exp)
        value = attrs.get('type')
        if value is not None:
            try:
                self.type_ = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = attrs.get('name')
        if value is not None:
            self.name = value
    def buildChildren(self, child_, nodeName_):
        pass
    def walk_and_update(self):
        members = info._member_data_items
        for member in members:
            obj1 = getattr(self, member.get_name())
            if member.get_data_type() == 'xs:date':
                newvalue = date_calcs.date_from_string(obj1)
                setattr(self, member.get_name(), newvalue)
            elif member.get_container():
                for child in obj1:
                    if type(child) == types.InstanceType:
                        child.walk_and_update()
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_update()
        if info.superclass != None:
          info.superclass.walk_and_update(self)
    def walk_and_show(self, depth):
        global counter
        counter += 1
        depth += 1
        print '%d. class: info  depth: %d' % (counter, depth, )
        members = info._member_data_items
        for member in members:
            s1 = member.get_name()
            s2 = member.get_data_type()
            s3 = '%d' % member.get_container()
            obj1 = getattr(self, member.get_name())
            if member.get_container():
                s4 = '<container>'
            else:
                if type(obj1) != types.InstanceType:
                    s4 = '%s' % obj1
                else:
                    s4 = '<instance>'
            s5 = '%s%s%s  %s' % (s1.ljust(16), s2.ljust(16), s3.rjust(4), s4, )
            print '   ', s5
        for member in members:
            if member.get_container():
                for child in getattr(self, member.get_name()):
                    if type(child) == types.InstanceType:
                        child.walk_and_show(depth)
            else:
                obj1 = getattr(self, member.get_name())
                if type(obj1) == types.InstanceType:
                    obj1.walk_and_show(depth)
# end class info


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag, 
        namespacedef_='')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="people",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from out2sup import *\n\n')
    sys.stdout.write('import out2sup as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

