#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated  by generateDS.py.
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class PurchaseOrderType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('orderDate', 'date', 0),
        MemberSpec_('shipTo', 'Address', 0),
        MemberSpec_('billTo', 'Address', 0),
        MemberSpec_('comment', 'string', 0),
        MemberSpec_('items', 'Items', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, orderDate=None, shipTo=None, billTo=None, comment=None, items=None):
        if isinstance(orderDate, basestring):
            initvalue_ = datetime_.datetime.strptime(orderDate, '%Y-%m-%d').date()
        else:
            initvalue_ = orderDate
        self.orderDate = initvalue_
        self.shipTo = shipTo
        self.billTo = billTo
        self.comment = comment
        self.items = items
    def factory(*args_, **kwargs_):
        if PurchaseOrderType.subclass:
            return PurchaseOrderType.subclass(*args_, **kwargs_)
        else:
            return PurchaseOrderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_shipTo(self): return self.shipTo
    def set_shipTo(self, shipTo): self.shipTo = shipTo
    def get_billTo(self): return self.billTo
    def set_billTo(self, billTo): self.billTo = billTo
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def get_items(self): return self.items
    def set_items(self, items): self.items = items
    def get_orderDate(self): return self.orderDate
    def set_orderDate(self, orderDate): self.orderDate = orderDate
    def hasContent_(self):
        if (
            self.shipTo is not None or
            self.billTo is not None or
            self.comment is not None or
            self.items is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ipo:', name_='PurchaseOrderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PurchaseOrderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ipo:', name_='PurchaseOrderType'):
        if self.orderDate is not None and 'orderDate' not in already_processed:
            already_processed.add('orderDate')
            outfile.write(' orderDate="%s"' % self.gds_format_date(self.orderDate, input_name='orderDate'))
    def exportChildren(self, outfile, level, namespace_='ipo:', name_='PurchaseOrderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.shipTo is not None:
            self.shipTo.export(outfile, level, namespace_, name_='shipTo', pretty_print=pretty_print)
        if self.billTo is not None:
            self.billTo.export(outfile, level, namespace_, name_='billTo', pretty_print=pretty_print)
        if self.comment is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomment>%s</%scomment>%s' % (namespace_, self.gds_format_string(quote_xml(self.comment).encode(ExternalEncoding), input_name='comment'), namespace_, eol_))
        if self.items is not None:
            self.items.export(outfile, level, namespace_, name_='items', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PurchaseOrderType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.orderDate is not None and 'orderDate' not in already_processed:
            already_processed.add('orderDate')
            showIndent(outfile, level)
            outfile.write('orderDate=model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(self.orderDate, input_name='orderDate'))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.shipTo is not None:
            showIndent(outfile, level)
            outfile.write('shipTo=model_.Address(\n')
            self.shipTo.exportLiteral(outfile, level, name_='shipTo')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.billTo is not None:
            showIndent(outfile, level)
            outfile.write('billTo=model_.Address(\n')
            self.billTo.exportLiteral(outfile, level, name_='billTo')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.comment is not None:
            showIndent(outfile, level)
            outfile.write('comment=%s,\n' % quote_python(self.comment).encode(ExternalEncoding))
        if self.items is not None:
            showIndent(outfile, level)
            outfile.write('items=model_.Items(\n')
            self.items.exportLiteral(outfile, level, name_='items')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('orderDate', node)
        if value is not None and 'orderDate' not in already_processed:
            already_processed.add('orderDate')
            try:
                self.orderDate = self.gds_parse_date(value)
            except ValueError, exp:
                raise ValueError('Bad date attribute (orderDate): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'shipTo':
            class_obj_ = self.get_class_obj_(child_, Address)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.shipTo = obj_
        elif nodeName_ == 'billTo':
            class_obj_ = self.get_class_obj_(child_, Address)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.billTo = obj_
        elif nodeName_ == 'comment':
            comment_ = child_.text
            comment_ = self.gds_validate_string(comment_, node, 'comment')
            self.comment = comment_
        elif nodeName_ == 'items':
            obj_ = Items.factory()
            obj_.build(child_)
            self.items = obj_
# end class PurchaseOrderType


class Items(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('item', 'itemType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, item=None):
        if item is None:
            self.item = []
        else:
            self.item = item
    def factory(*args_, **kwargs_):
        if Items.subclass:
            return Items.subclass(*args_, **kwargs_)
        else:
            return Items(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_item(self): return self.item
    def set_item(self, item): self.item = item
    def add_item(self, value): self.item.append(value)
    def insert_item(self, index, value): self.item[index] = value
    def hasContent_(self):
        if (
            self.item
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ipo:', name_='Items', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Items')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ipo:', name_='Items'):
        pass
    def exportChildren(self, outfile, level, namespace_='ipo:', name_='Items', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for item_ in self.item:
            item_.export(outfile, level, namespace_, name_='item', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Items'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('item=[\n')
        level += 1
        for item_ in self.item:
            showIndent(outfile, level)
            outfile.write('model_.itemType(\n')
            item_.exportLiteral(outfile, level, name_='itemType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'item':
            obj_ = itemType.factory()
            obj_.build(child_)
            self.item.append(obj_)
# end class Items


class Address(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('name', 'string', 0),
        MemberSpec_('street', 'string', 0),
        MemberSpec_('city', 'string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, street=None, city=None, extensiontype_=None):
        self.name = name
        self.street = street
        self.city = city
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Address.subclass:
            return Address.subclass(*args_, **kwargs_)
        else:
            return Address(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_street(self): return self.street
    def set_street(self, street): self.street = street
    def get_city(self): return self.city
    def set_city(self, city): self.city = city
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.name is not None or
            self.street is not None or
            self.city is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ipo:', name_='Address', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Address')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ipo:', name_='Address'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='ipo:', name_='Address', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.street is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstreet>%s</%sstreet>%s' % (namespace_, self.gds_format_string(quote_xml(self.street).encode(ExternalEncoding), input_name='street'), namespace_, eol_))
        if self.city is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scity>%s</%scity>%s' % (namespace_, self.gds_format_string(quote_xml(self.city).encode(ExternalEncoding), input_name='city'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='Address'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
        if self.street is not None:
            showIndent(outfile, level)
            outfile.write('street=%s,\n' % quote_python(self.street).encode(ExternalEncoding))
        if self.city is not None:
            showIndent(outfile, level)
            outfile.write('city=%s,\n' % quote_python(self.city).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'street':
            street_ = child_.text
            street_ = self.gds_validate_string(street_, node, 'street')
            self.street = street_
        elif nodeName_ == 'city':
            city_ = child_.text
            city_ = self.gds_validate_string(city_, node, 'city')
            self.city = city_
# end class Address


class USAddress(Address):
    member_data_items_ = [
        MemberSpec_('state', ['USState', 'string'], 0),
        MemberSpec_('zip', 'positiveInteger', 0),
    ]
    subclass = None
    superclass = Address
    def __init__(self, name=None, street=None, city=None, state=None, zip=None):
        super(USAddress, self).__init__(name, street, city, )
        self.state = state
        self.zip = zip
    def factory(*args_, **kwargs_):
        if USAddress.subclass:
            return USAddress.subclass(*args_, **kwargs_)
        else:
            return USAddress(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def get_zip(self): return self.zip
    def set_zip(self, zip): self.zip = zip
    def validate_USState(self, value):
        # Validate type USState, a restriction on string.
        pass
    def hasContent_(self):
        if (
            self.state is not None or
            self.zip is not None or
            super(USAddress, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ipo:', name_='USAddress', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='USAddress')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ipo:', name_='USAddress'):
        super(USAddress, self).exportAttributes(outfile, level, already_processed, namespace_, name_='USAddress')
    def exportChildren(self, outfile, level, namespace_='ipo:', name_='USAddress', fromsubclass_=False, pretty_print=True):
        super(USAddress, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstate>%s</%sstate>%s' % (namespace_, self.gds_format_string(quote_xml(self.state).encode(ExternalEncoding), input_name='state'), namespace_, eol_))
        if self.zip is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%szip>%s</%szip>%s' % (namespace_, self.gds_format_integer(self.zip, input_name='zip'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='USAddress'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(USAddress, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(USAddress, self).exportLiteralChildren(outfile, level, name_)
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('state=%s,\n' % quote_python(self.state).encode(ExternalEncoding))
        if self.zip is not None:
            showIndent(outfile, level)
            outfile.write('zip=%d,\n' % self.zip)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(USAddress, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state = state_
            self.validate_USState(self.state)    # validate type USState
        elif nodeName_ == 'zip':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'zip')
            self.zip = ival_
        super(USAddress, self).buildChildren(child_, node, nodeName_, True)
# end class USAddress


class UKAddress(Address):
    member_data_items_ = [
        MemberSpec_('category_attr', 'xs:string', 0),
        MemberSpec_('exportCode', 'positiveInteger', 0),
        MemberSpec_('postcode', ['UKPostcode', 'string'], 0),
        MemberSpec_('category', 'string', 0),
    ]
    subclass = None
    superclass = Address
    def __init__(self, name=None, street=None, city=None, category_attr=None, exportCode=None, postcode=None, category=None):
        super(UKAddress, self).__init__(name, street, city, )
        self.category_attr = _cast(None, category_attr)
        self.exportCode = _cast(int, exportCode)
        self.postcode = postcode
        self.category = category
    def factory(*args_, **kwargs_):
        if UKAddress.subclass:
            return UKAddress.subclass(*args_, **kwargs_)
        else:
            return UKAddress(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_postcode(self): return self.postcode
    def set_postcode(self, postcode): self.postcode = postcode
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_category_attr(self): return self.category_attr
    def set_category_attr(self, category_attr): self.category_attr = category_attr
    def get_exportCode(self): return self.exportCode
    def set_exportCode(self, exportCode): self.exportCode = exportCode
    def validate_UKPostcode(self, value):
        # Validate type UKPostcode, a restriction on string.
        pass
    def hasContent_(self):
        if (
            self.postcode is not None or
            self.category is not None or
            super(UKAddress, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ipo:', name_='UKAddress', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UKAddress')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ipo:', name_='UKAddress'):
        super(UKAddress, self).exportAttributes(outfile, level, already_processed, namespace_, name_='UKAddress')
        if self.category_attr is not None and 'category_attr' not in already_processed:
            already_processed.add('category_attr')
            outfile.write(' category=%s' % (quote_attrib(self.category_attr), ))
        if self.exportCode is not None and 'exportCode' not in already_processed:
            already_processed.add('exportCode')
            outfile.write(' exportCode="%s"' % self.gds_format_integer(self.exportCode, input_name='exportCode'))
    def exportChildren(self, outfile, level, namespace_='ipo:', name_='UKAddress', fromsubclass_=False, pretty_print=True):
        super(UKAddress, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.postcode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spostcode>%s</%spostcode>%s' % (namespace_, self.gds_format_string(quote_xml(self.postcode).encode(ExternalEncoding), input_name='postcode'), namespace_, eol_))
        if self.category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scategory>%s</%scategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.category).encode(ExternalEncoding), input_name='category'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='UKAddress'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.category_attr is not None and 'category_attr' not in already_processed:
            already_processed.add('category_attr')
            showIndent(outfile, level)
            outfile.write('category_attr=%s,\n' % (self.category_attr,))
        if self.exportCode is not None and 'exportCode' not in already_processed:
            already_processed.add('exportCode')
            showIndent(outfile, level)
            outfile.write('exportCode=%d,\n' % (self.exportCode,))
        super(UKAddress, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(UKAddress, self).exportLiteralChildren(outfile, level, name_)
        if self.postcode is not None:
            showIndent(outfile, level)
            outfile.write('postcode=%s,\n' % quote_python(self.postcode).encode(ExternalEncoding))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%s,\n' % quote_python(self.category).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('category', node)
        if value is not None and 'category_attr' not in already_processed:
            already_processed.add('category_attr')
            self.category_attr = value
        value = find_attr_value_('exportCode', node)
        if value is not None and 'exportCode' not in already_processed:
            already_processed.add('exportCode')
            try:
                self.exportCode = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.exportCode <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        super(UKAddress, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'postcode':
            postcode_ = child_.text
            postcode_ = self.gds_validate_string(postcode_, node, 'postcode')
            self.postcode = postcode_
            self.validate_UKPostcode(self.postcode)    # validate type UKPostcode
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
        super(UKAddress, self).buildChildren(child_, node, nodeName_, True)
# end class UKAddress


class itemType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('partNum', 'ipo:SKU', 0),
        MemberSpec_('productName', 'string', 0),
        MemberSpec_('quantity', ['quantity', 'positiveInteger'], 0),
        MemberSpec_('USPrice', 'decimal', 0),
        MemberSpec_('comment', 'string', 0),
        MemberSpec_('shipDate', 'date', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, partNum=None, productName=None, quantity=None, USPrice=None, comment=None, shipDate=None):
        self.partNum = _cast(None, partNum)
        self.productName = productName
        self.quantity = quantity
        self.USPrice = USPrice
        self.comment = comment
        if isinstance(shipDate, basestring):
            initvalue_ = datetime_.datetime.strptime(shipDate, '%Y-%m-%d').date()
        else:
            initvalue_ = shipDate
        self.shipDate = initvalue_
    def factory(*args_, **kwargs_):
        if itemType.subclass:
            return itemType.subclass(*args_, **kwargs_)
        else:
            return itemType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_productName(self): return self.productName
    def set_productName(self, productName): self.productName = productName
    def get_quantity(self): return self.quantity
    def set_quantity(self, quantity): self.quantity = quantity
    def get_USPrice(self): return self.USPrice
    def set_USPrice(self, USPrice): self.USPrice = USPrice
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def get_shipDate(self): return self.shipDate
    def set_shipDate(self, shipDate): self.shipDate = shipDate
    def get_partNum(self): return self.partNum
    def set_partNum(self, partNum): self.partNum = partNum
    def hasContent_(self):
        if (
            self.productName is not None or
            self.quantity is not None or
            self.USPrice is not None or
            self.comment is not None or
            self.shipDate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ipo:', name_='itemType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='itemType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ipo:', name_='itemType'):
        if self.partNum is not None and 'partNum' not in already_processed:
            already_processed.add('partNum')
            outfile.write(' partNum=%s' % (quote_attrib(self.partNum), ))
    def exportChildren(self, outfile, level, namespace_='ipo:', name_='itemType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.productName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproductName>%s</%sproductName>%s' % (namespace_, self.gds_format_string(quote_xml(self.productName).encode(ExternalEncoding), input_name='productName'), namespace_, eol_))
        if self.quantity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%squantity>%s</%squantity>%s' % (namespace_, self.gds_format_integer(self.quantity, input_name='quantity'), namespace_, eol_))
        if self.USPrice is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUSPrice>%s</%sUSPrice>%s' % (namespace_, self.gds_format_float(self.USPrice, input_name='USPrice'), namespace_, eol_))
        if self.comment is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomment>%s</%scomment>%s' % (namespace_, self.gds_format_string(quote_xml(self.comment).encode(ExternalEncoding), input_name='comment'), namespace_, eol_))
        if self.shipDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshipDate>%s</%sshipDate>%s' % (namespace_, self.gds_format_date(self.shipDate, input_name='shipDate'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='itemType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.partNum is not None and 'partNum' not in already_processed:
            already_processed.add('partNum')
            showIndent(outfile, level)
            outfile.write('partNum=%s,\n' % (self.partNum,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.productName is not None:
            showIndent(outfile, level)
            outfile.write('productName=%s,\n' % quote_python(self.productName).encode(ExternalEncoding))
        if self.quantity is not None:
            showIndent(outfile, level)
            outfile.write('quantity=%d,\n' % self.quantity)
        if self.USPrice is not None:
            showIndent(outfile, level)
            outfile.write('USPrice=%f,\n' % self.USPrice)
        if self.comment is not None:
            showIndent(outfile, level)
            outfile.write('comment=%s,\n' % quote_python(self.comment).encode(ExternalEncoding))
        if self.shipDate is not None:
            showIndent(outfile, level)
            outfile.write('shipDate=model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(self.shipDate, input_name='shipDate'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('partNum', node)
        if value is not None and 'partNum' not in already_processed:
            already_processed.add('partNum')
            self.partNum = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'productName':
            productName_ = child_.text
            productName_ = self.gds_validate_string(productName_, node, 'productName')
            self.productName = productName_
        elif nodeName_ == 'quantity':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'quantity')
            self.quantity = ival_
        elif nodeName_ == 'USPrice':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'USPrice')
            self.USPrice = fval_
        elif nodeName_ == 'comment':
            comment_ = child_.text
            comment_ = self.gds_validate_string(comment_, node, 'comment')
            self.comment = comment_
        elif nodeName_ == 'shipDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.shipDate = dval_
# end class itemType


class quantity(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if quantity.subclass:
            return quantity.subclass(*args_, **kwargs_)
        else:
            return quantity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ipo:', name_='quantity', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='quantity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ipo:', name_='quantity'):
        pass
    def exportChildren(self, outfile, level, namespace_='ipo:', name_='quantity', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='quantity'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class quantity


GDSClassesMapping = {
    'items': Items,
    'purchaseOrder': PurchaseOrderType,
    'shipTo': Address,
    'billTo': Address,
    'item': itemType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'purchaseOrder'
        rootClass = PurchaseOrderType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(
        sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj


def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'purchaseOrder'
        rootClass = PurchaseOrderType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    content = etree_.tostring(
        rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    roots = get_root_tag(rootNode)
    rootClass = roots[1]
    if rootClass is None:
        rootClass = PurchaseOrderType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(
        sys.stdout, 0, name_="purchaseOrder",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'purchaseOrder'
        rootClass = PurchaseOrderType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from ipo2_sup import *\n\n')
    sys.stdout.write('import ipo2_sup as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "Address",
    "Items",
    "PurchaseOrderType",
    "UKAddress",
    "USAddress",
    "itemType",
    "quantity"
]
