#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated  by generateDS.py.
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class simpleTypeTestsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('simpleTypeTest', 'simpleTypeTest', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, simpleTypeTest=None):
        if simpleTypeTest is None:
            self.simpleTypeTest = []
        else:
            self.simpleTypeTest = simpleTypeTest
    def factory(*args_, **kwargs_):
        if simpleTypeTestsType.subclass:
            return simpleTypeTestsType.subclass(*args_, **kwargs_)
        else:
            return simpleTypeTestsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_simpleTypeTest(self): return self.simpleTypeTest
    def set_simpleTypeTest(self, simpleTypeTest): self.simpleTypeTest = simpleTypeTest
    def add_simpleTypeTest(self, value): self.simpleTypeTest.append(value)
    def insert_simpleTypeTest(self, index, value): self.simpleTypeTest[index] = value
    def hasContent_(self):
        if (
            self.simpleTypeTest
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='simpleTypeTestsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='simpleTypeTestsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='simpleTypeTestsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='simpleTypeTestsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for simpleTypeTest_ in self.simpleTypeTest:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssimpleTypeTest>%s</%ssimpleTypeTest>%s' % (namespace_, self.gds_format_string(quote_xml(simpleTypeTest_).encode(ExternalEncoding), input_name='simpleTypeTest'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='simpleTypeTestsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('simpleTypeTest=[\n')
        level += 1
        for simpleTypeTest_ in self.simpleTypeTest:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(simpleTypeTest_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'simpleTypeTest':
            simpleTypeTest_ = child_.text
            simpleTypeTest_ = self.gds_validate_string(simpleTypeTest_, node, 'simpleTypeTest')
            self.simpleTypeTest.append(simpleTypeTest_)
# end class simpleTypeTestsType


class simpleTypeTest(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('datetime1', 'xs:gYear', 0),
        MemberSpec_('datetime2', 'xs:gYearMonth', 0),
        MemberSpec_('datetime3', 'xs:gMonth', 0),
        MemberSpec_('datetime4', 'xs:gMonthDay', 0),
        MemberSpec_('datetime5', 'xs:gDay', 0),
        MemberSpec_('integerVal1', 'xs:integer', 0),
        MemberSpec_('integerVal2', 'xs:integer', 1),
        MemberSpec_('stringVal1', 'xs:string', 0),
        MemberSpec_('stringVal2', 'xs:string', 1),
        MemberSpec_('booleanVal1', 'xs:boolean', 0),
        MemberSpec_('booleanVal2', 'xs:boolean', 1),
        MemberSpec_('decimalVal1', 'xs:decimal', 0),
        MemberSpec_('decimalVal2', 'xs:decimal', 1),
        MemberSpec_('doubleVal1', 'xs:double', 0),
        MemberSpec_('doubleVal2', 'xs:double', 1),
        MemberSpec_('floatVal1', 'xs:float', 0),
        MemberSpec_('floatVal2', 'xs:float', 1),
        MemberSpec_('dateVal1', 'xs:date', 0),
        MemberSpec_('dateVal2', 'xs:date', 1),
        MemberSpec_('dateTimeVal1', 'xs:dateTime', 0),
        MemberSpec_('dateTimeVal2', 'xs:dateTime', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, datetime1=None, datetime2=None, datetime3=None, datetime4=None, datetime5=None, integerVal1=None, integerVal2=None, stringVal1=None, stringVal2=None, booleanVal1=None, booleanVal2=None, decimalVal1=None, decimalVal2=None, doubleVal1=None, doubleVal2=None, floatVal1=None, floatVal2=None, dateVal1=None, dateVal2=None, dateTimeVal1=None, dateTimeVal2=None):
        self.datetime1 = datetime1
        self.datetime2 = datetime2
        self.datetime3 = datetime3
        self.datetime4 = datetime4
        self.datetime5 = datetime5
        self.integerVal1 = integerVal1
        if integerVal2 is None:
            self.integerVal2 = []
        else:
            self.integerVal2 = integerVal2
        self.stringVal1 = stringVal1
        if stringVal2 is None:
            self.stringVal2 = []
        else:
            self.stringVal2 = stringVal2
        self.booleanVal1 = booleanVal1
        if booleanVal2 is None:
            self.booleanVal2 = []
        else:
            self.booleanVal2 = booleanVal2
        self.decimalVal1 = decimalVal1
        if decimalVal2 is None:
            self.decimalVal2 = []
        else:
            self.decimalVal2 = decimalVal2
        self.doubleVal1 = doubleVal1
        if doubleVal2 is None:
            self.doubleVal2 = []
        else:
            self.doubleVal2 = doubleVal2
        self.floatVal1 = floatVal1
        if floatVal2 is None:
            self.floatVal2 = []
        else:
            self.floatVal2 = floatVal2
        if isinstance(dateVal1, basestring):
            initvalue_ = datetime_.datetime.strptime(dateVal1, '%Y-%m-%d').date()
        else:
            initvalue_ = dateVal1
        self.dateVal1 = initvalue_
        if dateVal2 is None:
            self.dateVal2 = []
        else:
            self.dateVal2 = dateVal2
        if isinstance(dateTimeVal1, basestring):
            initvalue_ = datetime_.datetime.strptime(dateTimeVal1, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = dateTimeVal1
        self.dateTimeVal1 = initvalue_
        if dateTimeVal2 is None:
            self.dateTimeVal2 = []
        else:
            self.dateTimeVal2 = dateTimeVal2
    def factory(*args_, **kwargs_):
        if simpleTypeTest.subclass:
            return simpleTypeTest.subclass(*args_, **kwargs_)
        else:
            return simpleTypeTest(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datetime1(self): return self.datetime1
    def set_datetime1(self, datetime1): self.datetime1 = datetime1
    def get_datetime2(self): return self.datetime2
    def set_datetime2(self, datetime2): self.datetime2 = datetime2
    def get_datetime3(self): return self.datetime3
    def set_datetime3(self, datetime3): self.datetime3 = datetime3
    def get_datetime4(self): return self.datetime4
    def set_datetime4(self, datetime4): self.datetime4 = datetime4
    def get_datetime5(self): return self.datetime5
    def set_datetime5(self, datetime5): self.datetime5 = datetime5
    def get_integerVal1(self): return self.integerVal1
    def set_integerVal1(self, integerVal1): self.integerVal1 = integerVal1
    def get_integerVal2(self): return self.integerVal2
    def set_integerVal2(self, integerVal2): self.integerVal2 = integerVal2
    def add_integerVal2(self, value): self.integerVal2.append(value)
    def insert_integerVal2(self, index, value): self.integerVal2[index] = value
    def get_stringVal1(self): return self.stringVal1
    def set_stringVal1(self, stringVal1): self.stringVal1 = stringVal1
    def get_stringVal2(self): return self.stringVal2
    def set_stringVal2(self, stringVal2): self.stringVal2 = stringVal2
    def add_stringVal2(self, value): self.stringVal2.append(value)
    def insert_stringVal2(self, index, value): self.stringVal2[index] = value
    def get_booleanVal1(self): return self.booleanVal1
    def set_booleanVal1(self, booleanVal1): self.booleanVal1 = booleanVal1
    def get_booleanVal2(self): return self.booleanVal2
    def set_booleanVal2(self, booleanVal2): self.booleanVal2 = booleanVal2
    def add_booleanVal2(self, value): self.booleanVal2.append(value)
    def insert_booleanVal2(self, index, value): self.booleanVal2[index] = value
    def get_decimalVal1(self): return self.decimalVal1
    def set_decimalVal1(self, decimalVal1): self.decimalVal1 = decimalVal1
    def get_decimalVal2(self): return self.decimalVal2
    def set_decimalVal2(self, decimalVal2): self.decimalVal2 = decimalVal2
    def add_decimalVal2(self, value): self.decimalVal2.append(value)
    def insert_decimalVal2(self, index, value): self.decimalVal2[index] = value
    def get_doubleVal1(self): return self.doubleVal1
    def set_doubleVal1(self, doubleVal1): self.doubleVal1 = doubleVal1
    def get_doubleVal2(self): return self.doubleVal2
    def set_doubleVal2(self, doubleVal2): self.doubleVal2 = doubleVal2
    def add_doubleVal2(self, value): self.doubleVal2.append(value)
    def insert_doubleVal2(self, index, value): self.doubleVal2[index] = value
    def get_floatVal1(self): return self.floatVal1
    def set_floatVal1(self, floatVal1): self.floatVal1 = floatVal1
    def get_floatVal2(self): return self.floatVal2
    def set_floatVal2(self, floatVal2): self.floatVal2 = floatVal2
    def add_floatVal2(self, value): self.floatVal2.append(value)
    def insert_floatVal2(self, index, value): self.floatVal2[index] = value
    def get_dateVal1(self): return self.dateVal1
    def set_dateVal1(self, dateVal1): self.dateVal1 = dateVal1
    def get_dateVal2(self): return self.dateVal2
    def set_dateVal2(self, dateVal2): self.dateVal2 = dateVal2
    def add_dateVal2(self, value): self.dateVal2.append(value)
    def insert_dateVal2(self, index, value): self.dateVal2[index] = value
    def get_dateTimeVal1(self): return self.dateTimeVal1
    def set_dateTimeVal1(self, dateTimeVal1): self.dateTimeVal1 = dateTimeVal1
    def get_dateTimeVal2(self): return self.dateTimeVal2
    def set_dateTimeVal2(self, dateTimeVal2): self.dateTimeVal2 = dateTimeVal2
    def add_dateTimeVal2(self, value): self.dateTimeVal2.append(value)
    def insert_dateTimeVal2(self, index, value): self.dateTimeVal2[index] = value
    def hasContent_(self):
        if (
            self.datetime1 is not None or
            self.datetime2 is not None or
            self.datetime3 is not None or
            self.datetime4 is not None or
            self.datetime5 is not None or
            self.integerVal1 is not None or
            self.integerVal2 or
            self.stringVal1 is not None or
            self.stringVal2 or
            self.booleanVal1 is not None or
            self.booleanVal2 or
            self.decimalVal1 is not None or
            self.decimalVal2 or
            self.doubleVal1 is not None or
            self.doubleVal2 or
            self.floatVal1 is not None or
            self.floatVal2 or
            self.dateVal1 is not None or
            self.dateVal2 or
            self.dateTimeVal1 is not None or
            self.dateTimeVal2
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='simpleTypeTest', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='simpleTypeTest')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='simpleTypeTest'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='simpleTypeTest', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.datetime1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatetime1>%s</%sdatetime1>%s' % (namespace_, self.gds_format_string(quote_xml(self.datetime1).encode(ExternalEncoding), input_name='datetime1'), namespace_, eol_))
        if self.datetime2 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatetime2>%s</%sdatetime2>%s' % (namespace_, self.gds_format_string(quote_xml(self.datetime2).encode(ExternalEncoding), input_name='datetime2'), namespace_, eol_))
        if self.datetime3 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatetime3>%s</%sdatetime3>%s' % (namespace_, self.gds_format_string(quote_xml(self.datetime3).encode(ExternalEncoding), input_name='datetime3'), namespace_, eol_))
        if self.datetime4 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatetime4>%s</%sdatetime4>%s' % (namespace_, self.gds_format_string(quote_xml(self.datetime4).encode(ExternalEncoding), input_name='datetime4'), namespace_, eol_))
        if self.datetime5 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatetime5>%s</%sdatetime5>%s' % (namespace_, self.gds_format_string(quote_xml(self.datetime5).encode(ExternalEncoding), input_name='datetime5'), namespace_, eol_))
        if self.integerVal1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sintegerVal1>%s</%sintegerVal1>%s' % (namespace_, self.gds_format_integer(self.integerVal1, input_name='integerVal1'), namespace_, eol_))
        for integerVal2_ in self.integerVal2:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sintegerVal2>%s</%sintegerVal2>%s' % (namespace_, self.gds_format_integer(integerVal2_, input_name='integerVal2'), namespace_, eol_))
        if self.stringVal1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstringVal1>%s</%sstringVal1>%s' % (namespace_, self.gds_format_string(quote_xml(self.stringVal1).encode(ExternalEncoding), input_name='stringVal1'), namespace_, eol_))
        for stringVal2_ in self.stringVal2:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstringVal2>%s</%sstringVal2>%s' % (namespace_, self.gds_format_string(quote_xml(stringVal2_).encode(ExternalEncoding), input_name='stringVal2'), namespace_, eol_))
        if self.booleanVal1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbooleanVal1>%s</%sbooleanVal1>%s' % (namespace_, self.gds_format_boolean(self.booleanVal1, input_name='booleanVal1'), namespace_, eol_))
        for booleanVal2_ in self.booleanVal2:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbooleanVal2>%s</%sbooleanVal2>%s' % (namespace_, self.gds_format_boolean(booleanVal2_, input_name='booleanVal2'), namespace_, eol_))
        if self.decimalVal1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdecimalVal1>%s</%sdecimalVal1>%s' % (namespace_, self.gds_format_float(self.decimalVal1, input_name='decimalVal1'), namespace_, eol_))
        for decimalVal2_ in self.decimalVal2:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdecimalVal2>%s</%sdecimalVal2>%s' % (namespace_, self.gds_format_float(decimalVal2_, input_name='decimalVal2'), namespace_, eol_))
        if self.doubleVal1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdoubleVal1>%s</%sdoubleVal1>%s' % (namespace_, self.gds_format_double(self.doubleVal1, input_name='doubleVal1'), namespace_, eol_))
        for doubleVal2_ in self.doubleVal2:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdoubleVal2>%s</%sdoubleVal2>%s' % (namespace_, self.gds_format_double(doubleVal2_, input_name='doubleVal2'), namespace_, eol_))
        if self.floatVal1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfloatVal1>%s</%sfloatVal1>%s' % (namespace_, self.gds_format_float(self.floatVal1, input_name='floatVal1'), namespace_, eol_))
        for floatVal2_ in self.floatVal2:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfloatVal2>%s</%sfloatVal2>%s' % (namespace_, self.gds_format_float(floatVal2_, input_name='floatVal2'), namespace_, eol_))
        if self.dateVal1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdateVal1>%s</%sdateVal1>%s' % (namespace_, self.gds_format_date(self.dateVal1, input_name='dateVal1'), namespace_, eol_))
        for dateVal2_ in self.dateVal2:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdateVal2>%s</%sdateVal2>%s' % (namespace_, self.gds_format_date(dateVal2_, input_name='dateVal2'), namespace_, eol_))
        if self.dateTimeVal1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdateTimeVal1>%s</%sdateTimeVal1>%s' % (namespace_, self.gds_format_datetime(self.dateTimeVal1, input_name='dateTimeVal1'), namespace_, eol_))
        for dateTimeVal2_ in self.dateTimeVal2:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdateTimeVal2>%s</%sdateTimeVal2>%s' % (namespace_, self.gds_format_datetime(dateTimeVal2_, input_name='dateTimeVal2'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='simpleTypeTest'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.datetime1 is not None:
            showIndent(outfile, level)
            outfile.write('datetime1=%s,\n' % quote_python(self.datetime1).encode(ExternalEncoding))
        if self.datetime2 is not None:
            showIndent(outfile, level)
            outfile.write('datetime2=%s,\n' % quote_python(self.datetime2).encode(ExternalEncoding))
        if self.datetime3 is not None:
            showIndent(outfile, level)
            outfile.write('datetime3=%s,\n' % quote_python(self.datetime3).encode(ExternalEncoding))
        if self.datetime4 is not None:
            showIndent(outfile, level)
            outfile.write('datetime4=%s,\n' % quote_python(self.datetime4).encode(ExternalEncoding))
        if self.datetime5 is not None:
            showIndent(outfile, level)
            outfile.write('datetime5=%s,\n' % quote_python(self.datetime5).encode(ExternalEncoding))
        if self.integerVal1 is not None:
            showIndent(outfile, level)
            outfile.write('integerVal1=%d,\n' % self.integerVal1)
        showIndent(outfile, level)
        outfile.write('integerVal2=[\n')
        level += 1
        for integerVal2_ in self.integerVal2:
            showIndent(outfile, level)
            outfile.write('%d,\n' % integerVal2_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.stringVal1 is not None:
            showIndent(outfile, level)
            outfile.write('stringVal1=%s,\n' % quote_python(self.stringVal1).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('stringVal2=[\n')
        level += 1
        for stringVal2_ in self.stringVal2:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(stringVal2_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.booleanVal1 is not None:
            showIndent(outfile, level)
            outfile.write('booleanVal1=%s,\n' % self.booleanVal1)
        showIndent(outfile, level)
        outfile.write('booleanVal2=[\n')
        level += 1
        for booleanVal2_ in self.booleanVal2:
            showIndent(outfile, level)
            outfile.write('%s,\n' % booleanVal2_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.decimalVal1 is not None:
            showIndent(outfile, level)
            outfile.write('decimalVal1=%f,\n' % self.decimalVal1)
        showIndent(outfile, level)
        outfile.write('decimalVal2=[\n')
        level += 1
        for decimalVal2_ in self.decimalVal2:
            showIndent(outfile, level)
            outfile.write('%f,\n' % decimalVal2_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.doubleVal1 is not None:
            showIndent(outfile, level)
            outfile.write('doubleVal1=%e,\n' % self.doubleVal1)
        showIndent(outfile, level)
        outfile.write('doubleVal2=[\n')
        level += 1
        for doubleVal2_ in self.doubleVal2:
            showIndent(outfile, level)
            outfile.write('%e,\n' % doubleVal2_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.floatVal1 is not None:
            showIndent(outfile, level)
            outfile.write('floatVal1=%f,\n' % self.floatVal1)
        showIndent(outfile, level)
        outfile.write('floatVal2=[\n')
        level += 1
        for floatVal2_ in self.floatVal2:
            showIndent(outfile, level)
            outfile.write('%f,\n' % floatVal2_)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.dateVal1 is not None:
            showIndent(outfile, level)
            outfile.write('dateVal1=model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(self.dateVal1, input_name='dateVal1'))
        showIndent(outfile, level)
        outfile.write('dateVal2=[\n')
        level += 1
        for dateVal2_ in self.dateVal2:
            showIndent(outfile, level)
            outfile.write('model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(dateVal2_, input_name='dateVal2'))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.dateTimeVal1 is not None:
            showIndent(outfile, level)
            outfile.write('dateTimeVal1=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.dateTimeVal1, input_name='dateTimeVal1'))
        showIndent(outfile, level)
        outfile.write('dateTimeVal2=[\n')
        level += 1
        for dateTimeVal2_ in self.dateTimeVal2:
            showIndent(outfile, level)
            outfile.write('model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(dateTimeVal2_, input_name='dateTimeVal2'))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'datetime1':
            datetime1_ = child_.text
            datetime1_ = self.gds_validate_string(datetime1_, node, 'datetime1')
            self.datetime1 = datetime1_
        elif nodeName_ == 'datetime2':
            datetime2_ = child_.text
            datetime2_ = self.gds_validate_string(datetime2_, node, 'datetime2')
            self.datetime2 = datetime2_
        elif nodeName_ == 'datetime3':
            datetime3_ = child_.text
            datetime3_ = self.gds_validate_string(datetime3_, node, 'datetime3')
            self.datetime3 = datetime3_
        elif nodeName_ == 'datetime4':
            datetime4_ = child_.text
            datetime4_ = self.gds_validate_string(datetime4_, node, 'datetime4')
            self.datetime4 = datetime4_
        elif nodeName_ == 'datetime5':
            datetime5_ = child_.text
            datetime5_ = self.gds_validate_string(datetime5_, node, 'datetime5')
            self.datetime5 = datetime5_
        elif nodeName_ == 'integerVal1':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'integerVal1')
            self.integerVal1 = ival_
        elif nodeName_ == 'integerVal2':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'integerVal2')
            self.integerVal2.append(ival_)
        elif nodeName_ == 'stringVal1':
            stringVal1_ = child_.text
            stringVal1_ = self.gds_validate_string(stringVal1_, node, 'stringVal1')
            self.stringVal1 = stringVal1_
        elif nodeName_ == 'stringVal2':
            stringVal2_ = child_.text
            stringVal2_ = self.gds_validate_string(stringVal2_, node, 'stringVal2')
            self.stringVal2.append(stringVal2_)
        elif nodeName_ == 'booleanVal1':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'booleanVal1')
            self.booleanVal1 = ival_
        elif nodeName_ == 'booleanVal2':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'booleanVal2')
            self.booleanVal2.append(ival_)
        elif nodeName_ == 'decimalVal1':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'decimalVal1')
            self.decimalVal1 = fval_
        elif nodeName_ == 'decimalVal2':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'decimalVal2')
            self.decimalVal2.append(fval_)
        elif nodeName_ == 'doubleVal1':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'doubleVal1')
            self.doubleVal1 = fval_
        elif nodeName_ == 'doubleVal2':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'doubleVal2')
            self.doubleVal2.append(fval_)
        elif nodeName_ == 'floatVal1':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'floatVal1')
            self.floatVal1 = fval_
        elif nodeName_ == 'floatVal2':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'floatVal2')
            self.floatVal2.append(fval_)
        elif nodeName_ == 'dateVal1':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.dateVal1 = dval_
        elif nodeName_ == 'dateVal2':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.dateVal2.append(dval_)
        elif nodeName_ == 'dateTimeVal1':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.dateTimeVal1 = dval_
        elif nodeName_ == 'dateTimeVal2':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.dateTimeVal2.append(dval_)
# end class simpleTypeTest


GDSClassesMapping = {
    'simpleTypeTests': simpleTypeTestsType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'simpleTypeTests'
        rootClass = simpleTypeTestsType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='',
##             pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'simpleTypeTests'
        rootClass = simpleTypeTestsType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
##     if not silence:
##         content = etree_.tostring(
##             rootElement, pretty_print=True,
##             xml_declaration=True, encoding="utf-8")
##         sys.stdout.write(content)
##         sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    roots = get_root_tag(rootNode)
    rootClass = roots[1]
    if rootClass is None:
        rootClass = simpleTypeTestsType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_="simpleTypeTests",
##             namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'simpleTypeTests'
        rootClass = simpleTypeTestsType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('#from simpletypes_other2_sup import *\n\n')
##         sys.stdout.write('import simpletypes_other2_sup as model_\n\n')
##         sys.stdout.write('rootObj = model_.rootTag(\n')
##         rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##         sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "simpleTypeTest",
    "simpleTypeTestsType"
]
