#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated  by generateDS.py.
#
# Command line options:
#   ('--no-dates', '')
#   ('--no-versions', '')
#   ('--silence', '')
#   ('--member-specs', 'list')
#   ('-f', '')
#   ('-o', 'tests/to_etree2_sup.py')
#   ('-s', 'tests/to_etree2_sub.py')
#   ('--export', 'etree')
#   ('--silence', '')
#   ('--super', 'to_etree2_sup')
#
# Command line arguments:
#   tests/to_etree.xsd
#
# Command line:
#   generateDS.py --no-dates --no-versions --silence --member-specs="list" -f -o "tests/to_etree2_sup.py" -s "tests/to_etree2_sub.py" --export="etree" --silence --super="to_etree2_sup" tests/to_etree.xsd
#
# Current working directory (os.getcwd()):
#   generateds
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_


Validate_simpletypes_ = True


etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class peopleType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('comments', 'commentsType', 1),
        MemberSpec_('person', 'personType', 1),
        MemberSpec_('specialperson', 'specialperson', 1),
        MemberSpec_('programmer', 'programmerType', 1),
        MemberSpec_('python_programmer', 'python-programmerType', 1),
        MemberSpec_('java_programmer', 'java-programmerType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, comments=None, person=None, specialperson=None, programmer=None, python_programmer=None, java_programmer=None):
        self.original_tagname_ = None
        if comments is None:
            self.comments = []
        else:
            self.comments = comments
        if person is None:
            self.person = []
        else:
            self.person = person
        if specialperson is None:
            self.specialperson = []
        else:
            self.specialperson = specialperson
        if programmer is None:
            self.programmer = []
        else:
            self.programmer = programmer
        if python_programmer is None:
            self.python_programmer = []
        else:
            self.python_programmer = python_programmer
        if java_programmer is None:
            self.java_programmer = []
        else:
            self.java_programmer = java_programmer
    def factory(*args_, **kwargs_):
        if peopleType.subclass:
            return peopleType.subclass(*args_, **kwargs_)
        else:
            return peopleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_comments(self): return self.comments
    def set_comments(self, comments): self.comments = comments
    def add_comments(self, value): self.comments.append(value)
    def insert_comments_at(self, index, value): self.comments.insert(index, value)
    def replace_comments_at(self, index, value): self.comments[index] = value
    def get_person(self): return self.person
    def set_person(self, person): self.person = person
    def add_person(self, value): self.person.append(value)
    def insert_person_at(self, index, value): self.person.insert(index, value)
    def replace_person_at(self, index, value): self.person[index] = value
    def get_specialperson(self): return self.specialperson
    def set_specialperson(self, specialperson): self.specialperson = specialperson
    def add_specialperson(self, value): self.specialperson.append(value)
    def insert_specialperson_at(self, index, value): self.specialperson.insert(index, value)
    def replace_specialperson_at(self, index, value): self.specialperson[index] = value
    def get_programmer(self): return self.programmer
    def set_programmer(self, programmer): self.programmer = programmer
    def add_programmer(self, value): self.programmer.append(value)
    def insert_programmer_at(self, index, value): self.programmer.insert(index, value)
    def replace_programmer_at(self, index, value): self.programmer[index] = value
    def get_python_programmer(self): return self.python_programmer
    def set_python_programmer(self, python_programmer): self.python_programmer = python_programmer
    def add_python_programmer(self, value): self.python_programmer.append(value)
    def insert_python_programmer_at(self, index, value): self.python_programmer.insert(index, value)
    def replace_python_programmer_at(self, index, value): self.python_programmer[index] = value
    def get_java_programmer(self): return self.java_programmer
    def set_java_programmer(self, java_programmer): self.java_programmer = java_programmer
    def add_java_programmer(self, value): self.java_programmer.append(value)
    def insert_java_programmer_at(self, index, value): self.java_programmer.insert(index, value)
    def replace_java_programmer_at(self, index, value): self.java_programmer[index] = value
    def hasContent_(self):
        if (
            self.comments or
            self.person or
            self.specialperson or
            self.programmer or
            self.python_programmer or
            self.java_programmer
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='peopleType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        for comments_ in self.comments:
            comments_.to_etree(element, name_='comments', mapping_=mapping_)
        for person_ in self.person:
            person_.to_etree(element, name_='person', mapping_=mapping_)
        for specialperson_ in self.specialperson:
            specialperson_.to_etree(element, name_='specialperson', mapping_=mapping_)
        for programmer_ in self.programmer:
            programmer_.to_etree(element, name_='programmer', mapping_=mapping_)
        for python_programmer_ in self.python_programmer:
            python_programmer_.to_etree(element, name_='python-programmer', mapping_=mapping_)
        for java_programmer_ in self.java_programmer:
            java_programmer_.to_etree(element, name_='java-programmer', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'comments':
            obj_ = commentsType.factory()
            obj_.build(child_)
            self.comments.append(obj_)
            obj_.original_tagname_ = 'comments'
        elif nodeName_ == 'person':
            class_obj_ = self.get_class_obj_(child_, personType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.person.append(obj_)
            obj_.original_tagname_ = 'person'
        elif nodeName_ == 'specialperson':
            obj_ = specialperson.factory()
            obj_.build(child_)
            self.specialperson.append(obj_)
            obj_.original_tagname_ = 'specialperson'
        elif nodeName_ == 'programmer':
            class_obj_ = self.get_class_obj_(child_, programmerType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.programmer.append(obj_)
            obj_.original_tagname_ = 'programmer'
        elif nodeName_ == 'python-programmer':
            obj_ = python_programmerType.factory()
            obj_.build(child_)
            self.python_programmer.append(obj_)
            obj_.original_tagname_ = 'python-programmer'
        elif nodeName_ == 'java-programmer':
            obj_ = java_programmerType.factory()
            obj_.build(child_)
            self.java_programmer.append(obj_)
            obj_.original_tagname_ = 'java-programmer'
# end class peopleType


class commentsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('emp', 'xs:string', 1),
        MemberSpec_('bold', 'xs:string', 1),
        MemberSpec_('valueOf_', [], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, emp=None, bold=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        if emp is None:
            self.emp = []
        else:
            self.emp = emp
        if bold is None:
            self.bold = []
        else:
            self.bold = bold
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if commentsType.subclass:
            return commentsType.subclass(*args_, **kwargs_)
        else:
            return commentsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_emp(self): return self.emp
    def set_emp(self, emp): self.emp = emp
    def add_emp(self, value): self.emp.append(value)
    def insert_emp_at(self, index, value): self.emp.insert(index, value)
    def replace_emp_at(self, index, value): self.emp[index] = value
    def get_bold(self): return self.bold
    def set_bold(self, bold): self.bold = bold
    def add_bold(self, value): self.bold.append(value)
    def insert_bold_at(self, index, value): self.bold.insert(index, value)
    def replace_bold_at(self, index, value): self.bold[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.emp or
            self.bold or
            self.valueOf_
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='commentsType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        for item_ in self.content_:
            item_.to_etree(element)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'emp' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'emp', valuestr_)
            self.content_.append(obj_)
        elif nodeName_ == 'bold' and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'bold', valuestr_)
            self.content_.append(obj_)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class commentsType


class personType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('vegetable', 'xs:string', 0),
        MemberSpec_('fruit', 'xs:string', 0),
        MemberSpec_('ratio', 'xs:float', 0),
        MemberSpec_('id', 'xs:integer', 0),
        MemberSpec_('value', 'xs:string', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('interest', 'xs:string', 1),
        MemberSpec_('category', 'xs:integer', 0),
        MemberSpec_('hot_agent', 'hot.agent', 0),
        MemberSpec_('agent', 'agentType', 1),
        MemberSpec_('promoter', 'boosterType', 1),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('range_', ['RangeType', 'xs:integer'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.vegetable = _cast(None, vegetable)
        self.fruit = _cast(None, fruit)
        self.ratio = _cast(float, ratio)
        self.id = _cast(int, id)
        self.value = _cast(None, value)
        self.name = name
        if interest is None:
            self.interest = []
        else:
            self.interest = interest
        self.category = category
        self.hot_agent = hot_agent
        if agent is None:
            self.agent = []
        else:
            self.agent = agent
        if promoter is None:
            self.promoter = []
        else:
            self.promoter = promoter
        self.description = description
        self.range_ = range_
        self.validate_RangeType(self.range_)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if personType.subclass:
            return personType.subclass(*args_, **kwargs_)
        else:
            return personType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_interest(self): return self.interest
    def set_interest(self, interest): self.interest = interest
    def add_interest(self, value): self.interest.append(value)
    def insert_interest_at(self, index, value): self.interest.insert(index, value)
    def replace_interest_at(self, index, value): self.interest[index] = value
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_hot_agent(self): return self.hot_agent
    def set_hot_agent(self, hot_agent): self.hot_agent = hot_agent
    def get_agent(self): return self.agent
    def set_agent(self, agent): self.agent = agent
    def add_agent(self, value): self.agent.append(value)
    def insert_agent_at(self, index, value): self.agent.insert(index, value)
    def replace_agent_at(self, index, value): self.agent[index] = value
    def get_promoter(self): return self.promoter
    def set_promoter(self, promoter): self.promoter = promoter
    def add_promoter(self, value): self.promoter.append(value)
    def insert_promoter_at(self, index, value): self.promoter.insert(index, value)
    def replace_promoter_at(self, index, value): self.promoter[index] = value
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_range(self): return self.range_
    def set_range(self, range_): self.range_ = range_
    def get_vegetable(self): return self.vegetable
    def set_vegetable(self, vegetable): self.vegetable = vegetable
    def get_fruit(self): return self.fruit
    def set_fruit(self, fruit): self.fruit = fruit
    def get_ratio(self): return self.ratio
    def set_ratio(self, ratio): self.ratio = ratio
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_RangeType(self, value):
        # Validate type RangeType, a restriction on xs:integer.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.interest or
            self.category is not None or
            self.hot_agent is not None or
            self.agent or
            self.promoter or
            self.description is not None or
            self.range_ is not None
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='personType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.extensiontype_ is not None:
            element.set('{http://www.w3.org/2001/XMLSchema-instance}type', self.extensiontype_)
        if self.vegetable is not None:
            element.set('vegetable', self.gds_format_string(self.vegetable))
        if self.fruit is not None:
            element.set('fruit', self.gds_format_string(self.fruit))
        if self.ratio is not None:
            element.set('ratio', self.gds_format_float(self.ratio))
        if self.id is not None:
            element.set('id', self.gds_format_integer(self.id))
        if self.value is not None:
            element.set('value', self.gds_format_string(self.value))
        if self.name is not None:
            name_ = self.name
            etree_.SubElement(element, '{}name').text = self.gds_format_string(name_)
        for interest_ in self.interest:
            etree_.SubElement(element, '{}interest').text = self.gds_format_string(interest_)
        if self.category is not None:
            category_ = self.category
            etree_.SubElement(element, '{}category').text = self.gds_format_integer(category_)
        if self.hot_agent is not None:
            hot_agent_ = self.hot_agent
            hot_agent_.to_etree(element, name_='hot.agent', mapping_=mapping_)
        for agent_ in self.agent:
            agent_.to_etree(element, name_='agent', mapping_=mapping_)
        for promoter_ in self.promoter:
            promoter_.to_etree(element, name_='promoter', mapping_=mapping_)
        if self.description is not None:
            description_ = self.description
            etree_.SubElement(element, '{}description').text = self.gds_format_string(description_)
        if self.range_ is not None:
            range__ = self.range_
            etree_.SubElement(element, '{}range').text = self.gds_format_integer(range__)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vegetable', node)
        if value is not None and 'vegetable' not in already_processed:
            already_processed.add('vegetable')
            self.vegetable = value
        value = find_attr_value_('fruit', node)
        if value is not None and 'fruit' not in already_processed:
            already_processed.add('fruit')
            self.fruit = value
        value = find_attr_value_('ratio', node)
        if value is not None and 'ratio' not in already_processed:
            already_processed.add('ratio')
            try:
                self.ratio = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (ratio): %s' % exp)
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'interest':
            interest_ = child_.text
            interest_ = self.gds_validate_string(interest_, node, 'interest')
            self.interest.append(interest_)
        elif nodeName_ == 'category':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'category')
            self.category = ival_
        elif nodeName_ == 'hot.agent':
            obj_ = hot_agent.factory()
            obj_.build(child_)
            self.hot_agent = obj_
            obj_.original_tagname_ = 'hot.agent'
        elif nodeName_ == 'agent':
            class_obj_ = self.get_class_obj_(child_, agentType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.agent.append(obj_)
            obj_.original_tagname_ = 'agent'
        elif nodeName_ == 'promoter':
            obj_ = boosterType.factory()
            obj_.build(child_)
            self.promoter.append(obj_)
            obj_.original_tagname_ = 'promoter'
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'range':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'range')
            self.range_ = ival_
            self.validate_RangeType(self.range_)    # validate type RangeType
# end class personType


class specialperson(personType):
    member_data_items_ = [
    ]
    subclass = None
    superclass = personType
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None):
        self.original_tagname_ = None
        super(specialperson, self).__init__(vegetable, fruit, ratio, id, value, name, interest, category, hot_agent, agent, promoter, description, range_, )
    def factory(*args_, **kwargs_):
        if specialperson.subclass:
            return specialperson.subclass(*args_, **kwargs_)
        else:
            return specialperson(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(specialperson, self).hasContent_()
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='specialperson', mapping_=None):
        element = super(specialperson, self).to_etree(parent_element, name_, mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(specialperson, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(specialperson, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class specialperson


class programmerType(personType):
    member_data_items_ = [
        MemberSpec_('language', 'xs:string', 0),
        MemberSpec_('area', 'xs:string', 0),
        MemberSpec_('attrnegint', 'xs:negativeInteger', 0),
        MemberSpec_('attrposint', 'xs:positiveInteger', 0),
        MemberSpec_('attrnonnegint', 'xs:nonNegativeInteger', 0),
        MemberSpec_('attrnonposint', 'xs:nonPositiveInteger', 0),
        MemberSpec_('email', 'xs:string', 0),
        MemberSpec_('elposint', 'xs:positiveInteger', 0),
        MemberSpec_('elnonposint', 'xs:nonPositiveInteger', 0),
        MemberSpec_('elnegint', 'xs:negativeInteger', 0),
        MemberSpec_('elnonnegint', 'xs:nonNegativeInteger', 0),
        MemberSpec_('eldate', 'xs:date', 0),
        MemberSpec_('eldatetime', 'xs:dateTime', 0),
        MemberSpec_('eldatetime1', 'xs:dateTime', 0),
        MemberSpec_('eltoken', 'xs:token', 0),
        MemberSpec_('elshort', 'xs:short', 0),
        MemberSpec_('ellong', 'xs:long', 0),
        MemberSpec_('elparam', 'paramType', 0),
        MemberSpec_('elarraytypes', ['ArrayTypes', 'xs:NMTOKEN'], 0),
    ]
    subclass = None
    superclass = personType
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, language=None, area=None, attrnegint=None, attrposint=None, attrnonnegint=None, attrnonposint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eldatetime=None, eldatetime1=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None, extensiontype_=None):
        self.original_tagname_ = None
        super(programmerType, self).__init__(vegetable, fruit, ratio, id, value, name, interest, category, hot_agent, agent, promoter, description, range_, extensiontype_, )
        self.language = _cast(None, language)
        self.area = _cast(None, area)
        self.attrnegint = _cast(int, attrnegint)
        self.attrposint = _cast(int, attrposint)
        self.attrnonnegint = _cast(int, attrnonnegint)
        self.attrnonposint = _cast(int, attrnonposint)
        self.email = email
        self.elposint = elposint
        self.elnonposint = elnonposint
        self.elnegint = elnegint
        self.elnonnegint = elnonnegint
        if isinstance(eldate, basestring):
            initvalue_ = datetime_.datetime.strptime(eldate, '%Y-%m-%d').date()
        else:
            initvalue_ = eldate
        self.eldate = initvalue_
        if isinstance(eldatetime, basestring):
            initvalue_ = datetime_.datetime.strptime(eldatetime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = eldatetime
        self.eldatetime = initvalue_
        if isinstance(eldatetime1, basestring):
            initvalue_ = datetime_.datetime.strptime(eldatetime1, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = eldatetime1
        self.eldatetime1 = initvalue_
        self.eltoken = eltoken
        self.elshort = elshort
        self.ellong = ellong
        self.elparam = elparam
        self.elarraytypes = elarraytypes
        self.validate_ArrayTypes(self.elarraytypes)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if programmerType.subclass:
            return programmerType.subclass(*args_, **kwargs_)
        else:
            return programmerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_elposint(self): return self.elposint
    def set_elposint(self, elposint): self.elposint = elposint
    def get_elnonposint(self): return self.elnonposint
    def set_elnonposint(self, elnonposint): self.elnonposint = elnonposint
    def get_elnegint(self): return self.elnegint
    def set_elnegint(self, elnegint): self.elnegint = elnegint
    def get_elnonnegint(self): return self.elnonnegint
    def set_elnonnegint(self, elnonnegint): self.elnonnegint = elnonnegint
    def get_eldate(self): return self.eldate
    def set_eldate(self, eldate): self.eldate = eldate
    def get_eldatetime(self): return self.eldatetime
    def set_eldatetime(self, eldatetime): self.eldatetime = eldatetime
    def get_eldatetime1(self): return self.eldatetime1
    def set_eldatetime1(self, eldatetime1): self.eldatetime1 = eldatetime1
    def get_eltoken(self): return self.eltoken
    def set_eltoken(self, eltoken): self.eltoken = eltoken
    def get_elshort(self): return self.elshort
    def set_elshort(self, elshort): self.elshort = elshort
    def get_ellong(self): return self.ellong
    def set_ellong(self, ellong): self.ellong = ellong
    def get_elparam(self): return self.elparam
    def set_elparam(self, elparam): self.elparam = elparam
    def get_elarraytypes(self): return self.elarraytypes
    def set_elarraytypes(self, elarraytypes): self.elarraytypes = elarraytypes
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_area(self): return self.area
    def set_area(self, area): self.area = area
    def get_attrnegint(self): return self.attrnegint
    def set_attrnegint(self, attrnegint): self.attrnegint = attrnegint
    def get_attrposint(self): return self.attrposint
    def set_attrposint(self, attrposint): self.attrposint = attrposint
    def get_attrnonnegint(self): return self.attrnonnegint
    def set_attrnonnegint(self, attrnonnegint): self.attrnonnegint = attrnonnegint
    def get_attrnonposint(self): return self.attrnonposint
    def set_attrnonposint(self, attrnonposint): self.attrnonposint = attrnonposint
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_ArrayTypes(self, value):
        # Validate type ArrayTypes, a restriction on xs:NMTOKEN.
        if value is not None and Validate_simpletypes_:
            enumerations = ['float', 'int', 'Name', 'token']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on ArrayTypes' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.email is not None or
            self.elposint is not None or
            self.elnonposint is not None or
            self.elnegint is not None or
            self.elnonnegint is not None or
            self.eldate is not None or
            self.eldatetime is not None or
            self.eldatetime1 is not None or
            self.eltoken is not None or
            self.elshort is not None or
            self.ellong is not None or
            self.elparam is not None or
            self.elarraytypes is not None or
            super(programmerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='programmerType', mapping_=None):
        element = super(programmerType, self).to_etree(parent_element, name_, mapping_)
        if self.extensiontype_ is not None:
            element.set('{http://www.w3.org/2001/XMLSchema-instance}type', self.extensiontype_)
        if self.language is not None:
            element.set('language', self.gds_format_string(self.language))
        if self.area is not None:
            element.set('area', self.gds_format_string(self.area))
        if self.attrnegint is not None:
            element.set('attrnegint', self.gds_format_integer(self.attrnegint))
        if self.attrposint is not None:
            element.set('attrposint', self.gds_format_integer(self.attrposint))
        if self.attrnonnegint is not None:
            element.set('attrnonnegint', self.gds_format_integer(self.attrnonnegint))
        if self.attrnonposint is not None:
            element.set('attrnonposint', self.gds_format_integer(self.attrnonposint))
        if self.email is not None:
            email_ = self.email
            etree_.SubElement(element, '{}email').text = self.gds_format_string(email_)
        if self.elposint is not None:
            elposint_ = self.elposint
            etree_.SubElement(element, '{}elposint').text = self.gds_format_integer(elposint_)
        if self.elnonposint is not None:
            elnonposint_ = self.elnonposint
            etree_.SubElement(element, '{}elnonposint').text = self.gds_format_integer(elnonposint_)
        if self.elnegint is not None:
            elnegint_ = self.elnegint
            etree_.SubElement(element, '{}elnegint').text = self.gds_format_integer(elnegint_)
        if self.elnonnegint is not None:
            elnonnegint_ = self.elnonnegint
            etree_.SubElement(element, '{}elnonnegint').text = self.gds_format_integer(elnonnegint_)
        if self.eldate is not None:
            eldate_ = self.eldate
            etree_.SubElement(element, '{}eldate').text = self.gds_format_date(eldate_)
        if self.eldatetime is not None:
            eldatetime_ = self.eldatetime
            etree_.SubElement(element, '{}eldatetime').text = self.gds_format_datetime(eldatetime_)
        if self.eldatetime1 is not None:
            eldatetime1_ = self.eldatetime1
            etree_.SubElement(element, '{}eldatetime1').text = self.gds_format_datetime(eldatetime1_)
        if self.eltoken is not None:
            eltoken_ = self.eltoken
            etree_.SubElement(element, '{}eltoken').text = self.gds_format_string(eltoken_)
        if self.elshort is not None:
            elshort_ = self.elshort
            etree_.SubElement(element, '{}elshort').text = self.gds_format_integer(elshort_)
        if self.ellong is not None:
            ellong_ = self.ellong
            etree_.SubElement(element, '{}ellong').text = self.gds_format_integer(ellong_)
        if self.elparam is not None:
            elparam_ = self.elparam
            elparam_.to_etree(element, name_='elparam', mapping_=mapping_)
        if self.elarraytypes is not None:
            elarraytypes_ = self.elarraytypes
            etree_.SubElement(element, '{}elarraytypes').text = self.gds_format_string(elarraytypes_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('language', node)
        if value is not None and 'language' not in already_processed:
            already_processed.add('language')
            self.language = value
        value = find_attr_value_('area', node)
        if value is not None and 'area' not in already_processed:
            already_processed.add('area')
            self.area = value
        value = find_attr_value_('attrnegint', node)
        if value is not None and 'attrnegint' not in already_processed:
            already_processed.add('attrnegint')
            try:
                self.attrnegint = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnegint >= 0:
                raise_parse_error(node, 'Invalid NegativeInteger')
        value = find_attr_value_('attrposint', node)
        if value is not None and 'attrposint' not in already_processed:
            already_processed.add('attrposint')
            try:
                self.attrposint = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrposint <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('attrnonnegint', node)
        if value is not None and 'attrnonnegint' not in already_processed:
            already_processed.add('attrnonnegint')
            try:
                self.attrnonnegint = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnonnegint < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('attrnonposint', node)
        if value is not None and 'attrnonposint' not in already_processed:
            already_processed.add('attrnonposint')
            try:
                self.attrnonposint = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.attrnonposint > 0:
                raise_parse_error(node, 'Invalid NonPositiveInteger')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(programmerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'elposint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'elposint')
            self.elposint = ival_
        elif nodeName_ == 'elnonposint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ > 0:
                raise_parse_error(child_, 'requires nonPositiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'elnonposint')
            self.elnonposint = ival_
        elif nodeName_ == 'elnegint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ >= 0:
                raise_parse_error(child_, 'requires negativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'elnegint')
            self.elnegint = ival_
        elif nodeName_ == 'elnonnegint':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'elnonnegint')
            self.elnonnegint = ival_
        elif nodeName_ == 'eldate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.eldate = dval_
        elif nodeName_ == 'eldatetime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.eldatetime = dval_
        elif nodeName_ == 'eldatetime1':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.eldatetime1 = dval_
        elif nodeName_ == 'eltoken':
            eltoken_ = child_.text
            eltoken_ = re_.sub(String_cleanup_pat_, " ", eltoken_).strip()
            eltoken_ = self.gds_validate_string(eltoken_, node, 'eltoken')
            self.eltoken = eltoken_
        elif nodeName_ == 'elshort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'elshort')
            self.elshort = ival_
        elif nodeName_ == 'ellong':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ellong')
            self.ellong = ival_
        elif nodeName_ == 'elparam':
            obj_ = paramType.factory()
            obj_.build(child_)
            self.elparam = obj_
            obj_.original_tagname_ = 'elparam'
        elif nodeName_ == 'elarraytypes':
            elarraytypes_ = child_.text
            elarraytypes_ = self.gds_validate_string(elarraytypes_, node, 'elarraytypes')
            self.elarraytypes = elarraytypes_
            self.validate_ArrayTypes(self.elarraytypes)    # validate type ArrayTypes
        super(programmerType, self).buildChildren(child_, node, nodeName_, True)
# end class programmerType


class paramType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('semantic', 'xs:token', 0),
        MemberSpec_('name', 'xs:NCName', 0),
        MemberSpec_('flow', 'FlowType', 0),
        MemberSpec_('sid', 'xs:NCName', 0),
        MemberSpec_('type', 'xs:NMTOKEN', 0),
        MemberSpec_('id', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, semantic=None, name=None, flow=None, sid=None, type_=None, id=None, valueOf_=None):
        self.original_tagname_ = None
        self.semantic = _cast(None, semantic)
        self.name = _cast(None, name)
        self.flow = _cast(None, flow)
        self.sid = _cast(None, sid)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if paramType.subclass:
            return paramType.subclass(*args_, **kwargs_)
        else:
            return paramType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_semantic(self): return self.semantic
    def set_semantic(self, semantic): self.semantic = semantic
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_flow(self): return self.flow
    def set_flow(self, flow): self.flow = flow
    def get_sid(self): return self.sid
    def set_sid(self, sid): self.sid = sid
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_FlowType(self, value):
        # Validate type FlowType, a restriction on xs:integer.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='paramType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.semantic is not None:
            element.set('semantic', self.gds_format_string(self.semantic))
        if self.name is not None:
            element.set('name', self.name)
        if self.flow is not None:
            element.set('flow', self.flow)
        if self.sid is not None:
            element.set('sid', self.sid)
        if self.type_ is not None:
            element.set('type', self.gds_format_string(self.type_))
        if self.id is not None:
            element.set('id', self.gds_format_string(self.id))
        if self.hasContent_():
            element.text = self.gds_format_string(self.get_valueOf_())
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('semantic', node)
        if value is not None and 'semantic' not in already_processed:
            already_processed.add('semantic')
            self.semantic = value
            self.semantic = ' '.join(self.semantic.split())
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('flow', node)
        if value is not None and 'flow' not in already_processed:
            already_processed.add('flow')
            try:
                self.flow = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_FlowType(self.flow)    # validate type FlowType
        value = find_attr_value_('sid', node)
        if value is not None and 'sid' not in already_processed:
            already_processed.add('sid')
            self.sid = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class paramType


class python_programmerType(programmerType):
    member_data_items_ = [
        MemberSpec_('drcs_attr', 'xs:string', 0),
        MemberSpec_('nick-name', 'xs:string', 0),
        MemberSpec_('gui_developer', 'xs:boolean', 0),
        MemberSpec_('favorite_editor', 'xs:string', 0),
        MemberSpec_('flowvalue', ['FlowType', 'xs:integer'], 0),
        MemberSpec_('drcs', 'xs:string', 0),
    ]
    subclass = None
    superclass = programmerType
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, language=None, area=None, attrnegint=None, attrposint=None, attrnonnegint=None, attrnonposint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eldatetime=None, eldatetime1=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None, drcs_attr=None, nick_name=None, gui_developer=None, favorite_editor=None, flowvalue=None, drcs=None):
        self.original_tagname_ = None
        super(python_programmerType, self).__init__(vegetable, fruit, ratio, id, value, name, interest, category, hot_agent, agent, promoter, description, range_, language, area, attrnegint, attrposint, attrnonnegint, attrnonposint, email, elposint, elnonposint, elnegint, elnonnegint, eldate, eldatetime, eldatetime1, eltoken, elshort, ellong, elparam, elarraytypes, )
        self.drcs_attr = _cast(None, drcs_attr)
        self.nick_name = _cast(None, nick_name)
        self.gui_developer = _cast(bool, gui_developer)
        self.favorite_editor = favorite_editor
        self.flowvalue = flowvalue
        self.validate_FlowType(self.flowvalue)
        self.drcs = drcs
    def factory(*args_, **kwargs_):
        if python_programmerType.subclass:
            return python_programmerType.subclass(*args_, **kwargs_)
        else:
            return python_programmerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_favorite_editor(self): return self.favorite_editor
    def set_favorite_editor(self, favorite_editor): self.favorite_editor = favorite_editor
    def get_flowvalue(self): return self.flowvalue
    def set_flowvalue(self, flowvalue): self.flowvalue = flowvalue
    def get_drcs(self): return self.drcs
    def set_drcs(self, drcs): self.drcs = drcs
    def get_drcs_attr(self): return self.drcs_attr
    def set_drcs_attr(self, drcs_attr): self.drcs_attr = drcs_attr
    def get_nick_name(self): return self.nick_name
    def set_nick_name(self, nick_name): self.nick_name = nick_name
    def get_gui_developer(self): return self.gui_developer
    def set_gui_developer(self, gui_developer): self.gui_developer = gui_developer
    def validate_FlowType(self, value):
        # Validate type FlowType, a restriction on xs:integer.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.favorite_editor is not None or
            self.flowvalue is not None or
            self.drcs is not None or
            super(python_programmerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='python-programmerType', mapping_=None):
        element = super(python_programmerType, self).to_etree(parent_element, name_, mapping_)
        if self.drcs_attr is not None:
            element.set('drcs_attr', self.gds_format_string(self.drcs_attr))
        if self.nick_name is not None:
            element.set('nick-name', self.gds_format_string(self.nick_name))
        if self.gui_developer is not None:
            element.set('gui_developer', self.gds_format_boolean(self.gui_developer))
        if self.favorite_editor is not None:
            favorite_editor_ = self.favorite_editor
            etree_.SubElement(element, '{}favorite-editor').text = self.gds_format_string(favorite_editor_)
        if self.flowvalue is not None:
            flowvalue_ = self.flowvalue
            etree_.SubElement(element, '{}flowvalue').text = self.gds_format_integer(flowvalue_)
        if self.drcs is not None:
            drcs_ = self.drcs
            etree_.SubElement(element, '{}drcs').text = self.gds_format_string(drcs_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('drcs', node)
        if value is not None and 'drcs_attr' not in already_processed:
            already_processed.add('drcs_attr')
            self.drcs_attr = value
        value = find_attr_value_('nick-name', node)
        if value is not None and 'nick-name' not in already_processed:
            already_processed.add('nick-name')
            self.nick_name = value
        value = find_attr_value_('gui_developer', node)
        if value is not None and 'gui_developer' not in already_processed:
            already_processed.add('gui_developer')
            if value in ('true', '1'):
                self.gui_developer = True
            elif value in ('false', '0'):
                self.gui_developer = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(python_programmerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'favorite-editor':
            favorite_editor_ = child_.text
            favorite_editor_ = self.gds_validate_string(favorite_editor_, node, 'favorite_editor')
            self.favorite_editor = favorite_editor_
        elif nodeName_ == 'flowvalue':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'flowvalue')
            self.flowvalue = ival_
            self.validate_FlowType(self.flowvalue)    # validate type FlowType
        elif nodeName_ == 'drcs':
            drcs_ = child_.text
            drcs_ = self.gds_validate_string(drcs_, node, 'drcs')
            self.drcs = drcs_
        super(python_programmerType, self).buildChildren(child_, node, nodeName_, True)
# end class python_programmerType


class java_programmerType(programmerType):
    member_data_items_ = [
        MemberSpec_('status', 'xs:string', 0),
        MemberSpec_('nick-name', 'xs:string', 0),
        MemberSpec_('favorite_editor', 'xs:string', 0),
        MemberSpec_('datetime1', 'xs:gYear', 0),
        MemberSpec_('datetime2', 'xs:gYearMonth', 0),
        MemberSpec_('datetime3', 'xs:gMonth', 0),
        MemberSpec_('datetime4', 'xs:gMonthDay', 0),
        MemberSpec_('datetime5', 'xs:gDay', 0),
    ]
    subclass = None
    superclass = programmerType
    def __init__(self, vegetable=None, fruit=None, ratio=None, id=None, value=None, name=None, interest=None, category=None, hot_agent=None, agent=None, promoter=None, description=None, range_=None, language=None, area=None, attrnegint=None, attrposint=None, attrnonnegint=None, attrnonposint=None, email=None, elposint=None, elnonposint=None, elnegint=None, elnonnegint=None, eldate=None, eldatetime=None, eldatetime1=None, eltoken=None, elshort=None, ellong=None, elparam=None, elarraytypes=None, status=None, nick_name=None, favorite_editor=None, datetime1=None, datetime2=None, datetime3=None, datetime4=None, datetime5=None):
        self.original_tagname_ = None
        super(java_programmerType, self).__init__(vegetable, fruit, ratio, id, value, name, interest, category, hot_agent, agent, promoter, description, range_, language, area, attrnegint, attrposint, attrnonnegint, attrnonposint, email, elposint, elnonposint, elnegint, elnonnegint, eldate, eldatetime, eldatetime1, eltoken, elshort, ellong, elparam, elarraytypes, )
        self.status = _cast(None, status)
        self.nick_name = _cast(None, nick_name)
        self.favorite_editor = favorite_editor
        self.datetime1 = datetime1
        self.datetime2 = datetime2
        self.datetime3 = datetime3
        self.datetime4 = datetime4
        self.datetime5 = datetime5
    def factory(*args_, **kwargs_):
        if java_programmerType.subclass:
            return java_programmerType.subclass(*args_, **kwargs_)
        else:
            return java_programmerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_favorite_editor(self): return self.favorite_editor
    def set_favorite_editor(self, favorite_editor): self.favorite_editor = favorite_editor
    def get_datetime1(self): return self.datetime1
    def set_datetime1(self, datetime1): self.datetime1 = datetime1
    def get_datetime2(self): return self.datetime2
    def set_datetime2(self, datetime2): self.datetime2 = datetime2
    def get_datetime3(self): return self.datetime3
    def set_datetime3(self, datetime3): self.datetime3 = datetime3
    def get_datetime4(self): return self.datetime4
    def set_datetime4(self, datetime4): self.datetime4 = datetime4
    def get_datetime5(self): return self.datetime5
    def set_datetime5(self, datetime5): self.datetime5 = datetime5
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_nick_name(self): return self.nick_name
    def set_nick_name(self, nick_name): self.nick_name = nick_name
    def hasContent_(self):
        if (
            self.favorite_editor is not None or
            self.datetime1 is not None or
            self.datetime2 is not None or
            self.datetime3 is not None or
            self.datetime4 is not None or
            self.datetime5 is not None or
            super(java_programmerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='java-programmerType', mapping_=None):
        element = super(java_programmerType, self).to_etree(parent_element, name_, mapping_)
        if self.status is not None:
            element.set('status', self.gds_format_string(self.status))
        if self.nick_name is not None:
            element.set('nick-name', self.gds_format_string(self.nick_name))
        if self.favorite_editor is not None:
            favorite_editor_ = self.favorite_editor
            etree_.SubElement(element, '{}favorite-editor').text = self.gds_format_string(favorite_editor_)
        if self.datetime1 is not None:
            datetime1_ = self.datetime1
            etree_.SubElement(element, '{}datetime1').text = self.gds_format_string(datetime1_)
        if self.datetime2 is not None:
            datetime2_ = self.datetime2
            etree_.SubElement(element, '{}datetime2').text = self.gds_format_string(datetime2_)
        if self.datetime3 is not None:
            datetime3_ = self.datetime3
            etree_.SubElement(element, '{}datetime3').text = self.gds_format_string(datetime3_)
        if self.datetime4 is not None:
            datetime4_ = self.datetime4
            etree_.SubElement(element, '{}datetime4').text = self.gds_format_string(datetime4_)
        if self.datetime5 is not None:
            datetime5_ = self.datetime5
            etree_.SubElement(element, '{}datetime5').text = self.gds_format_string(datetime5_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('nick-name', node)
        if value is not None and 'nick-name' not in already_processed:
            already_processed.add('nick-name')
            self.nick_name = value
        super(java_programmerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'favorite-editor':
            favorite_editor_ = child_.text
            favorite_editor_ = self.gds_validate_string(favorite_editor_, node, 'favorite_editor')
            self.favorite_editor = favorite_editor_
        elif nodeName_ == 'datetime1':
            datetime1_ = child_.text
            datetime1_ = self.gds_validate_string(datetime1_, node, 'datetime1')
            self.datetime1 = datetime1_
        elif nodeName_ == 'datetime2':
            datetime2_ = child_.text
            datetime2_ = self.gds_validate_string(datetime2_, node, 'datetime2')
            self.datetime2 = datetime2_
        elif nodeName_ == 'datetime3':
            datetime3_ = child_.text
            datetime3_ = self.gds_validate_string(datetime3_, node, 'datetime3')
            self.datetime3 = datetime3_
        elif nodeName_ == 'datetime4':
            datetime4_ = child_.text
            datetime4_ = self.gds_validate_string(datetime4_, node, 'datetime4')
            self.datetime4 = datetime4_
        elif nodeName_ == 'datetime5':
            datetime5_ = child_.text
            datetime5_ = self.gds_validate_string(datetime5_, node, 'datetime5')
            self.datetime5 = datetime5_
        super(java_programmerType, self).buildChildren(child_, node, nodeName_, True)
# end class java_programmerType


class agentType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('priority', 'xs:float', 0),
        MemberSpec_('info', 'infoType', 0),
        MemberSpec_('vehicle', 'vehicleType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, firstname=None, lastname=None, priority=None, info=None, vehicle=None, extensiontype_=None):
        self.original_tagname_ = None
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.info = info
        if vehicle is None:
            self.vehicle = []
        else:
            self.vehicle = vehicle
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if agentType.subclass:
            return agentType.subclass(*args_, **kwargs_)
        else:
            return agentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    def get_vehicle(self): return self.vehicle
    def set_vehicle(self, vehicle): self.vehicle = vehicle
    def add_vehicle(self, value): self.vehicle.append(value)
    def insert_vehicle_at(self, index, value): self.vehicle.insert(index, value)
    def replace_vehicle_at(self, index, value): self.vehicle[index] = value
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.info is not None or
            self.vehicle
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='agentType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.extensiontype_ is not None:
            element.set('{http://www.w3.org/2001/XMLSchema-instance}type', self.extensiontype_)
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.priority is not None:
            priority_ = self.priority
            etree_.SubElement(element, '{}priority').text = self.gds_format_float(priority_)
        if self.info is not None:
            info_ = self.info
            info_.to_etree(element, name_='info', mapping_=mapping_)
        for vehicle_ in self.vehicle:
            vehicle_.to_etree(element, name_='vehicle', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'priority')
            self.priority = fval_
        elif nodeName_ == 'info':
            obj_ = infoType.factory()
            obj_.build(child_)
            self.info = obj_
            obj_.original_tagname_ = 'info'
        elif nodeName_ == 'vehicle':
            class_obj_ = self.get_class_obj_(child_, vehicleType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.vehicle.append(obj_)
            obj_.original_tagname_ = 'vehicle'
# end class agentType


class special_agentType(agentType):
    """This is a good kind of agent for testing the generation of Python
    bindings for an XML schema."""
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('priority', 'xs:float', 0),
        MemberSpec_('info', 'infoType', 0),
    ]
    subclass = None
    superclass = agentType
    def __init__(self, firstname=None, lastname=None, priority=None, info=None, vehicle=None):
        self.original_tagname_ = None
        super(special_agentType, self).__init__(firstname, lastname, priority, info, vehicle, )
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.info = info
    def factory(*args_, **kwargs_):
        if special_agentType.subclass:
            return special_agentType.subclass(*args_, **kwargs_)
        else:
            return special_agentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.info is not None or
            super(special_agentType, self).hasContent_()
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='special-agentType', mapping_=None):
        element = super(special_agentType, self).to_etree(parent_element, name_, mapping_)
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.priority is not None:
            priority_ = self.priority
            etree_.SubElement(element, '{}priority').text = self.gds_format_float(priority_)
        if self.info is not None:
            info_ = self.info
            info_.to_etree(element, name_='info', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(special_agentType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'priority')
            self.priority = fval_
        elif nodeName_ == 'info':
            obj_ = infoType.factory()
            obj_.build(child_)
            self.info = obj_
            obj_.original_tagname_ = 'info'
        super(special_agentType, self).buildChildren(child_, node, nodeName_, True)
# end class special_agentType


class weird_agentType(agentType):
    """This is a good kind of agent for testing the generation of Python
    bindings for an XML schema."""
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('priority', 'xs:float', 0),
        MemberSpec_('info', 'infoType', 0),
    ]
    subclass = None
    superclass = agentType
    def __init__(self, firstname=None, lastname=None, priority=None, info=None, vehicle=None):
        self.original_tagname_ = None
        super(weird_agentType, self).__init__(firstname, lastname, priority, info, vehicle, )
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        self.info = info
    def factory(*args_, **kwargs_):
        if weird_agentType.subclass:
            return weird_agentType.subclass(*args_, **kwargs_)
        else:
            return weird_agentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_info(self): return self.info
    def set_info(self, info): self.info = info
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.info is not None or
            super(weird_agentType, self).hasContent_()
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='weird-agentType', mapping_=None):
        element = super(weird_agentType, self).to_etree(parent_element, name_, mapping_)
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.priority is not None:
            priority_ = self.priority
            etree_.SubElement(element, '{}priority').text = self.gds_format_float(priority_)
        if self.info is not None:
            info_ = self.info
            info_.to_etree(element, name_='info', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(weird_agentType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'priority')
            self.priority = fval_
        elif nodeName_ == 'info':
            obj_ = infoType.factory()
            obj_.build(child_)
            self.info = obj_
            obj_.original_tagname_ = 'info'
        super(weird_agentType, self).buildChildren(child_, node, nodeName_, True)
# end class weird_agentType


class boosterType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('member-id', 'xs:string', 0),
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('other_name', 'xs:float', 0),
        MemberSpec_('class_', 'xs:float', 0),
        MemberSpec_('other_value', 'xs:float', 1),
        MemberSpec_('type_', 'xs:float', 1),
        MemberSpec_('client_handler', 'client-handlerType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, member_id=None, firstname=None, lastname=None, other_name=None, class_=None, other_value=None, type_=None, client_handler=None):
        self.original_tagname_ = None
        self.member_id = _cast(None, member_id)
        self.firstname = firstname
        self.lastname = lastname
        self.other_name = other_name
        self.class_ = class_
        if other_value is None:
            self.other_value = []
        else:
            self.other_value = other_value
        if type_ is None:
            self.type_ = []
        else:
            self.type_ = type_
        if client_handler is None:
            self.client_handler = []
        else:
            self.client_handler = client_handler
    def factory(*args_, **kwargs_):
        if boosterType.subclass:
            return boosterType.subclass(*args_, **kwargs_)
        else:
            return boosterType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_other_name(self): return self.other_name
    def set_other_name(self, other_name): self.other_name = other_name
    def get_class(self): return self.class_
    def set_class(self, class_): self.class_ = class_
    def get_other_value(self): return self.other_value
    def set_other_value(self, other_value): self.other_value = other_value
    def add_other_value(self, value): self.other_value.append(value)
    def insert_other_value_at(self, index, value): self.other_value.insert(index, value)
    def replace_other_value_at(self, index, value): self.other_value[index] = value
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def add_type(self, value): self.type_.append(value)
    def insert_type_at(self, index, value): self.type_.insert(index, value)
    def replace_type_at(self, index, value): self.type_[index] = value
    def get_client_handler(self): return self.client_handler
    def set_client_handler(self, client_handler): self.client_handler = client_handler
    def add_client_handler(self, value): self.client_handler.append(value)
    def insert_client_handler_at(self, index, value): self.client_handler.insert(index, value)
    def replace_client_handler_at(self, index, value): self.client_handler[index] = value
    def get_member_id(self): return self.member_id
    def set_member_id(self, member_id): self.member_id = member_id
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.other_name is not None or
            self.class_ is not None or
            self.other_value or
            self.type_ or
            self.client_handler
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='boosterType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.member_id is not None:
            element.set('member-id', self.gds_format_string(self.member_id))
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.other_name is not None:
            other_name_ = self.other_name
            etree_.SubElement(element, '{}other-name').text = self.gds_format_float(other_name_)
        if self.class_ is not None:
            class__ = self.class_
            etree_.SubElement(element, '{}class').text = self.gds_format_float(class__)
        for other_value_ in self.other_value:
            etree_.SubElement(element, '{}other-value').text = self.gds_format_float(other_value_)
        for type__ in self.type_:
            etree_.SubElement(element, '{}type').text = self.gds_format_float(type__)
        for client_handler_ in self.client_handler:
            client_handler_.to_etree(element, name_='client-handler', mapping_=mapping_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('member-id', node)
        if value is not None and 'member-id' not in already_processed:
            already_processed.add('member-id')
            self.member_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'other-name':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'other_name')
            self.other_name = fval_
        elif nodeName_ == 'class':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'class')
            self.class_ = fval_
        elif nodeName_ == 'other-value':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'other_value')
            self.other_value.append(fval_)
        elif nodeName_ == 'type':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'type')
            self.type_.append(fval_)
        elif nodeName_ == 'client-handler':
            obj_ = client_handlerType.factory()
            obj_.build(child_)
            self.client_handler.append(obj_)
            obj_.original_tagname_ = 'client-handler'
# end class boosterType


class infoType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('rating', 'xs:float', 0),
        MemberSpec_('type', 'xs:integer', 0),
        MemberSpec_('name', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, rating=None, type_=None, name=None):
        self.original_tagname_ = None
        self.rating = _cast(float, rating)
        self.type_ = _cast(int, type_)
        self.name = _cast(None, name)
    def factory(*args_, **kwargs_):
        if infoType.subclass:
            return infoType.subclass(*args_, **kwargs_)
        else:
            return infoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rating(self): return self.rating
    def set_rating(self, rating): self.rating = rating
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='infoType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.rating is not None:
            element.set('rating', self.gds_format_float(self.rating))
        if self.type_ is not None:
            element.set('type', self.gds_format_integer(self.type_))
        if self.name is not None:
            element.set('name', self.gds_format_string(self.name))
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('rating', node)
        if value is not None and 'rating' not in already_processed:
            already_processed.add('rating')
            try:
                self.rating = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (rating): %s' % exp)
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            try:
                self.type_ = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class infoType


class vehicleType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('wheelcount', 'xs:integer', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, wheelcount=None, extensiontype_=None):
        self.original_tagname_ = None
        self.wheelcount = wheelcount
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if vehicleType.subclass:
            return vehicleType.subclass(*args_, **kwargs_)
        else:
            return vehicleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_wheelcount(self): return self.wheelcount
    def set_wheelcount(self, wheelcount): self.wheelcount = wheelcount
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.wheelcount is not None
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='vehicleType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.extensiontype_ is not None:
            element.set('{http://www.w3.org/2001/XMLSchema-instance}type', self.extensiontype_)
        if self.wheelcount is not None:
            wheelcount_ = self.wheelcount
            etree_.SubElement(element, '{}wheelcount').text = self.gds_format_integer(wheelcount_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'wheelcount':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'wheelcount')
            self.wheelcount = ival_
# end class vehicleType


class automobile(vehicleType):
    member_data_items_ = [
        MemberSpec_('drivername', 'xs:string', 0),
    ]
    subclass = None
    superclass = vehicleType
    def __init__(self, wheelcount=None, drivername=None):
        self.original_tagname_ = None
        super(automobile, self).__init__(wheelcount, )
        self.drivername = drivername
    def factory(*args_, **kwargs_):
        if automobile.subclass:
            return automobile.subclass(*args_, **kwargs_)
        else:
            return automobile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_drivername(self): return self.drivername
    def set_drivername(self, drivername): self.drivername = drivername
    def hasContent_(self):
        if (
            self.drivername is not None or
            super(automobile, self).hasContent_()
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='automobile', mapping_=None):
        element = super(automobile, self).to_etree(parent_element, name_, mapping_)
        if self.drivername is not None:
            drivername_ = self.drivername
            etree_.SubElement(element, '{}drivername').text = self.gds_format_string(drivername_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(automobile, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'drivername':
            drivername_ = child_.text
            drivername_ = self.gds_validate_string(drivername_, node, 'drivername')
            self.drivername = drivername_
        super(automobile, self).buildChildren(child_, node, nodeName_, True)
# end class automobile


class airplane(vehicleType):
    member_data_items_ = [
        MemberSpec_('pilotname', 'xs:string', 0),
    ]
    subclass = None
    superclass = vehicleType
    def __init__(self, wheelcount=None, pilotname=None):
        self.original_tagname_ = None
        super(airplane, self).__init__(wheelcount, )
        self.pilotname = pilotname
    def factory(*args_, **kwargs_):
        if airplane.subclass:
            return airplane.subclass(*args_, **kwargs_)
        else:
            return airplane(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pilotname(self): return self.pilotname
    def set_pilotname(self, pilotname): self.pilotname = pilotname
    def hasContent_(self):
        if (
            self.pilotname is not None or
            super(airplane, self).hasContent_()
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='airplane', mapping_=None):
        element = super(airplane, self).to_etree(parent_element, name_, mapping_)
        if self.pilotname is not None:
            pilotname_ = self.pilotname
            etree_.SubElement(element, '{}pilotname').text = self.gds_format_string(pilotname_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(airplane, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pilotname':
            pilotname_ = child_.text
            pilotname_ = self.gds_validate_string(pilotname_, node, 'pilotname')
            self.pilotname = pilotname_
        super(airplane, self).buildChildren(child_, node, nodeName_, True)
# end class airplane


class hot_agent(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('firstname', 'xs:string', 0),
        MemberSpec_('lastname', 'xs:string', 0),
        MemberSpec_('priority', 'xs:float', 0),
        MemberSpec_('startDate', 'xs:date', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, firstname='empty\\name', lastname='no \'last\' name', priority=None, startDate=None):
        self.original_tagname_ = None
        self.firstname = firstname
        self.lastname = lastname
        self.priority = priority
        if isinstance(startDate, basestring):
            initvalue_ = datetime_.datetime.strptime(startDate, '%Y-%m-%d').date()
        else:
            initvalue_ = startDate
        self.startDate = initvalue_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if hot_agent.subclass:
            return hot_agent.subclass(*args_, **kwargs_)
        else:
            return hot_agent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstname(self): return self.firstname
    def set_firstname(self, firstname): self.firstname = firstname
    def get_lastname(self): return self.lastname
    def set_lastname(self, lastname): self.lastname = lastname
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_startDate(self): return self.startDate
    def set_startDate(self, startDate): self.startDate = startDate
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.firstname is not None or
            self.lastname is not None or
            self.priority is not None or
            self.startDate is not None
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='hot.agent', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.firstname is not None:
            firstname_ = self.firstname
            etree_.SubElement(element, '{}firstname').text = self.gds_format_string(firstname_)
        if self.lastname is not None:
            lastname_ = self.lastname
            etree_.SubElement(element, '{}lastname').text = self.gds_format_string(lastname_)
        if self.priority is not None:
            priority_ = self.priority
            etree_.SubElement(element, '{}priority').text = self.gds_format_float(priority_)
        if self.startDate is not None:
            startDate_ = self.startDate
            etree_.SubElement(element, '{}startDate').text = self.gds_format_date(startDate_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstname':
            firstname_ = child_.text
            firstname_ = self.gds_validate_string(firstname_, node, 'firstname')
            self.firstname = firstname_
        elif nodeName_ == 'lastname':
            lastname_ = child_.text
            lastname_ = self.gds_validate_string(lastname_, node, 'lastname')
            self.lastname = lastname_
        elif nodeName_ == 'priority':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'priority')
            self.priority = fval_
        elif nodeName_ == 'startDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.startDate = dval_
# end class hot_agent


class client_handlerType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('fullname', 'xs:string', 0),
        MemberSpec_('refid', 'xs:integer', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, fullname=None, refid=None):
        self.original_tagname_ = None
        self.fullname = fullname
        self.refid = refid
    def factory(*args_, **kwargs_):
        if client_handlerType.subclass:
            return client_handlerType.subclass(*args_, **kwargs_)
        else:
            return client_handlerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fullname(self): return self.fullname
    def set_fullname(self, fullname): self.fullname = fullname
    def get_refid(self): return self.refid
    def set_refid(self, refid): self.refid = refid
    def hasContent_(self):
        if (
            self.fullname is not None or
            self.refid is not None
        ):
            return True
        else:
            return False
    def to_etree(self, parent_element=None, name_='client-handlerType', mapping_=None):
        if parent_element is None:
            element = etree_.Element('{}' + name_)
        else:
            element = etree_.SubElement(parent_element, '{}' + name_)
        if self.fullname is not None:
            fullname_ = self.fullname
            etree_.SubElement(element, '{}fullname').text = self.gds_format_string(fullname_)
        if self.refid is not None:
            refid_ = self.refid
            etree_.SubElement(element, '{}refid').text = self.gds_format_integer(refid_)
        if mapping_ is not None:
            mapping_[self] = element
        return element
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fullname':
            fullname_ = child_.text
            fullname_ = self.gds_validate_string(fullname_, node, 'fullname')
            self.fullname = fullname_
        elif nodeName_ == 'refid':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'refid')
            self.refid = ival_
# end class client_handlerType


GDSClassesMapping = {
    'info': infoType,
    'promoter': boosterType,
    'special-agent': special_agentType,
    'elparam': paramType,
    'python-programmer': python_programmerType,
    'people': peopleType,
    'client-handler': client_handlerType,
    'comments': commentsType,
    'weird-agent': weird_agentType,
    'person': personType,
    'agent': agentType,
    'java-programmer': java_programmerType,
    'vehicle': vehicleType,
    'programmer': programmerType,
    'param': paramType,
    'booster': boosterType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'peopleType'
        rootClass = peopleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='',
##             pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'peopleType'
        rootClass = peopleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
##     if not silence:
##         content = etree_.tostring(
##             rootElement, pretty_print=True,
##             xml_declaration=True, encoding="utf-8")
##         sys.stdout.write(content)
##         sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'peopleType'
        rootClass = peopleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'peopleType'
        rootClass = peopleType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('#from to_etree2_sup import *\n\n')
##         sys.stdout.write('import to_etree2_sup as model_\n\n')
##         sys.stdout.write('rootObj = model_.rootClass(\n')
##         rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##         sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "agentType",
    "airplane",
    "automobile",
    "boosterType",
    "client_handlerType",
    "commentsType",
    "hot_agent",
    "infoType",
    "java_programmerType",
    "paramType",
    "peopleType",
    "personType",
    "programmerType",
    "python_programmerType",
    "special_agentType",
    "specialperson",
    "vehicleType",
    "weird_agentType"
]
