
import sys
import upcase_names_api as api


def create_people(names):
    people = api.peopleSub()
    for count, name in enumerate(names):
        id = '%d' % (count + 1, )
        person = api.personSub(name=name, id=id)
        people.add_person(person)
    return people


def main():
    names = ['albert', 'betsy', 'charlie']
    people = create_people(names)
    print 'Before:'
    people.export(sys.stdout, 1)
    people.upcase_names()
    print '-' * 50
    print 'After:'
    people.export(sys.stdout, 1)
    

main()


