#!/usr/bin/env python

#
# Generated Tue Dec  8 12:26:08 2009 by generateDS.py version 1.20b.
#

import sys
import getopt
from string import lower as str_lower
from xml.dom import minidom
from xml.dom import Node

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Mixin class for additional behaviors.
#

class SessionTypeMixin(object):
    def copy(self):
        """Produce a copy of myself.
        """
        new_session = sessionType(
            input_schema = self.input_schema,
            output_superclass = self.output_superclass,
            output_subclass = self.output_subclass,
            force = self.force,
            prefix = self.prefix,
            namespace_prefix = self.namespace_prefix,
            empty_namespace_prefix = self.empty_namespace_prefix,
            behavior_filename = self.behavior_filename,
            properties = self.properties,
            subclass_suffix = self.subclass_suffix,
            root_element = self.root_element,
            superclass_module = self.superclass_module,
            auto_super = self.auto_super,
            old_getters_setters = self.old_getters_setters,
            validator_bodies = self.validator_bodies,
            user_methods = self.user_methods,
            no_dates = self.no_dates,
            no_versions = self.no_versions,
            no_process_includes = self.no_process_includes,
            silence = self.silence,
            namespace_defs = self.namespace_defs,
            external_encoding = self.external_encoding,
            member_specs = self.member_specs,
            )
        return new_session

    def __eq__(self, obj):
        """Implement the == operator.
        """
        if (
            obj.input_schema == self.input_schema and
            obj.output_superclass == self.output_superclass and
            obj.output_subclass == self.output_subclass and
            obj.force == self.force and
            obj.prefix == self.prefix and
            obj.namespace_prefix == self.namespace_prefix and
            obj.empty_namespace_prefix == self.empty_namespace_prefix and
            obj.behavior_filename == self.behavior_filename and
            obj.properties == self.properties and
            obj.subclass_suffix == self.subclass_suffix and
            obj.root_element == self.root_element and
            obj.superclass_module == self.superclass_module and
            obj.auto_super == self.auto_super and
            obj.old_getters_setters == self.old_getters_setters and
            obj.validator_bodies == self.validator_bodies and
            obj.user_methods == self.user_methods and
            obj.no_dates == self.no_dates and
            obj.no_versions == self.no_versions and
            obj.no_process_includes == self.no_process_includes and
            obj.silence == self.silence and
            obj.namespace_defs == self.namespace_defs and
            obj.external_encoding == self.external_encoding and
            obj.member_specs == self.member_specs):
            return True
        else:
            return False

    def __ne__(self, obj):
        """Implement the != operator.
        """
        return not self.__eq__(obj)


#
# Data representation classes.
#

class sessionType(GeneratedsSuper, SessionTypeMixin):
    member_data_items_ = [
        MemberSpec_('input_schema', 'xs:string', 0),
        MemberSpec_('output_superclass', 'xs:string', 0),
        MemberSpec_('output_subclass', 'xs:string', 0),
        MemberSpec_('force', 'xs:boolean', 0),
        MemberSpec_('prefix', 'xs:string', 0),
        MemberSpec_('namespace_prefix', 'xs:string', 0),
        MemberSpec_('empty_namespace_prefix', 'xs:boolean', 0),
        MemberSpec_('behavior_filename', 'xs:string', 0),
        MemberSpec_('properties', 'xs:boolean', 0),
        MemberSpec_('subclass_suffix', 'xs:string', 0),
        MemberSpec_('root_element', 'xs:string', 0),
        MemberSpec_('superclass_module', 'xs:string', 0),
        MemberSpec_('auto_super', 'xs:boolean', 0),
        MemberSpec_('old_getters_setters', 'xs:boolean', 0),
        MemberSpec_('validator_bodies', 'xs:string', 0),
        MemberSpec_('user_methods', 'xs:string', 0),
        MemberSpec_('no_dates', 'xs:boolean', 0),
        MemberSpec_('no_versions', 'xs:boolean', 0),
        MemberSpec_('no_process_includes', 'xs:boolean', 0),
        MemberSpec_('silence', 'xs:boolean', 0),
        MemberSpec_('namespace_defs', 'xs:string', 0),
        MemberSpec_('external_encoding', 'xs:string', 0),
        MemberSpec_('member_specs', 'xs:string', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, input_schema=None, output_superclass=None, output_subclass=None, force=None, prefix=None, namespace_prefix=None, empty_namespace_prefix=None, behavior_filename=None, properties=None, subclass_suffix=None, root_element=None, superclass_module=None, auto_super=None, old_getters_setters=None, validator_bodies=None, user_methods=None, no_dates=None, no_versions=None, no_process_includes=None, silence=None, namespace_defs=None, external_encoding=None, member_specs=None):
        self.input_schema = input_schema
        self.output_superclass = output_superclass
        self.output_subclass = output_subclass
        self.force = force
        self.prefix = prefix
        self.namespace_prefix = namespace_prefix
        self.empty_namespace_prefix = empty_namespace_prefix
        self.behavior_filename = behavior_filename
        self.properties = properties
        self.subclass_suffix = subclass_suffix
        self.root_element = root_element
        self.superclass_module = superclass_module
        self.auto_super = auto_super
        self.old_getters_setters = old_getters_setters
        self.validator_bodies = validator_bodies
        self.user_methods = user_methods
        self.no_dates = no_dates
        self.no_versions = no_versions
        self.no_process_includes = no_process_includes
        self.silence = silence
        self.namespace_defs = namespace_defs
        self.external_encoding = external_encoding
        self.member_specs = member_specs
    def factory(*args_, **kwargs_):
        if sessionType.subclass:
            return sessionType.subclass(*args_, **kwargs_)
        else:
            return sessionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_input_schema(self): return self.input_schema
    def set_input_schema(self, input_schema): self.input_schema = input_schema
    input_schemaProp = property(get_input_schema, set_input_schema)
    def get_output_superclass(self): return self.output_superclass
    def set_output_superclass(self, output_superclass): self.output_superclass = output_superclass
    output_superclassProp = property(get_output_superclass, set_output_superclass)
    def get_output_subclass(self): return self.output_subclass
    def set_output_subclass(self, output_subclass): self.output_subclass = output_subclass
    output_subclassProp = property(get_output_subclass, set_output_subclass)
    def get_force(self): return self.force
    def set_force(self, force): self.force = force
    forceProp = property(get_force, set_force)
    def get_prefix(self): return self.prefix
    def set_prefix(self, prefix): self.prefix = prefix
    prefixProp = property(get_prefix, set_prefix)
    def get_namespace_prefix(self): return self.namespace_prefix
    def set_namespace_prefix(self, namespace_prefix): self.namespace_prefix = namespace_prefix
    namespace_prefixProp = property(get_namespace_prefix, set_namespace_prefix)
    def get_empty_namespace_prefix(self): return self.empty_namespace_prefix
    def set_empty_namespace_prefix(self, empty_namespace_prefix): self.empty_namespace_prefix = empty_namespace_prefix
    empty_namespace_prefixProp = property(get_empty_namespace_prefix, set_empty_namespace_prefix)
    def get_behavior_filename(self): return self.behavior_filename
    def set_behavior_filename(self, behavior_filename): self.behavior_filename = behavior_filename
    behavior_filenameProp = property(get_behavior_filename, set_behavior_filename)
    def get_properties(self): return self.properties
    def set_properties(self, properties): self.properties = properties
    propertiesProp = property(get_properties, set_properties)
    def get_subclass_suffix(self): return self.subclass_suffix
    def set_subclass_suffix(self, subclass_suffix): self.subclass_suffix = subclass_suffix
    subclass_suffixProp = property(get_subclass_suffix, set_subclass_suffix)
    def get_root_element(self): return self.root_element
    def set_root_element(self, root_element): self.root_element = root_element
    root_elementProp = property(get_root_element, set_root_element)
    def get_superclass_module(self): return self.superclass_module
    def set_superclass_module(self, superclass_module): self.superclass_module = superclass_module
    superclass_moduleProp = property(get_superclass_module, set_superclass_module)
    def get_auto_super(self): return self.auto_super
    def set_auto_super(self, auto_super): self.auto_super = auto_super
    auto_superProp = property(get_auto_super, set_auto_super)
    def get_old_getters_setters(self): return self.old_getters_setters
    def set_old_getters_setters(self, old_getters_setters): self.old_getters_setters = old_getters_setters
    old_getters_settersProp = property(get_old_getters_setters, set_old_getters_setters)
    def get_validator_bodies(self): return self.validator_bodies
    def set_validator_bodies(self, validator_bodies): self.validator_bodies = validator_bodies
    validator_bodiesProp = property(get_validator_bodies, set_validator_bodies)
    def get_user_methods(self): return self.user_methods
    def set_user_methods(self, user_methods): self.user_methods = user_methods
    user_methodsProp = property(get_user_methods, set_user_methods)
    def get_no_dates(self): return self.no_dates
    def set_no_dates(self, no_dates): self.no_dates = no_dates
    no_datesProp = property(get_no_dates, set_no_dates)
    def get_no_versions(self): return self.no_versions
    def set_no_versions(self, no_versions): self.no_versions = no_versions
    no_versionsProp = property(get_no_versions, set_no_versions)
    def get_no_process_includes(self): return self.no_process_includes
    def set_no_process_includes(self, no_process_includes): self.no_process_includes = no_process_includes
    no_process_includesProp = property(get_no_process_includes, set_no_process_includes)
    def get_silence(self): return self.silence
    def set_silence(self, silence): self.silence = silence
    silenceProp = property(get_silence, set_silence)
    def get_namespace_defs(self): return self.namespace_defs
    def set_namespace_defs(self, namespace_defs): self.namespace_defs = namespace_defs
    namespace_defsProp = property(get_namespace_defs, set_namespace_defs)
    def get_external_encoding(self): return self.external_encoding
    def set_external_encoding(self, external_encoding): self.external_encoding = external_encoding
    external_encodingProp = property(get_external_encoding, set_external_encoding)
    def get_member_specs(self): return self.member_specs
    def set_member_specs(self, member_specs): self.member_specs = member_specs
    member_specsProp = property(get_member_specs, set_member_specs)
    def export(self, outfile, level, namespace_='', name_='sessionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='sessionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='sessionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='sessionType'):
        if self.input_schema is not None:
            showIndent(outfile, level)
            outfile.write('<%sinput_schema>%s</%sinput_schema>\n' % (namespace_, self.format_string(quote_xml(self.input_schema).encode(ExternalEncoding), input_name='input_schema'), namespace_))
        if self.output_superclass is not None:
            showIndent(outfile, level)
            outfile.write('<%soutput_superclass>%s</%soutput_superclass>\n' % (namespace_, self.format_string(quote_xml(self.output_superclass).encode(ExternalEncoding), input_name='output_superclass'), namespace_))
        if self.output_subclass is not None:
            showIndent(outfile, level)
            outfile.write('<%soutput_subclass>%s</%soutput_subclass>\n' % (namespace_, self.format_string(quote_xml(self.output_subclass).encode(ExternalEncoding), input_name='output_subclass'), namespace_))
        if self.force is not None:
            showIndent(outfile, level)
            outfile.write('<%sforce>%s</%sforce>\n' % (namespace_, self.format_boolean(str_lower(str(self.force)), input_name='force'), namespace_))
        if self.prefix is not None:
            showIndent(outfile, level)
            outfile.write('<%sprefix>%s</%sprefix>\n' % (namespace_, self.format_string(quote_xml(self.prefix).encode(ExternalEncoding), input_name='prefix'), namespace_))
        if self.namespace_prefix is not None:
            showIndent(outfile, level)
            outfile.write('<%snamespace_prefix>%s</%snamespace_prefix>\n' % (namespace_, self.format_string(quote_xml(self.namespace_prefix).encode(ExternalEncoding), input_name='namespace_prefix'), namespace_))
        if self.empty_namespace_prefix is not None:
            showIndent(outfile, level)
            outfile.write('<%sempty_namespace_prefix>%s</%sempty_namespace_prefix>\n' % (namespace_, self.format_boolean(str_lower(str(self.empty_namespace_prefix)), input_name='empty_namespace_prefix'), namespace_))
        if self.behavior_filename is not None:
            showIndent(outfile, level)
            outfile.write('<%sbehavior_filename>%s</%sbehavior_filename>\n' % (namespace_, self.format_string(quote_xml(self.behavior_filename).encode(ExternalEncoding), input_name='behavior_filename'), namespace_))
        if self.properties is not None:
            showIndent(outfile, level)
            outfile.write('<%sproperties>%s</%sproperties>\n' % (namespace_, self.format_boolean(str_lower(str(self.properties)), input_name='properties'), namespace_))
        if self.subclass_suffix is not None:
            showIndent(outfile, level)
            outfile.write('<%ssubclass_suffix>%s</%ssubclass_suffix>\n' % (namespace_, self.format_string(quote_xml(self.subclass_suffix).encode(ExternalEncoding), input_name='subclass_suffix'), namespace_))
        if self.root_element is not None:
            showIndent(outfile, level)
            outfile.write('<%sroot_element>%s</%sroot_element>\n' % (namespace_, self.format_string(quote_xml(self.root_element).encode(ExternalEncoding), input_name='root_element'), namespace_))
        if self.superclass_module is not None:
            showIndent(outfile, level)
            outfile.write('<%ssuperclass_module>%s</%ssuperclass_module>\n' % (namespace_, self.format_string(quote_xml(self.superclass_module).encode(ExternalEncoding), input_name='superclass_module'), namespace_))
        if self.auto_super is not None:
            showIndent(outfile, level)
            outfile.write('<%sauto_super>%s</%sauto_super>\n' % (namespace_, self.format_boolean(str_lower(str(self.auto_super)), input_name='auto_super'), namespace_))
        if self.old_getters_setters is not None:
            showIndent(outfile, level)
            outfile.write('<%sold_getters_setters>%s</%sold_getters_setters>\n' % (namespace_, self.format_boolean(str_lower(str(self.old_getters_setters)), input_name='old_getters_setters'), namespace_))
        if self.validator_bodies is not None:
            showIndent(outfile, level)
            outfile.write('<%svalidator_bodies>%s</%svalidator_bodies>\n' % (namespace_, self.format_string(quote_xml(self.validator_bodies).encode(ExternalEncoding), input_name='validator_bodies'), namespace_))
        if self.user_methods is not None:
            showIndent(outfile, level)
            outfile.write('<%suser_methods>%s</%suser_methods>\n' % (namespace_, self.format_string(quote_xml(self.user_methods).encode(ExternalEncoding), input_name='user_methods'), namespace_))
        if self.no_dates is not None:
            showIndent(outfile, level)
            outfile.write('<%sno_dates>%s</%sno_dates>\n' % (namespace_, self.format_boolean(str_lower(str(self.no_dates)), input_name='no_dates'), namespace_))
        if self.no_versions is not None:
            showIndent(outfile, level)
            outfile.write('<%sno_versions>%s</%sno_versions>\n' % (namespace_, self.format_boolean(str_lower(str(self.no_versions)), input_name='no_versions'), namespace_))
        if self.no_process_includes is not None:
            showIndent(outfile, level)
            outfile.write('<%sno_process_includes>%s</%sno_process_includes>\n' % (namespace_, self.format_boolean(str_lower(str(self.no_process_includes)), input_name='no_process_includes'), namespace_))
        if self.silence is not None:
            showIndent(outfile, level)
            outfile.write('<%ssilence>%s</%ssilence>\n' % (namespace_, self.format_boolean(str_lower(str(self.silence)), input_name='silence'), namespace_))
        if self.namespace_defs is not None:
            showIndent(outfile, level)
            outfile.write('<%snamespace_defs>%s</%snamespace_defs>\n' % (namespace_, self.format_string(quote_xml(self.namespace_defs).encode(ExternalEncoding), input_name='namespace_defs'), namespace_))
        if self.external_encoding is not None:
            showIndent(outfile, level)
            outfile.write('<%sexternal_encoding>%s</%sexternal_encoding>\n' % (namespace_, self.format_string(quote_xml(self.external_encoding).encode(ExternalEncoding), input_name='external_encoding'), namespace_))
        if self.member_specs is not None:
            showIndent(outfile, level)
            outfile.write('<%smember_specs>%s</%smember_specs>\n' % (namespace_, self.format_string(quote_xml(self.member_specs).encode(ExternalEncoding), input_name='member_specs'), namespace_))
    def hasContent_(self):
        if (
            self.input_schema is not None or
            self.output_superclass is not None or
            self.output_subclass is not None or
            self.force is not None or
            self.prefix is not None or
            self.namespace_prefix is not None or
            self.empty_namespace_prefix is not None or
            self.behavior_filename is not None or
            self.properties is not None or
            self.subclass_suffix is not None or
            self.root_element is not None or
            self.superclass_module is not None or
            self.auto_super is not None or
            self.old_getters_setters is not None or
            self.validator_bodies is not None or
            self.user_methods is not None or
            self.no_dates is not None or
            self.no_versions is not None or
            self.no_process_includes is not None or
            self.silence is not None or
            self.namespace_defs is not None or
            self.external_encoding is not None or
            self.member_specs is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='sessionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('input_schema=%s,\n' % quote_python(self.input_schema).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('output_superclass=%s,\n' % quote_python(self.output_superclass).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('output_subclass=%s,\n' % quote_python(self.output_subclass).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('force=%s,\n' % self.force)
        showIndent(outfile, level)
        outfile.write('prefix=%s,\n' % quote_python(self.prefix).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('namespace_prefix=%s,\n' % quote_python(self.namespace_prefix).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('empty_namespace_prefix=%s,\n' % self.empty_namespace_prefix)
        showIndent(outfile, level)
        outfile.write('behavior_filename=%s,\n' % quote_python(self.behavior_filename).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('properties=%s,\n' % self.properties)
        showIndent(outfile, level)
        outfile.write('subclass_suffix=%s,\n' % quote_python(self.subclass_suffix).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('root_element=%s,\n' % quote_python(self.root_element).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('superclass_module=%s,\n' % quote_python(self.superclass_module).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('auto_super=%s,\n' % self.auto_super)
        showIndent(outfile, level)
        outfile.write('old_getters_setters=%s,\n' % self.old_getters_setters)
        showIndent(outfile, level)
        outfile.write('validator_bodies=%s,\n' % quote_python(self.validator_bodies).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('user_methods=%s,\n' % quote_python(self.user_methods).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('no_dates=%s,\n' % self.no_dates)
        showIndent(outfile, level)
        outfile.write('no_versions=%s,\n' % self.no_versions)
        showIndent(outfile, level)
        outfile.write('no_process_includes=%s,\n' % self.no_process_includes)
        showIndent(outfile, level)
        outfile.write('silence=%s,\n' % self.silence)
        showIndent(outfile, level)
        outfile.write('namespace_defs=%s,\n' % quote_python(self.namespace_defs).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('external_encoding=%s,\n' % quote_python(self.external_encoding).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('member_specs=%s,\n' % quote_python(self.member_specs).encode(ExternalEncoding))
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        pass
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'input_schema':
            input_schema_ = ''
            for text__content_ in child_.childNodes:
                input_schema_ += text__content_.nodeValue
            self.input_schema = input_schema_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'output_superclass':
            output_superclass_ = ''
            for text__content_ in child_.childNodes:
                output_superclass_ += text__content_.nodeValue
            self.output_superclass = output_superclass_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'output_subclass':
            output_subclass_ = ''
            for text__content_ in child_.childNodes:
                output_subclass_ += text__content_.nodeValue
            self.output_subclass = output_subclass_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'force':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.force = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'prefix':
            prefix_ = ''
            for text__content_ in child_.childNodes:
                prefix_ += text__content_.nodeValue
            self.prefix = prefix_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'namespace_prefix':
            namespace_prefix_ = ''
            for text__content_ in child_.childNodes:
                namespace_prefix_ += text__content_.nodeValue
            self.namespace_prefix = namespace_prefix_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'empty_namespace_prefix':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.empty_namespace_prefix = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'behavior_filename':
            behavior_filename_ = ''
            for text__content_ in child_.childNodes:
                behavior_filename_ += text__content_.nodeValue
            self.behavior_filename = behavior_filename_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'properties':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.properties = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'subclass_suffix':
            subclass_suffix_ = ''
            for text__content_ in child_.childNodes:
                subclass_suffix_ += text__content_.nodeValue
            self.subclass_suffix = subclass_suffix_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'root_element':
            root_element_ = ''
            for text__content_ in child_.childNodes:
                root_element_ += text__content_.nodeValue
            self.root_element = root_element_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'superclass_module':
            superclass_module_ = ''
            for text__content_ in child_.childNodes:
                superclass_module_ += text__content_.nodeValue
            self.superclass_module = superclass_module_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'auto_super':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.auto_super = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'old_getters_setters':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.old_getters_setters = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'validator_bodies':
            validator_bodies_ = ''
            for text__content_ in child_.childNodes:
                validator_bodies_ += text__content_.nodeValue
            self.validator_bodies = validator_bodies_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'user_methods':
            user_methods_ = ''
            for text__content_ in child_.childNodes:
                user_methods_ += text__content_.nodeValue
            self.user_methods = user_methods_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'no_dates':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.no_dates = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'no_versions':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.no_versions = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'no_process_includes':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.no_process_includes = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'silence':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                if sval_ in ('true', '1'):
                    ival_ = True
                elif sval_ in ('false', '0'):
                    ival_ = False
                else:
                    raise ValueError('requires boolean -- %s' % child_.toxml())
                self.silence = ival_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'namespace_defs':
            namespace_defs_ = ''
            for text__content_ in child_.childNodes:
                namespace_defs_ += text__content_.nodeValue
            self.namespace_defs = namespace_defs_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'external_encoding':
            external_encoding_ = ''
            for text__content_ in child_.childNodes:
                external_encoding_ += text__content_.nodeValue
            self.external_encoding = external_encoding_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'member_specs':
            member_specs_ = ''
            for text__content_ in child_.childNodes:
                member_specs_ += text__content_.nodeValue
            self.member_specs = member_specs_
# end class sessionType


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = sessionType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="session", 
        namespacedef_='')
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.documentElement
    rootObj = sessionType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="session",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = sessionType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('from generateds_gui_session import *\n\n')
    sys.stdout.write('rootObj = session(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_="session")
    sys.stdout.write(')\n')
    return rootObj


def process_commandline():
    from optparse import OptionParser
    parser = OptionParser(USAGE_TEXT)
    parser.add_option("-o", "--output-superclass",
        dest="output_superclass", default='', type='string',
        help="Output file name for data representation classes")
    parser.add_option("-s", "--output-subclass",
        dest="output_subclass", default='', type='string',
        help="Output file name for subclasses")
    parser.add_option("-f", "--force", action="store_true",
        dest="force", default=False,
        help="force overwrite without asking")
    parser.add_option("-p", "--prefix",
        dest="prefix", default='', type='string',
        help="Prefix string to be pre-pended to the class names")
    parser.add_option("-a",
        dest="namespace_prefix", default='', type='string',
        help='Namespace prefix, e.g. "xsd:". Default = "xs:"')
    parser.add_option("-b",
        dest="behavior_filename", default='', type='string',
        help="Input file name for behaviors added to subclasses")
    parser.add_option("-m", "--properties", action="store_true",
        dest="properties", default=False,
        help="Generate properties for member variables")
    parser.add_option("--subclass-suffix",
        dest="subclass_suffix", default='', type='string',
        help='Append XXX to the generated subclass names.  Default="Sub"')
    parser.add_option("--root-element",
        dest="root_element", default='', type='string',
        help="Assume XXX is root element of instance docs.  "
            "Default is first element defined in schema.")
    parser.add_option("--super",
        dest="superclass_module", default='', type='string',
        help='Super module name in subclass module. Default="???"')
    parser.add_option("--validator-bodies",
        dest="validator_bodies", default='', type='string',
        help='Path to a directory containing files that provide '
            'bodies (implementations) of validator methods')
    parser.add_option("--use-old-getter-setter", action="store_true",
        dest="old_getters_setters", default=False,
        help="Name getters and setters getVar() and setVar(), "
            "instead of get_var() and set_var()")
    parser.add_option("-u", "--user-methods",
        dest="user_methods", default='', type='string',
        help='Optional module containing user methods '
            '(see section "User Methods" in the documentation)')
    parser.add_option("--no-dates", action="store_true",
        dest="no_dates", default=False,
        help='Do not include the current date in the generated '
            'files. This is useful if you want to minimize '
            'the amount of (no-operation) changes to the '
            'generated python code.')
    parser.add_option("--no-versions", action="store_true",
        dest="no_versions", default=False,
        help='Do not include the current version in the generated '
            'files. This is useful if you want to minimize '
            'the amount of (no-operation) changes to the '
            'generated python code.')
    parser.add_option("--no-process-includes", action="store_true",
        dest="no_process_includes", default=False,
        help='Do not process included XML Schema files.  By '
            'default, generateDS.py will insert content '
            'from files referenced by <include ... /> '
            'elements into the XML Schema to be processed.')
    parser.add_option("--silence", action="store_true",
        dest="silence", default=False,
        help='Normally, the code generated with generateDS '
            'echoes the information being parsed. To prevent '
            'the echo from occurring, use the --silence switch.')
    parser.add_option("--namespacedef",
        dest="namespace_defs", default='', type='string',
        help='Namespace definition to be passed in as the '
            'value for the namespacedef_ parameter of '
            'the export() method by the generated '
            'parse() and parseString() functions. '
            "Example: 'xmlns:abc=\"http://www.abc.com\"' Default=''")
    parser.add_option("--external-encoding",
        dest="external_encoding", default='', type='string',
        help='Encode output written by the generated export '
            'methods using this encoding.  Default, if omitted, '
            'is the value returned by sys.getdefaultencoding(). '
            "Example: --external-encoding='utf-8'.")
    parser.add_option("--member-specs",
        dest="member_specs", default='', type='string',
        help='Generate member (type) specifications in each '
            'class: a dictionary of instances of class '
            'MemberSpec_ containing member name, type, '
            'and array or not.  Allowed values are '
            '"list" or "dict".  Default: do not generate.')
    parser.add_option("--no-questions", action="store_true",
        dest="no_questions", default=False,
        help='Do not ask questios, for example, force overwrite.')
    parser.add_option("--version", action="store_true",
        dest="version", default=False,
        help='Print version and exit.')
    parser.add_option("--session",
        dest="session", default='', type='string',
        help='Load and use options from session file. You can '
            'create session file in generateds_gui.py.  Or, '
            'copy and edit sample.session from the '
            'distribution.')

    (options, args) = parser.parse_args()
    sessionObj = sessionType(
        output_superclass=options.output_superclass,
        output_subclass=options.output_subclass,
        force=options.force,
        prefix=options.prefix,
        namespace_prefix=options.namespace_prefix,
        empty_namespace_prefix=False,
        behavior_filename=options.behavior_filename,
        properties=options.properties,
        subclass_suffix=options.subclass_suffix,
        root_element=options.root_element,
        superclass_module=options.superclass_module,
        auto_super=False,
        old_getters_setters=options.old_getters_setters,
        validator_bodies=options.validator_bodies,
        user_methods=options.user_methods,
        no_dates=options.no_dates,
        no_versions=options.no_versions,
        no_process_includes=options.no_process_includes,
        silence=options.silence,
        namespace_defs=options.namespace_defs,
        external_encoding=options.external_encoding,
        member_specs=options.member_specs
        )
    schema_filename = None
    if len(args) == 1:
        schema_filename = args[0]
        return args[0], sessionObj, options
    else:
        return None, None, None


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

