""" Genshi Compiler - Template compiler mostly compatible with Genshi's syntax

(C) 2011 - Viktor Ferenczi <viktor@ferenczi.eu>

Project home: http://code.google.com/p/genshi-compiler/

Compiles Gensi XML templates into native source code for improved performance.

Supports most of Genshi's XML template constructs, see below for limitations.
This approach provides most of the advantages of XML templating at the speed
of text templates.

Requires Python 2.6 and lxml:

 * http://pypi.python.org/pypi/lxml
 * http://lxml.de/

License: MIT

Please see the following directories in the source distribution:
 * tests: unit test suite
 * examples: example templates and scripts to compile and use them
 * benchmarks: benchmark scripts for performance comparison
 
See below for detailed notes on the supported template constructs.

------------------------------------------------------------------------------

The compiled template is always an ASCII encoded source code of a program
module in the target programming language of the compiler sublass you're
using. The compiled module provides functions to render the template in
a similar way as Genshi would, but without providing access to the token
stream.

The generated source code can be saved as a program module, then imported
exactly like your regular code. You can even compile the generated Python
source code in memory without having a separate build step, which is seful
for development.

Each generated module contains a `render` function for rendering the whole
template and additional functions for each py:def constructs defined.
Template functions can also be called to generate output, so they
remain reusable even after compiling the template.

This compiler is mostly useful to speed up the most frequently used fragments
of your templates by compiling them to native code, even to an extension
module. Please note, that the compiler itself is not optimized for speed.
It is still useful in cases where runtime compilation of a changing template
is needed, but that is not its intended use case.

Limitations:

 * No support for features requiring the complete XML representation
   of the generated contents, most notably py:match is not supported.

 * No support for features requiring a template loader, so xi:include
   won't work. You can work around this by inserting a <%python %>
   processing instruction importing the compiled module corresponding
   to the template you wanted to include. Then you can simply invoke
   any of the compiled template functions from the imported module.
   Don't forget to enclose such calls into Markup() to prevent escaping
   of HTML generated by the compiled functions you are calling. 
  
 * No support for stream filters, since the compiler is generating code
   for the direct formatting of textual output, so no token stream used
   as an intermediate representation. If you want to post-process the 
   XML output, then you need to parse it, but this way it might not worth
   to compile the XML template in the first place...
   
 * Lenient variable lookup mode is not supported, since we generate actual
   source code depending on all the variables. Having to check for a
   special UNDEFINED value at runtime would lower the performance of the
   resulting code. Using such lenient variable lookups usually result in
   more fragile code and increased debugging time, so it is not a good
   practice in general.
 
 * No Undefined type. Please see above.
 
 * defined(...) and value_of(...) template expressions are not supported,
   since they are not useful and not needed, see the previous item. You can
   use locals()[...] as a replacement for value_of(...) if you really need it.
 
 * Markup() is recognized only as the outermost call of template expression,
   so no way to concatenate multiple sub-expressions resulting in Markup
   objects in a single template expression. Use multiple subsequent
   expressions or enclose the whole expression in Markup() to prevent
   escaping of the expression's results. Markup() calls are compiled as
   code without escaping and do not result in any special call at runtime.
   
 * Calling template functions are only recognized as the outermost call inside
   template expressions, like in the case of Markup(). If you generate markup
   in a more complex way or have to call template functions from another
   module, then you need to enclose your whole template expression in Markup()
   to prevent escaping the result.
   
 * py:attrs cannot overwrite an attribute already listed for the given element
   in the template itself, such attributes will be doubled in the output,
   which might render the output markup invalid. We plan to detect this case,
   so such a situation might end up in a compile time exception in the future.
   
 * There can be more, please feel free to open tickets for them.
 
Important:
 
 * The compiler always defines the global method `render`, so there must be no
   Genshi function definition named `render`. You can modify the name of this
   function by overriding the `render_method_name` class attribute in your
   compiler subclass.
   
 * py:def defines global functions, so they are reusable separately
   just like the `render` function. They return unicode markup just like
   the `render` function, not Markup objects.
   
 * Python code can be embedded using the <?python ... ?> processing
   instruction. Common indentation is removed from the code block,
   so you can indent your block in a way it is the most readable for you.
   The compiler will indent the block to match its position in the generated
   source code.
   
Future plans:

  * See the Issue Tracker and Wiki of the Google Code project:
    http://code.google.com/p/genshi-compiler/
 
"""
