# coding: utf-8
#
# Copyright (c) 2011, CN-Software Ltd.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification,
# are permitted provided that the following conditions are met:
#
#     1. Redistributions of source code must retain the above copyright notice,
#        this list of conditions and the following disclaimer.
#
#     2. Redistributions in binary form must reproduce the above copyright
#        notice, this list of conditions and the following disclaimer in the
#        documentation and/or other materials provided with the distribution.
#
#     3. Neither the name of CN-Software Ltd. nor the names of its contributors
#        may be used to endorse or promote products derived from this software
#        without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

from distutils.core import setup
import logging
import sys

long_desc = """
Geolocation by the IP-address.

Geobaza is the software for identifying geolocation by IP-address, developed and
supported by CN-Software Ltd. Taking a certain IP-address, Geobaza outputs its
local registration data—a country and a city with geographic coordinates.

Geobaza database optionally includes: object identifier ISO 3166, translations,
up-to-date information about population size and official languages.

Documentation: http://geobaza.ru/docs/python/v1/.

Detailed information and updates: http://geobaza.ru/.

Copyright (c) 2011, CN-Software Ltd. All rights reserved.
"""

if sys.version_info < (2, 5):
    logging.error('Geobaza requires at least Python 2.5!')
    sys.exit(1)

setup(name='geobaza',
      version='1.0.1.11.11',
      author='CN-Software Ltd.',
      author_email='support@cn-software.com',
      maintainer='Ilya Nikiforov',
      maintainer_email='ilya@cn-software.com',
      url='http://geobaza.ru/',
      description='Geobaza is the software for geolocation by IP-address.',
      scripts=['geobaza/bin/geobaza-lookup.py'],
      packages=['geobaza'],
      package_dir={'geobaza': 'geobaza'},
      package_data={'geobaza': ['data/geobaza.dat']},
      install_requires=['simplejson'],
      provides=['geobaza'],
      classifiers=[
          'Development Status :: 5 - Production/Stable',
          'Intended Audience :: Developers',
          'Environment :: Console',
          'License :: OSI Approved :: BSD License',
          'Operating System :: OS Independent',
          'Programming Language :: Python',
          'Topic :: Database',
      ],
      platforms=['All'],
      license='New-style BSD',
      long_description=long_desc
)
