#!/usr/bin/env python
#
# Copyright (c) 2012, CN-Software Ltd.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification,
# are permitted provided that the following conditions are met:
#
#     1. Redistributions of source code must retain the above copyright notice,
#        this list of conditions and the following disclaimer.
#
#     2. Redistributions in binary form must reproduce the above copyright
#        notice, this list of conditions and the following disclaimer in the
#        documentation and/or other materials provided with the distribution.
#
#     3. Neither the name of CN-Software Ltd. nor the names of its contributors
#        may be used to endorse or promote products derived from this software
#        without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import sys
from optparse import OptionParser
from geobaza import lookup, lookup_json, lookup_xml

if __name__ == '__main__':
    usage = "Usage: %prog [options] ip_address"
    parser = OptionParser(usage)
    parser.add_option('-f', '--format',
                      dest='format',
                      choices=['text', 'json', 'xml'],
                      default='text',
                      help='Output format')
    parser.add_option('-p', '--pretty',
                      dest='pretty',
                      action='store_true',
                      default=False,
                      help='Prettify output')
    (options, args) = parser.parse_args()

    if len(args) != 1:
        parser.error('You must specify an IP-address')

    ip = args[0]
    pretty = options.pretty

    if options.format == 'xml':
        print lookup_xml(ip, pretty=pretty)
        sys.exit(0)
    elif options.format == 'json':
        print lookup_json(ip, pretty=pretty)
        sys.exit(0)
    else:
        geobaza = lookup(ip)

    ind = ' '
    print
    print '%sInformation for IP-address: %s' % (ind, ip)
    print
    if geobaza:
        if len(geobaza) == 1:
            print '%s%s' % (ind, geobaza[0])
            print
        else:
            for i, place in enumerate(geobaza):
                if i: print '%s+--%s%s' % (ind, '-' * 2 * i, place)
                else: print '%s+--%s' % (ind, place)
                if i < len(geobaza) - 1: print '%s|' % ind
                else: print
    else:
        print '%sNo information for given IP-address' % ind
        print
