import tempfile

from bs4 import BeautifulSoup
from ..errors import MissingDataException

__all__ = ['TBPLMixin']

class TBPLMixin(object):
    _base_tbpl_url = 'https://tbpl.mozilla.org'
    tbpl_terms = { 'gecko': 'b2g-arm',
                   'panda': 'b2g-panda',
                   'unagi': 'b2g-unagi' }

    def get_build_directory(self, resource):
        log_url = self.metadata['tbpl']

        doc = self.download_file(log_url, tempfile.mkstemp()[1], silent=True)
        soup = BeautifulSoup(open(doc, 'r'))
        print soup.prettify()
        p = soup.find('p', class_='downloadFullLog')
        href = p.find('a').href
        return href.rsplit('/', 1)[0]






