'''
Created on Sep 1, 2014

@author: scrosby
'''
import re, os

class Gherkin:
    def __init__(self, feature_file_data):
        self.data = feature_file_data
        
    def get_gus_id(self):
        match = re.search("@gus:(W-\d{7})", self.data)
        return match.group(1)
        
    def get_scenarios(self):
        out = []
        matches = re.finditer("(Scenario.*?)\r?\n((\r?\n)|$)", self.data, flags=re.DOTALL|re.M)
        for match in matches:
            out.append(Scenario(match.group(1)))
            
        return out
    
    def get_feature_name(self):
        match = re.search("Feature: (.*){}".format(os.linesep), self.data)
        return match.group(1)
    
    def get_backgroud_steps(self):
        match = re.search("Background:(.*?){}".format(os.linesep * 2), self.data, flags=re.DOTALL)
        scenario = Scenario(match.group(1))
        return scenario.get_steps()
    
class Scenario:
    def __init__(self, scenario_text):
        self.data = scenario_text
        
    def get_name(self):
        match = re.search("Scenario( Outline)?: (.*){}".format(os.linesep), self.data)
        return match.group(2)
    
    def is_outline(self):
        match = re.search("Scenario Outline:", self.data)
        return match is not None
    
    def get_examples(self):
        if self.is_outline():
            out = []
            match = re.search("Examples:\r?{}(.*)".format(os.linesep), self.data, flags=re.DOTALL|re.M)
            lines = match.group(1).split(os.linesep)
            headings = [ x.strip() for x in lines[0].strip(" |\r?").split("|")]
            for line in lines[1:]:
                detail = {}
                values = [ x.strip() for x in line.strip(" |").split("|")]
                x = 0
                for h in headings:
                    detail[h] = values[x]
                    x+=1
                out.append(detail)
            return out
        else:
            return None
    
    def get_steps(self):
        out = []
        matches = re.finditer("^\s*((Given|When|Then|And|But) .*)", self.data, flags=re.MULTILINE)
        for match in matches:
            out.append(Step(match.group(1)))
        return out
    
    def get_description(self):
        out = "\n".join(["{} {}".format(x.prefix, x.text) for x in self.get_steps()])
        if self.is_outline():
            out += "{}Examples:{}".format(os.linesep * 2, os.linesep)
            examples = self.get_examples()
            out += "| "
            for h in examples[0].keys():
                out += "{} |".format(h)
                
            for example in examples:
                out += "{}| ".format(os.linesep)
                for v in example.values():
                    out += "{} |".format(v)
        return out

class Step:
    def __init__(self, line):
        self.data = line
        match = re.search("^(Given|When|Then|And|But) (.*)", self.data)
        self.prefix = match.group(1)
        self.text = match.group(2)
        
    