#!/usr/bin/env python
# encoding: utf-8
'''
bin.mock_test_execution -- shortdesc

bin.mock_test_execution is a description

It defines classes_and_methods

@author:     user_name

@copyright:  2014 organization_name. All rights reserved.

@license:    license

@contact:    user_email
@deffield    updated: Updated
'''

import sys
import os, re, datetime, random, requests, json

from optparse import OptionParser
from gus.BacklogClient import BacklogClient

__all__ = []
__version__ = 0.1
__date__ = '2014-08-25'
__updated__ = '2014-08-25'

def main(argv=None):
    '''Command line options.'''

    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__

    program_version_string = '%%prog %s (%s)' % (program_version, program_build_date)
    #program_usage = '''usage: spam two eggs''' # optional - will be autogenerated by optparse
    program_longdesc = '''''' # optional - give further explanation about what the program does
    program_license = "Copyright 2014 user_name (organization_name)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"

    if argv is None:
        argv = sys.argv[1:]
    try:
        # setup option parser
        parser = OptionParser(version=program_version_string, epilog=program_longdesc, description=program_license)
        parser.add_option("-t", "--team", dest="team", help="ID of team to generate feature files for entire sprint")
        parser.add_option("-b", "--build", dest="build", help="Build name to use")

        parser.set_default("build", "MC_Something")
        # process options
        (opts, args) = parser.parse_args(argv)
        gus = BacklogClient()
        
        if opts.team is not None:
            sprint = gus.get_current_sprint_for_team(opts.team)
            work_list = gus.get_user_stories_for_sprint(sprint)
        else:
            work_list = []    
            for arg in args:
                work = gus.find_work(arg)
                work_list.append(work['Id'])
        
        for work in work_list:
            w_record = gus.get_work_record(work)
            feature = w_record['Subject__c']
            all_ac = gus.get_acceptance_criteria_for_work(work)
            for ac in all_ac:
                acceptance = gus.get_acceptance_criterion_record(ac)
                description = acceptance['Description__c']
                match = re.search("When (.*)\nThen (.*)", description, flags=re.IGNORECASE)
                if match is not None:
                    data = {
                            "gus_id": w_record['Name'],
                            "test_type": "Ftest", 
                            "feature_name": feature, 
                            "scenario_name": acceptance['Name'], 
                            "scenario_detail": description, 
                            "test_build": opts.build, 
                            "timestamp": datetime.datetime.isoformat(datetime.datetime.now()), 
                            "pass_fail": random.choice([True, False]),                         
                            }
                    requests.post("https://the-test-log-server.herokuapp.com/execution", json.dumps(data), headers={'content-type':'application/json'})
                    print("Mock Run Scenario: {}_{} ({})".format(w_record['Name'], acceptance['Name'], data['pass_fail']))
    except Exception as e:
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2


if __name__ == "__main__":
    sys.exit(main())