#!/usr/bin/env python
# encoding: utf-8
'''
bin.gus_update_test_executions -- shortdesc

bin.gus_update_test_executions is a description

It defines classes_and_methods

@author:     user_name

@copyright:  2014 organization_name. All rights reserved.

@license:    license

@contact:    user_email
@deffield    updated: Updated
'''

import sys, traceback
import os, requests, re

from gus.QAForceClient import QAForceClient
from gus.BacklogClient import BacklogClient
from gherkin.Hierarchy import Hierarchy

from optparse import OptionParser

__all__ = []
__version__ = 0.1
__date__ = '2014-08-25'
__updated__ = '2014-08-25'

def main(argv=None):
    '''Command line options.'''

    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__

    program_version_string = '%%prog %s (%s)' % (program_version, program_build_date)
    #program_usage = '''usage: spam two eggs''' # optional - will be autogenerated by optparse
    program_longdesc = '''''' # optional - give further explanation about what the program does
    program_license = "Copyright 2014 user_name (organization_name)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"

    if argv is None:
        argv = sys.argv[1:]
    try:
        # setup option parser
        parser = OptionParser(version=program_version_string, epilog=program_longdesc, description=program_license)
        parser.add_option("-l", "--log-bugs", dest="log_bugs", action="store_true", help="Log Bugs for test failures in GUS")
        
        parser.set_default("log_bugs", False)
        
        # process options
        (opts, args) = parser.parse_args(argv)
        qa = QAForceClient()
        gus = BacklogClient()
        
        r = requests.get("https://the-test-log-server.herokuapp.com/execution", headers={'content-type':'application/json'})
        executions = r.json()
        
        for execution in executions:
            try:
                # create or update execution in gus
                work = qa.find_work(execution['gus_id'])
                ftest_id = "{}_{}".format(execution['gus_id'], execution['scenario_name'])
                
                # create heirarchy value
                hierarchy = Hierarchy().get_hierarchy(execution['scenario_path'])   
                
                test_case = qa.get_or_create_test_case_for_ftest(execution['scenario_name'], hierarchy, execution['test_type'], execution['scenario_detail'], ftest_id)
                if execution['test_type'] == 'Manual':
                    qa.get_or_create_test_execution_for_test_case(work['Id'], test_case['Id'])
                else:
                    if execution['pass_fail'] == True:
                        status = 'Passed'
                    else:
                        status = 'Failed'

                    if test_case['Execution_Type__c'] == 'Manual':
                        qa.change_test_type(test_case['Id'], 'FTest')
                        print("Flipping {} to type FTest due to automated execution".format(test_case['Name']))
                    
                    qa.record_test_execution(work['Id'], test_case['Id'], execution['test_build'], execution['timestamp'], status, execution['external_id'])
                    print("Updated Test Execution: {}".format(test_case['Name']))
                
                if status == 'Failed' and opts.log_bugs == True:
                    # create test failure bug for team
                    new_id = qa.create_test_failure_bug(work['Id'], test_case['Id'], execution['test_build'])
                    new_bug = qa.get_work_record(new_id)
                    print("Logged Bug {} Due to Failure of Test Case: {}".format(new_bug['Name'], execution['failure_message']))
                
                # update the acceptance criteria status
                ac_id = gus.get_specific_acceptance_criteria(work['Id'], execution['scenario_name'])
                gus.update_acceptance_criteria_status(ac_id, status)

                # delete the execution record from the log
                requests.delete("https://the-test-log-server.herokuapp.com/execution/{}".format(execution['id']))
            except Exception as e:
                traceback.print_exc()
                print("Error updating test cases: {}".format(e))
                raise e

    except Exception, e:
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2


if __name__ == "__main__":
    sys.exit(main())