#!/usr/bin/env python
# encoding: utf-8
'''
bin.gherkin_create_test_cases -- shortdesc

bin.gherkin_create_test_cases is a description

It defines classes_and_methods

@author:     user_name

@copyright:  2014 organization_name. All rights reserved.

@license:    license

@contact:    user_email
@deffield    updated: Updated
'''

import sys
import os, traceback

from optparse import OptionParser
from gherkin.GherkinAdapter import GherkinAdapter
from gherkin.Hierarchy import Hierarchy
from gus.QAForceClient import QAForceClient

__all__ = []
__version__ = 0.1
__date__ = '2014-09-10'
__updated__ = '2014-09-10'

def main(argv=None):
    '''Command line options.'''

    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__

    program_version_string = '%%prog %s (%s)' % (program_version, program_build_date)
    #program_usage = '''usage: spam two eggs''' # optional - will be autogenerated by optparse
    program_longdesc = '''''' # optional - give further explanation about what the program does
    program_license = "Copyright 2014 user_name (organization_name)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"

    if argv is None:
        argv = sys.argv[1:]
    try:
        # setup option parser
        parser = OptionParser(version=program_version_string, epilog=program_longdesc, description=program_license)
        
        # process options
        (opts, args) = parser.parse_args(argv)
        qa = QAForceClient()
        hgen = Hierarchy()

        # MAIN BODY #
        for arg in args:
            with open(arg, "rb") as feature_file:
                data = feature_file.read()
                feature_file.close()
                
            gherkin = GherkinAdapter(data)
            work = qa.find_work(gherkin.get_gus_id())
            
            for scenario in gherkin.get_scenarios():
                test_case = qa.get_or_create_test_case_for_ftest(
                                                             scenario.get_name(), 
                                                             hgen.get_hierarchy(os.path.dirname(arg)), 
                                                             "Manual", 
                                                             scenario.get_description(), 
                                                             "{}_{}".format(gherkin.get_gus_id(), scenario.get_name()))
                qa.get_or_create_test_execution_for_test_case(work['Id'], test_case['Id'])
                print("Updated Test Case: {}".format(test_case['Name']))

    except Exception, e:
        traceback.print_exc()
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2


if __name__ == "__main__":
    sys.exit(main())