#!/usr/bin/env python
# encoding: utf-8
'''
bin.mock_test_execution -- shortdesc

bin.mock_test_execution is a description

It defines classes_and_methods

@author:     user_name

@copyright:  2014 organization_name. All rights reserved.

@license:    license

@contact:    user_email
@deffield    updated: Updated
'''

import sys, traceback
import os, datetime, random, requests, json

from optparse import OptionParser
from gherkin.GherkinAdapter import GherkinAdapter

__all__ = []
__version__ = 0.1
__date__ = '2014-08-25'
__updated__ = '2014-08-25'

def main(argv=None):
    '''Command line options.'''

    program_name = os.path.basename(sys.argv[0])
    program_version = "v0.1"
    program_build_date = "%s" % __updated__

    program_version_string = '%%prog %s (%s)' % (program_version, program_build_date)
    #program_usage = '''usage: spam two eggs''' # optional - will be autogenerated by optparse
    program_longdesc = '''''' # optional - give further explanation about what the program does
    program_license = "Copyright 2014 user_name (organization_name)                                            \
                Licensed under the Apache License 2.0\nhttp://www.apache.org/licenses/LICENSE-2.0"

    if argv is None:
        argv = sys.argv[1:]
    try:
        # setup option parser
        parser = OptionParser(version=program_version_string, epilog=program_longdesc, description=program_license)
        parser.add_option("-b", "--build", dest="build", help="Build name to use")

        parser.set_default("build", "SC_195-001")
        
        # process options
        (opts, args) = parser.parse_args(argv)
        
        with open(args[0], "rb") as feature_file:
            data = feature_file.read()
            feature_file.close()
            
        gherkin = GherkinAdapter(data)
        
        for scenario in gherkin.get_scenarios():
            data = {
                    "gus_id": gherkin.get_gus_id(),
                    "external_id": "http://warm-ravine-1655.herokuapp.com/commits?gus_id=W-2237048",
                    "test_type": "Ftest", 
                    "feature_name": gherkin.get_feature_name(), 
                    "scenario_name": scenario.get_name(), 
                    "scenario_detail": "\n".join([x.get_description() for x in scenario.get_steps()]), 
                    "scenario_path": os.path.dirname(os.path.realpath(args[0])),
                    "test_build": opts.build, 
                    "timestamp": datetime.datetime.isoformat(datetime.datetime.now()), 
                    "pass_fail": random.choice([True, False]),  
                    "failure_message": "A Bad thing happened"                       
                    }
            requests.post("https://the-test-log-server.herokuapp.com/execution", json.dumps(data), headers={'content-type':'application/json'})
            print("Mock Run Scenario: {}_{} ({})".format(gherkin.get_gus_id(), scenario.get_name(), data['pass_fail']))
    except Exception as e:
        traceback.print_exc()
        indent = len(program_name) * " "
        sys.stderr.write(program_name + ": " + repr(e) + "\n")
        sys.stderr.write(indent + "  for help use --help")
        return 2


if __name__ == "__main__":
    sys.exit(main())