'''
Created on Sep 9, 2014

@author: scrosby
'''
from gherkin.Gherkin import Gherkin, Scenario
from gherkin.GherkinAdapter import ScenarioAdapter

class GherkinGusAdapter:
    def __init__(self, feature_name, gus_id, description):
        self.gherkin = Gherkin()
        self.gherkin.feature_name = feature_name
        self.gherkin.gus_id = gus_id
        self.gherkin.user_story = description
        
    def add_scenario(self, name, description):
        scenario_data = ScenarioAdapter(description)
        scenario = Scenario()
        scenario.name = name
        for step in scenario_data.get_steps():
            scenario.steps.append(step.to_object())
        scenario.is_outline = True
        examples = scenario_data.get_examples()
        if examples is not None:
            scenario.examples.extend(examples)
        else:
            scenario.is_outline = False        

        if name == 'Background':
            self.gherkin.background_steps = scenario
        else:
            self.gherkin.scenarios.append(scenario)
    
    def to_object(self):
        return self.gherkin
