#!/usr/bin/env python
import os

def main():
    print("Adding RubyMine GUS Integration Tools")
    print("If RubyMine is open, close it and run this command again")
    
    home = os.path.expanduser("~")
    
    rubydir = "{}/Library/Preferences/RubyMine60".format(home)
    if not os.path.exists(rubydir):
        rubydir = "{}/Library/Preferences/RubyMine50".format(home)
        print("You might want to upgrade to RubyMine 6.0...")
    
    tools = "{}/tools/GUS.xml".format(rubydir)
    
    path = os.path.dirname(os.path.realpath(__file__))
    
    data='''<?xml version="1.0" encoding="UTF-8"?>
<toolSet name="GUS">
  <tool name="Generate Feature File for GUS ID" description="Prompts for a User Story ID and generates a new feature file in the project directory" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_create_feature_file.py" />
      <option name="PARAMETERS" value="$Prompt$ -o $ProjectFileDir$/$FileRelativeDir$" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
  <tool name="Generate Feature Files For Team's Current Sprint" description="Generates feature files for all user stories in the current sprint for team specified" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_create_feature_file.py" />
      <option name="PARAMETERS" value="-t $Prompt$ -o $ProjectFileDir$/$FileRelativeDir$" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
  <tool name="Generate Test Cases in QA Force" description="Parses Gherkin text and Creates Test cases in GUS" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_create_test_cases.py" />
      <option name="PARAMETERS" value="$FilePath$" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
  <tool name="Log Test Results in GUS" description="Updates GUS with all test execution data it can find" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_update_test_executions.py" />
      <option name="PARAMETERS" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
  <tool name="Log Test Results in GUS - With Bugs" description="Updates GUS with all test execution data it can find" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_update_test_executions.py" />
      <option name="PARAMETERS" value="-l" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
  <tool name="Synchronize Feature file with GUS" description="Parses Gherkin text and uploads changes to GUS" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_sync_user_story.py" />
      <option name="PARAMETERS" value="$FilePath$" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
</toolSet>
'''.format(path=path)

    with open(tools, "wb") as tool_file:
        tool_file.write(data)
        tool_file.close()
        
    print("Done. Open RubyMine and Check out the GUS menu under 'Tools' or on Right Click.")
        
if __name__ == '__main__':
    main()