from setuptools import setup, find_packages
from distutils.command.install import install
import subprocess

class my_install(install):
    def run(self):
        install.run(self)
        print("Running RubyMine Setup for Mac...")
        subprocess.call('gherkin_tools_setup.py')

setup(
    #cmdclass = {'install': my_install},
    name='gherkin_tools',
    version='0.1.15',
    author='Shawn Crosby',
    author_email='scrosby@salesforce.com',
    packages=find_packages(),
    license='Keep it real',
    description='Parse Gherkin Files',
    long_description=open('README.md').read(),
    scripts=[
             "bin/gherkin_sync_user_story.py",
             "bin/gherkin_update_test_executions.py",
             "bin/gherkin_create_feature_file.py",
             "bin/mock_test_execution.py",
             "bin/gherkin_tools_setup.py",
             "bin/gherkin_create_test_cases.py",
             ],
    install_requires=[
        "gus_client>=0.5.11",
    ],
)