'''
Created on Sep 9, 2014

@author: scrosby
'''
from gherkin.Gherkin import Gherkin, Scenario
from gherkin.GherkinAdapter import ScenarioAdapter

class GherkinGusAdapter:
    '''
    This probably should just be called a GherkinBuilder as it constructs a Gherkin
    object using data fields
    '''
    def __init__(self, feature_name, gus_id, description):
        '''
        @param feature_name: Name of the user story
        @param gus_id: Gus W number
        @param description: The User story description
        '''
        self.gherkin = Gherkin()
        self.gherkin.feature_name = feature_name
        self.gherkin.gus_id = gus_id
        self.gherkin.user_story = description
        
    def add_scenario(self, name, description, gus_id=None, insert=False):
        '''
        Appends a scenario to the feature file
        
        @param name: Name of the scenario/acceptance criteria
        @param description: Body of the acceptance criteria
        '''
        scenario_data = ScenarioAdapter(description)
        scenario = Scenario()
        scenario.name = name
        scenario.for_gus_id = gus_id
        for step in scenario_data.get_steps():
            scenario.steps.append(step.to_object())
        examples = scenario_data.get_examples()
        if examples is not None:
            scenario.is_outline = True
            scenario.examples.extend(examples)

        if name == 'Background':
            if self.gherkin.background_steps:
                self.gherkin.background_steps.steps.extend(scenario.steps)
            else:
                self.gherkin.background_steps = scenario
        else:
            self.gherkin.scenarios.append(scenario)
            
    
    def to_object(self):
        '''
        Returns the assembled gherkin object
        '''
        return self.gherkin
