'''
Created on Sep 9, 2014

@author: scrosby
'''
class Gherkin:
    def __init__(self):
        self.feature_name = None
        self.user_story = None
        self.gus_id = None
        self.background_steps = None
        self.scenarios = []
        
    def to_string(self):
        ret = "@gus:{}\n".format(self.gus_id)
        ret += "Feature: {}\n\n".format(self.feature_name)
        
        if self.user_story is not None:
            ret += "{}\n\n".format(indent(self.user_story, 2))
            
        if self.background_steps is not None:
            ret += indent("Background:\n", 2)
            
            for step in self.background_steps.steps:
                ret += indent(step.to_string(), 4)
            ret += "\n"
                
        for scenario in self.scenarios:
            ret += "{}\n".format(scenario.to_string())

        return ret
            
        
class Scenario:
    def __init__(self):
        self.name = None
        self.is_outline = False
        self.for_gus_id = None
        self.steps = []
        self.examples = []
        
    def example_string(self):
        out = "Examples:\n"
        examples = self.examples
        out += "|"
        for h in examples[0].keys():
            out += " {} |".format(h)
            
        for example in examples:
            out += "\n|"
            for v in example.values():
                out += " {} |".format(v)
        return out
        
    def to_string(self):
        ret = ""
        if self.for_gus_id is not None:
            ret += "@gus_inherited:{}\n".format(self.for_gus_id)
        ret += "Scenario"
        if self.is_outline:
            ret += " Outline"
        ret += ": {}\n".format(self.name)
        
        out = "\n".join([x.to_string() for x in self.steps])
        if self.is_outline:
            out += "\n\n{}".format(self.example_string())
                    
        ret += indent(out, 2)
        
        return indent(ret, 2)
            
class Step:
    def __init__(self):
        self.prefix = None
        self.text = None
        
    def to_string(self):
        return "{} {}".format(self.prefix, self.text)
    
def indent(paragraph, spaces):
    out = ""
    lines = paragraph.strip().split("\n")
    for line in lines:
        out += "{}{}\n".format(" " * spaces, line)
    return out