'''
Created on Sep 1, 2014

@author: scrosby
'''
import re

class Gherkin:
    def __init__(self, feature_file_data):
        self.data = feature_file_data.replace("\r\n", "\n")
        
    def get_gus_id(self):
        match = re.search("@gus:(W-\d{7})", self.data)
        return match.group(1)
        
    def get_scenarios(self):
        out = []
        match = re.search("(Scenario( Outline)?:.*)$", self.data, flags=re.DOTALL|re.M)
        scenarios = match.group(1)
        lines = scenarios.split("\n")
        scenario = []
        for line in lines:
            if re.search("^\s*Scenario", line) is not None:
                if len(scenario) > 0:
                    if scenario[-1] == "":
                        scenario.pop()
                    out.append(Scenario("\n".join(scenario)))
                    scenario = []
            scenario.append(line)
        out.append(Scenario("\n".join(scenario)))
        
        return out
    
    def get_feature_name(self):
        match = re.search("Feature: (.*)\n", self.data)
        return match.group(1)
    
    def get_backgroud_steps(self):
        match = re.search("Background:(.*?)\n\n", self.data, flags=re.DOTALL)
        if match is not None:
            return Scenario(match.group(1))
        else:
            return None
    
class Scenario:
    def __init__(self, scenario_text):
        self.data = scenario_text
        
    def get_name(self):
        match = re.search("Scenario( Outline)?: (.*)\n", self.data)
        if match is not None:
            return match.group(2)
        else:
            return "Background"
    
    def is_outline(self):
        match = re.search("Scenario Outline:", self.data)
        return match is not None
    
    def get_examples(self):
        if self.is_outline():
            out = []
            match = re.search("Examples:\n(.*)", self.data, flags=re.DOTALL|re.M)
            lines = match.group(1).strip().split("\n")
            headings = [ x.strip() for x in lines[0].strip(" |").strip().split("|")]
            for line in lines[1:]:
                detail = {}
                values = [ x.strip() for x in line.strip(" |").strip().split("|")]
                x = 0
                for h in headings:
                    detail[h] = values[x]
                    x+=1
                out.append(detail)
            return out
        else:
            return None
    
    def get_steps(self):
        out = []
        matches = re.finditer("^\s*((Given|When|Then|And|But) .*)", self.data, flags=re.MULTILINE)
        for match in matches:
            out.append(Step(match.group(1)))
        return out
    
    def get_description(self):
        out = "\n".join([x.get_description() for x in self.get_steps()])
        if self.is_outline():
            out += "\n\nExamples:\n"
            examples = self.get_examples()
            out += "|"
            for h in examples[0].keys():
                out += " {} |".format(h)
                
            for example in examples:
                out += "\n|"
                for v in example.values():
                    out += " {} |".format(v)
        return out

class Step:
    def __init__(self, line):
        self.data = line
        match = re.search("^(Given|When|Then|And|But) (.*)", self.data)
        self.prefix = match.group(1)
        self.text = match.group(2)
        
    def get_description(self):
        return "{} {}".format(self.prefix, self.text)
        
    