'''
Created on Sep 8, 2014

@author: scrosby
'''
import os

def main():
    home = os.path.expanduser("~")
    tools = "{}/Library/Preferences/RubyMine60/tools/GUS.xml".format(home)
    
    path = os.path.dirname(os.path.realpath(__file__))
    
    data='''<?xml version="1.0" encoding="UTF-8"?>
<toolSet name="GUS">
  <tool name="Generate Feature File for GUS ID" description="Prompts for a User Story ID and generates a new feature file in the project directory" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_create_feature_file.py" />
      <option name="PARAMETERS" value="$Prompt$ -o $ProjectFileDir$" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
  <tool name="Generate Feature Files For Team Current Sprint" description="Generates feature files for all user stories in the current sprint for team specified" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_create_feature_file.py" />
      <option name="PARAMETERS" value="-t $Prompt$ -o $ProjectFileDir$" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
  <tool name="Update GUS Test Cases" description="Updates GUS with all test execution data it can find" showInMainMenu="true" showInEditor="true" showInProject="true" showInSearchPopup="true" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_update_test_executions.py" />
      <option name="PARAMETERS" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
  <tool name="Update Acceptance Criteria in GUS" description="Parses Gherkin text and uploads changes to GUS" showInMainMenu="true" showInEditor="true" showInProject="false" showInSearchPopup="false" disabled="false" useConsole="true" showConsoleOnStdOut="false" showConsoleOnStdErr="false" synchronizeAfterRun="true">
    <exec>
      <option name="COMMAND" value="{path}/gherkin_sync_user_story.py" />
      <option name="PARAMETERS" value="$FilePath$" />
      <option name="WORKING_DIRECTORY" value="$ProjectFileDir$" />
    </exec>
  </tool>
</toolSet>
'''.format(path=path)

    with open(tools, "wb") as tool_file:
        tool_file.write(data)
        tool_file.close()
        
if __name__ == '__main__':
    main()