'''
Created on Sep 1, 2014

@author: scrosby
'''
import unittest
from gherkin.Gherkin import Gherkin

data = '''
@gus:W-2352461
Feature: Display Acceptance criteria for developer on commit

  As a Developer
  I want to see all the acceptance criteria for the story I just finished 
  so that I can verify that I have coded it according to what QE and Product Management expects to see

  Background:
    Given that I am Logged into the application
    And I have a valid session
    And I don't have an error on the screen

  Scenario: Test cases should reflect the acceptance criteria
    When I look at a test case
    Then it should reflect the criteria that the product manager has specified for the Story
    And I would like a pony

  Scenario: Acceptance criteria details should be formatted as Gherkin
    When I view the details of an acceptance criterion
    Then I can see that is human as well as machine readable
    And I can run it as a cucumber test

  Scenario: Acceptance criteria should be testable
    When I view acceptance criteria
    Then I should be able to determine what the intended outcome is

  Scenario: New Acceptance criteria for each test case
    When an acceptance criteria is created
    Then there should be a test case created

  Scenario: Acceptance criteria should be recorded in Gus
    When I look at the user story in gus
    Then I should be able to read all the acceptance criteria

  Scenario: Test case when and then format should be able to written in any order
    Given that we have at least one acceptance criteria
    And it is in the gherkin format
    When I use the command to export to a feature file
    And I display it on the screen
    Then I should see the full acceptance criteria there
    And it should be readable

  Scenario Outline: Acceptance criteria should be generated if <value> is present
    When i use the keyword <value> at the beginning of the line
    Then the scenario should be generated
    
    Examples:
    | value |
    | Given |
    | When |
    | Then |

  Scenario Outline: Calendar views should show network posts created via api
    When I create a new "<network>" post via api
    Then the network post should successfully be created
    And verify network post id should be part of calendar "<view>"

    Examples:
    | network   | view    |
    | facebook | day     |
    | facebook | week   |
    | twitter      | day     |
    | twitter      | week   |

  Scenario: Can generate scenario outlines
    When I use the Example: keyword followed by a new line
    Then the script will output a scenario outline instead of a scenario for the ac

  Scenario: Can generate a precondition from ac
    When I make the name of the AC "Background"
    Then the script will use the body of the ac as the 'Background' section

'''

class Test(unittest.TestCase):


    def setUp(self):
        self.g = Gherkin(data)

    def tearDown(self):
        self.g = None
    
    def test_can_get_gus_id(self):
        self.assertEqual("W-2352461", self.g.get_gus_id(), "Didn't get gus Id")

    def test_get_scenarios(self):
        length = len(self.g.get_scenarios())
        self.assertEqual(10, length, "Wrong Number of scenarios: {}".format(length))
        
    def test_can_get_scenario_name(self):
        self.assertEqual("Test cases should reflect the acceptance criteria", self.g.get_scenarios()[0].get_name(), "Didn't get correct Name")
        
    def test_can_get_scenario_name_for_outline(self):
        name = self.g.get_scenarios()[6].get_name()
        self.assertEqual("Acceptance criteria should be generated if <value> is present", name, "Didn't get name for outline")
        
    def test_can_determine_outline(self):
        self.assertTrue(self.g.get_scenarios()[6].is_outline(), "Couldn't detect outline")
        self.assertFalse(self.g.get_scenarios()[0].is_outline(), "Incorrectly determined as outline")
        
    def test_can_find_steps(self):
        steps = self.g.get_scenarios()[0].get_steps()
        self.assertEqual(3, len(steps), "Incorrect Number of steps: {}".format(len(steps)))
        
    def test_can_find_feature_name(self):
        self.assertEqual("Display Acceptance criteria for developer on commit", self.g.get_feature_name(), "Didn't get the right feature name")

    def test_can_get_examples(self):
        ex = self.g.get_scenarios()[6].get_examples()
        ex2 = self.g.get_scenarios()[7].get_examples()
        self.assertEqual(3, len(ex), "Wrong number of examples: {}".format(len(ex)))
        self.assertEqual("Then", ex[2]['value'], "didn't get the right value {}".format(ex[2]['value']))
        self.assertEqual("week", ex2[1]['view'], "Didn't get right example value {}:{}".format("view", ex2[2]['view']))
        
    def test_can_get_step_prefix(self):
        p = self.g.get_scenarios()[0].get_steps()[0].prefix
        self.assertEqual("When", p, "Didn't get correct prefix {}".format(p))
        
    def test_can_get_step_text(self):
        t = self.g.get_scenarios()[0].get_steps()[0].text
        self.assertEqual("I look at a test case", t, "Didn't get correct text: {}".format(t))
        
    def test_can_get_background_steps(self):
        background = self.g.get_backgroud_steps()
        self.assertEqual(3, len(background.get_steps()), "Didn't get Background Steps")
        self.assertEqual("that I am Logged into the application", background.get_steps()[0].text, "Unexpected step definition")
        
    def test_can_generate_description(self):
        s1 = '''When I look at a test case
Then it should reflect the criteria that the product manager has specified for the Story
And I would like a pony'''
        
        s6 = '''When i use the keyword <value> at the beginning of the line
Then the scenario should be generated

Examples:
| value |
| Given |
| When |
| Then |'''
        s7 = '''When I create a new "<network>" post via api
Then the network post should successfully be created
And verify network post id should be part of calendar "<view>"

Examples:
| network   | view    |
| facebook | day     |
| facebook | week   |
| twitter      | day     |'''
        d1 = self.g.get_scenarios()[0].get_description()
        self.assertEqual(d1, s1, "Incorrect Description for scenario:\n{}\n\n{}".format(d1, s1))
        d6 = self.g.get_scenarios()[6].get_description()
        self.assertEqual(d6, s6, "Incorrect Description for scenario outline:\n{}\n\n{}".format(d6, s6))
if __name__ == "__main__":
    #import sys;sys.argv = ['', 'Test.test_get_scenarios']
    unittest.main()