#!/usr/bin/env python
#
# ginvoke: a programmable launcher for GTK+
# Copyright (C) 2011 Thomas Lee
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

try:
    from setuptools import setup, find_packages
except ImportError:
    from ez_setup import use_setuptools
    use_setuptools()
    from setuptools import setup, find_packages

import ginvoke

LONG_DESCRIPTION = """A programmable launcher for GNOME/GTK+ written with
software developers in mind.

Includes out-of-the-box support for launching executables and URLs via
customizable commands, which are specified in a user-customizable Python script
($HOME/.ginvokerc).
"""

setup(name="ginvoke",
      version="%d.%d.%d" % ginvoke.VERSION,
      description="A programmable QuickSilver/Gnome Do/Executor clone for GTK+",
      long_description=LONG_DESCRIPTION,
      author="Tom Lee",
      author_email="pypi@tomlee.co",
      maintainer="Tom Lee",
      maintainer_email="pypi@tomlee.co",
      url="http://github.com/thomaslee/ginvoke",
      license="GPLv3",
      packages=find_packages(),
      package_data={"ginvoke": ["data/pixmaps/*"]},
      entry_points={
          'console_scripts': [
              'ginvoke = ginvoke:run'
          ]
      },
      data_files=[
          ('share/pixmaps', ['ginvoke/data/pixmaps/ginvoke.png'])
      ]
)
