import os

import gtk

class CommandStore(gtk.ListStore):
    TYPE_KEYWORD = 1
    TYPE_EXECUTABLE = 2

    def __init__(self, commands):
        gtk.ListStore.__init__(self, str, int)

        self.commands = commands
        self.loadcommands()
        self.loadpath()

    def loadcommands(self):
        for command in self.commands:
            self.append((command, self.TYPE_KEYWORD))

    def loadpath(self):
        for dirname in os.environ["PATH"].split(os.path.pathsep):
            for filename in os.listdir(dirname):
                if filename in ("."):
                    continue
                self.append((filename, self.TYPE_EXECUTABLE))

