#
# ginvoke: a programmable launcher for GTK+
# Copyright (C) 2011 Thomas Lee
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import socket
import struct

import gobject

class Client(gobject.GObject):
    def __init__(self, settings):
        gobject.GObject.__init__(self)

        self.settings = settings
        self.sck = None

        self.sck = socket.socket(socket.AF_INET, socket.SOCK_STREAM, 0)
        try:
            setlinger(self.sck, 0.2)
            self.sck.connect((settings.host, settings.port))
        except socket.error:
            self.sck.close()
            self.sck = None

    def _isconnected(self):
        return self.sck is not None
    connected = property(_isconnected)

    def close(self):
        if self.sck:
            self.sck.shutdown(socket.SHUT_RDWR)
            self.sck.close()
            self.sck = None

class Server(gobject.GObject):
    def __init__(self, settings):
        gobject.GObject.__init__(self)

        self.settings = settings
        self._start()

    def _running(self):
        return self.serversocket is not None
    running = property(_running)

    def stop(self):
        if self.serversocket:
            self.serversocket.close()
            self.serversocket = None

    def _start(self):
        def onconnect(fd, *args):
            sck = socket.fromfd(fd, socket.AF_INET, socket.SOCK_STREAM)
            try:
                client, addr = sck.accept()
                self.emit('connection')
                setlinger(client, 0.2)
                try:
                    client.shutdown(socket.SHUT_RDWR)
                finally:
                    client.close()
            except socket.error as err:
                pass
            return True
        self.serversocket = socket.socket(socket.AF_INET, socket.SOCK_STREAM, 0)
        try:
            self.serversocket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
            self.serversocket.bind((self.settings.host, self.settings.port))
            self.serversocket.listen(socket.SOMAXCONN)
            gobject.io_add_watch(self.serversocket.fileno(), gobject.IO_IN, onconnect)
        except socket.error:
            self.serversocket.close()
            self.serversocket = None

gobject.signal_new("connection", Server, gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [])

def setlinger(sck, linger):
    sck.setsockopt(socket.SOL_SOCKET, socket.SO_LINGER, struct.pack('ii', 1, linger))

