import gtk
import pango

from ..engine import BadCommandException

from .model import CommandStore
from .common import get_icon_pixbuf

class Entry(gtk.Entry):
    def __init__(self, engine):
        gtk.Entry.__init__(self)

        settings = engine.settings
        settings.commands.connect('reset', self.commands_reset)
        settings.commands.connect('add', self.commands_add)

        self.completion = gtk.EntryCompletion()
        self.model = CommandStore(settings.commands)
        self.completion.set_model(self.model)
        self.completion.set_text_column(0)
        self.completion.set_inline_completion(True)
        self.completion.set_inline_selection(True)
        self.completion.set_popup_completion(False)
        # XXX doesn't work
        # self.completion.connect("match-selected", self.completion_matchselected)

        self.set_width_chars(30)
        self.set_has_frame(False)
        border = gtk.Border()
        border.top = border.left = border.right = border.bottom = 20
        self.set_inner_border(border)
        self.set_alignment(0.5)
        # self.set_icon_from_pixbuf(gtk.ENTRY_ICON_PRIMARY, get_icon_pixbuf())
        self.modify_font(pango.FontDescription("sans bold 16"))
        self.set_completion(self.completion)

    def commands_reset(self, commands):
        # TODO only remove TYPE_COMMAND items
        self.model.clear()

    def commands_add(self, commands, command):
        self.model.append((command, CommandStore.TYPE_KEYWORD))

    # XXX doesn't work
    #def completion_matchselected(self, sender, model, it):
    #    it_type = model.get_value(it, 1)
    #    if it_type in (CommandStore.TYPE_KEYWORD, CommandStore.TYPE_EXECUTABLE):
    #        self.set_text(self.get_text() + " ")

